/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmBasicMappingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithMutableBasicDate() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "mutable", "java.util.Date"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Mutable").append(CR);
                sb.append("    private Date myDate;").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public EclipseLinkOrmBasicMappingTests(String name) {
        super(name);
    }

    public void testUpdateMutable() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmEclipseLinkBasicMapping contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkBasicMapping javaBasicMapping = (EclipseLinkBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        javaBasicMapping.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        EclipseLinkBasicMapping virtualContextBasic = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)virtualContextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)virtualContextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)virtualContextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        virtualContextBasic = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)virtualContextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)virtualContextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)virtualContextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)javaBasicMapping.getMutable().isMutable());
    }

    public void testUpdateMutableDate() throws Exception {
        this.createTestEntityWithMutableBasicDate();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "myDate");
        OrmEclipseLinkBasicMapping contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkBasicMapping javaBasicMapping = (EclipseLinkBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("myDate").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        resourceBasic.setMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        this.getPersistenceUnit().getOptions().setTemporalMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        javaBasicMapping.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("myDate");
        EclipseLinkBasicMapping virtualContextBasic = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)virtualContextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)virtualContextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)virtualContextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("myDate");
        virtualContextBasic = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)virtualContextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)virtualContextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)virtualContextBasic.getMutable().isMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)javaBasicMapping.getMutable().isMutable());
    }

    public void testModifyMutable() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basic");
        OrmEclipseLinkBasicMapping contextBasic = (OrmEclipseLinkBasicMapping)ormPersistentAttribute.getMapping();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlBasic resourceBasic = (XmlBasic)resourceEntity.getAttributes().getBasics().get(0);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(Boolean.TRUE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.TRUE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertTrue((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(Boolean.FALSE);
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertEquals((Object)Boolean.FALSE, (Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
        contextBasic.getMutable().setSpecifiedMutable(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)resourceBasic.getMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isDefaultMutable());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)contextBasic.getMutable().getSpecifiedMutable());
        EclipseLinkOrmBasicMappingTests.assertFalse((boolean)contextBasic.getMutable().isMutable());
    }

    public void testUpdateConvert() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        basicResource.setConvert("myConvert");
        EclipseLinkOrmBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"myConvert", (String)basicResource.getConvert());
        basicResource.setConvert(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        javaBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)javaBasicMapping.getConverter()).setSpecifiedConverterName("foo");
        EclipseLinkOrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaBasicMapping.getConverter()).getSpecifiedConverterName());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        EclipseLinkBasicMapping virtualBasicMapping = (EclipseLinkBasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"foo", (String)((EclipseLinkConvert)javaBasicMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)javaBasicMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getSpecifiedConverterName());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)javaBasicMapping.getConverter()).getSpecifiedConverterName());
        javaBasicMapping.setConverter(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertNull((Object)javaBasicMapping.getConverter().getType());
    }

    public void testModifyConvert() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        XmlBasic basicResource = (XmlBasic)((org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"", (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormBasicMapping.getConverter().getType());
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setSpecifiedConverterName("bar");
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)basicResource.getConvert());
        EclipseLinkOrmBasicMappingTests.assertEquals(EclipseLinkConvert.class, (Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals((String)"bar", (String)((EclipseLinkConvert)ormBasicMapping.getConverter()).getSpecifiedConverterName());
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setSpecifiedConverterName(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
        ormBasicMapping.setConverter(null);
        EclipseLinkOrmBasicMappingTests.assertNull((Object)ormBasicMapping.getConverter().getType());
        EclipseLinkOrmBasicMappingTests.assertEquals(null, (String)basicResource.getConvert());
    }
}

