/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmStructConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @StructConverter");
            }
        });
    }

    public EclipseLinkOrmStructConverterTests(String name) {
        super(name);
    }

    public void testUpdateConverter() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkStructConverter.class);
        EclipseLinkStructConverter ormConverter = (EclipseLinkStructConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        converterResource.setConverter("myConvert");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)converterResource.getConverter());
        converterResource.setConverter(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        BasicMapping virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        ormConverter = (EclipseLinkStructConverter)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getConverter();
        EclipseLinkStructConverter javaConverter = (EclipseLinkStructConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setConverterClass("bar");
        EclipseLinkOrmStructConverterTests.assertNull((Object)ormConverter);
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getConverterClass());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmStructConverterTests.assertNull((Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getConverterClass());
    }

    public void testModifyConverter() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkStructConverter.class);
        EclipseLinkStructConverter ormConverter = (EclipseLinkStructConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
        ormConverter.setConverterClass("foo");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)converterResource.getConverter());
        ormConverter.setConverterClass(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getConverterClass());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getConverter());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "id");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkStructConverter.class);
        OrmEclipseLinkStructConverter ormConverter = (OrmEclipseLinkStructConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
        ormPersistentAttribute.convertToVirtual();
        OrmReadOnlyPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("id");
        BasicMapping virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkStructConverter virtualConverter = (EclipseLinkStructConverter)((EclipseLinkConvert)virtualBasicMapping.getConverter()).getConverter();
        EclipseLinkStructConverter javaConverter = (EclipseLinkStructConverter)((EclipseLinkConvert)javaBasicMapping.getConverter()).getConverter();
        javaConverter.setName("bar");
        EclipseLinkOrmStructConverterTests.assertNull((Object)virtualConverter);
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        ormPersistentAttribute2 = (OrmReadOnlyPersistentAttribute)ormPersistentType.getVirtualAttributes().iterator().next();
        virtualBasicMapping = (BasicMapping)ormPersistentAttribute2.getMapping();
        EclipseLinkOrmStructConverterTests.assertNull((Object)virtualBasicMapping.getConverter().getType());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"bar", (String)javaConverter.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("basic", "basicMapping");
        OrmBasicMapping ormBasicMapping = (OrmBasicMapping)ormPersistentAttribute.getMapping();
        ormBasicMapping.setConverter(EclipseLinkConvert.class);
        ((EclipseLinkConvert)ormBasicMapping.getConverter()).setConverter(EclipseLinkStructConverter.class);
        OrmEclipseLinkStructConverter ormConverter = (OrmEclipseLinkStructConverter)((EclipseLinkConvert)ormBasicMapping.getConverter()).getConverter();
        XmlStructConverter converterResource = ((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getStructConverter();
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmStructConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

