/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmTransientMappingTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkOrmTransientMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithTransientMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Transient"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Transient").append(CR);
            }
        });
    }

    public void testCreateTransientMapping() throws Exception {
        this.createTestEntityWithTransientMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmReadOnlyPersistentAttribute persistentAttribute = ormPersistentType.getAttributeNamed("id");
        EclipseLinkOrmTransientMappingTests.assertTrue((boolean)persistentAttribute.isVirtual());
        EclipseLinkOrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute.getMappingKey());
        OrmPersistentAttribute persistentAttribute2 = persistentAttribute.convertToSpecified("transient");
        EclipseLinkOrmTransientMappingTests.assertFalse((boolean)persistentAttribute2.isVirtual());
        EclipseLinkOrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute2.getMappingKey());
        EclipseLinkOrmTransientMappingTests.assertEquals((String)"transient", (String)persistentAttribute2.getMapping().getKey());
    }
}

