/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class TypeConverterAnnotationTests
extends EclipseLinkJavaResourceModelTestCase {
    public TypeConverterAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TypeConverter");
            }
        });
    }

    private ICompilationUnit createTestTypeConverterWithDataType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TypeConverter(dataType = Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestTypeConverterWithObjectType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TypeConverter(objectType = Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestTypeConverterWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@TypeConverter(name = \"bar\")");
            }
        });
    }

    public void testTypeConverterAnnotation() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverter();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        TypeConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        resourceField.removeAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
        resourceField.addAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertNotNull((Object)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter"));
    }

    public void testGetTypeDataType() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithDataType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getDataType());
    }

    public void testSetDataType() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithDataType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType("Bar");
        TypeConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getDataType());
        this.assertSourceContains("@TypeConverter(dataType = Bar.class)", cu);
        converter.setDataType("int");
        TypeConverterAnnotationTests.assertEquals((String)"int", (String)converter.getDataType());
        this.assertSourceContains("@TypeConverter(dataType = int.class)", cu);
    }

    public void testSetDataTypeNull() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithDataType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType(null);
        TypeConverterAnnotationTests.assertNull((Object)converter.getDataType());
        this.assertSourceContains("@TypeConverter", cu);
        this.assertSourceDoesNotContain("dataType", cu);
    }

    public void testGetTypeObjectType() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithObjectType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getObjectType());
    }

    public void testSetObjectType() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithObjectType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType("Bar");
        TypeConverterAnnotationTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        this.assertSourceContains("@TypeConverter(objectType = Bar.class)", cu);
        converter.setObjectType("int");
        TypeConverterAnnotationTests.assertEquals((String)"int", (String)converter.getObjectType());
        this.assertSourceContains("@TypeConverter(objectType = int.class)", cu);
    }

    public void testSetObjectTypeNull() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithObjectType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType(null);
        TypeConverterAnnotationTests.assertNull((Object)converter.getObjectType());
        this.assertSourceContains("@TypeConverter", cu);
        this.assertSourceDoesNotContain("objectType", cu);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName("foo");
        TypeConverterAnnotationTests.assertEquals((String)"foo", (String)converter.getName());
        this.assertSourceContains("@TypeConverter(name = \"foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestTypeConverterWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)CollectionTools.get((Iterable)resourceType.getFields(), (int)0);
        EclipseLinkTypeConverterAnnotation converter = (EclipseLinkTypeConverterAnnotation)resourceField.getAnnotation("org.eclipse.persistence.annotations.TypeConverter");
        TypeConverterAnnotationTests.assertEquals((String)"bar", (String)converter.getName());
        converter.setName(null);
        TypeConverterAnnotationTests.assertNull((Object)converter.getName());
        this.assertSourceContains("@TypeConverter", cu);
        this.assertSourceDoesNotContain("name=", cu);
    }
}

