/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterables;

import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterables.ReadOnlyIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyIterableTests
extends TestCase {
    public ReadOnlyIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        Iterator<String> nestedIterator = this.buildVector().iterator();
        for (String s : this.buildReadOnlyIterable()) {
            ReadOnlyIterableTests.assertEquals((String)nestedIterator.next(), (String)s);
        }
    }

    public void testRemove() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildReadOnlyIterable().iterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyIterableTests.assertTrue((boolean)exCaught);
    }

    public void testToString() {
        ReadOnlyIterableTests.assertNotNull((Object)this.buildReadOnlyIterable().toString());
    }

    private Iterable<String> buildReadOnlyIterable() {
        return new ReadOnlyIterable(this.buildVector());
    }

    private Vector<String> buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }
}

