/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.StringMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStringMatcher<T>
implements StringMatcher,
Filter<T>,
Serializable {
    private StringConverter<T> stringConverter;
    private String patternString;
    private boolean ignoresCase;
    private Pattern pattern;
    public static final char[] REG_EX_META_CHARS = new char[]{'(', '[', '{', '\\', '^', '$', '|', ')', '?', '*', '+', '.'};
    private static final long serialVersionUID = 1L;

    public SimpleStringMatcher() {
        this("*");
    }

    public SimpleStringMatcher(String patternString) {
        this(patternString, true);
    }

    public SimpleStringMatcher(String patternString, boolean ignoresCase) {
        this.patternString = patternString;
        this.ignoresCase = ignoresCase;
        this.initialize();
    }

    protected void initialize() {
        this.stringConverter = StringConverter.Default.instance();
        this.rebuildPattern();
    }

    protected synchronized void rebuildPattern() {
        this.pattern = this.buildPattern();
    }

    protected Pattern buildPattern() {
        int patternFlags = 0;
        if (this.ignoresCase) {
            patternFlags = 66;
        }
        return Pattern.compile(this.convertToRegEx(this.patternString), patternFlags);
    }

    @Override
    public synchronized void setPatternString(String patternString) {
        this.patternString = patternString;
        this.rebuildPattern();
    }

    @Override
    public synchronized boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    @Override
    public synchronized boolean accept(T o) {
        return this.matches(this.stringConverter.convertToString(o));
    }

    public synchronized StringConverter<T> stringConverter() {
        return this.stringConverter;
    }

    public synchronized void setStringConverter(StringConverter<T> stringConverter) {
        this.stringConverter = stringConverter;
    }

    public synchronized String patternString() {
        return this.patternString;
    }

    public synchronized boolean ignoresCase() {
        return this.ignoresCase;
    }

    public synchronized void setIgnoresCase(boolean ignoresCase) {
        this.ignoresCase = ignoresCase;
        this.rebuildPattern();
    }

    public synchronized Pattern pattern() {
        return this.pattern;
    }

    public synchronized String regularExpression() {
        return this.convertToRegEx(this.patternString);
    }

    protected String convertToRegEx(String string) {
        StringBuffer sb = new StringBuffer(string.length() + 10);
        this.convertToRegExOn(this.prefix(), sb);
        this.convertToRegExOn(string, sb);
        this.convertToRegExOn(this.suffix(), sb);
        return sb.toString();
    }

    protected String prefix() {
        return "";
    }

    protected String suffix() {
        return "*";
    }

    protected void convertToRegExOn(String string, StringBuffer sb) {
        char[] charArray = string.toCharArray();
        int length = charArray.length;
        int i = 0;
        while (i < length) {
            char c = charArray[i];
            if (c == '*') {
                sb.append(".*");
            } else if (c == '?') {
                sb.append('.');
            } else {
                if (ArrayTools.contains(REG_EX_META_CHARS, c)) {
                    sb.append('\\');
                }
                sb.append(c);
            }
            ++i;
        }
    }
}

