/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.ui.internal.dialogs.OptionalMessageDialog;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.SchemaLibrary;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorExtensionOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.GenerateJaxbClassesJob;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiPlugin;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.ClassesGeneratorWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDSchema;

public class ClassesGeneratorUi {
    private final IJavaProject javaProject;
    private final IFile xsdFile;

    public static void generate(IFile xsdFile) {
        IJavaProject javaProject = JavaCore.create((IProject)xsdFile.getProject());
        if (javaProject == null) {
            throw new NullPointerException();
        }
        new ClassesGeneratorUi(javaProject, xsdFile).generate();
    }

    private ClassesGeneratorUi(IJavaProject javaProject, IFile xsdFile) {
        if (javaProject == null) {
            throw new NullPointerException();
        }
        this.javaProject = javaProject;
        this.xsdFile = xsdFile;
    }

    protected void generate() {
        ClassesGeneratorWizard wizard = new ClassesGeneratorWizard(this.javaProject, this.xsdFile);
        wizard.setWindowTitle(JptJaxbUiMessages.ClassesGeneratorWizard_title);
        WizardDialog dialog = new WizardDialog(this.getCurrentShell(), (IWizard)wizard);
        dialog.create();
        int returnCode = dialog.open();
        if (returnCode != 0) {
            return;
        }
        if (this.displayOverwritingClassesWarning(wizard.getGeneratorOptions())) {
            this.generateJaxbClasses(wizard.getLocalSchemaUri(), wizard.getDestinationFolder(), wizard.getTargetPackage(), wizard.getCatalog(), wizard.usesMoxy(), wizard.getBindingsFileNames(), wizard.getGeneratorOptions(), wizard.getGeneratorExtensionOptions());
            this.addSchemaToLibrary(wizard.getSchemaLocation());
        }
    }

    private void generateJaxbClasses(URI schemaUri, String outputDir, String targetPackage, String catalog, boolean usesMoxyGenerator, String[] bindingsFileNames, ClassesGeneratorOptions generatorOptions, ClassesGeneratorExtensionOptions generatorExtensionOptions) {
        try {
            GenerateJaxbClassesJob job = new GenerateJaxbClassesJob(this.javaProject, schemaUri.toString(), outputDir, targetPackage, catalog, usesMoxyGenerator, bindingsFileNames, generatorOptions, generatorExtensionOptions);
            job.schedule();
        }
        catch (RuntimeException re) {
            JptJaxbUiPlugin.log(re);
            String msg = re.getMessage();
            String message = msg == null ? re.toString() : msg;
            this.logError(message);
        }
    }

    private void addSchemaToLibrary(String schemaLocation) {
        SchemaLibrary schemaLib;
        Vector<String> schemas;
        JaxbProject jaxbProject = this.getJaxbProject();
        if (jaxbProject == null) {
            return;
        }
        String resolvedUri = XsdUtil.getResolvedUri((String)schemaLocation);
        XSDSchema schema = XSDImpl.buildXSDModel((String)resolvedUri);
        if (schema != null && !(schemas = new Vector<String>((schemaLib = jaxbProject.getSchemaLibrary()).getSchemaLocations())).contains(schemaLocation)) {
            schemas.add(schemaLocation);
            schemaLib.setSchemaLocations(schemas);
        }
    }

    private void logError(String message) {
        this.displayError(message);
    }

    private void displayError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)JptJaxbUiMessages.ClassesGeneratorWizard_errorDialogTitle, (String)message);
    }

    private Shell getShell() {
        Shell[] shells;
        Shell shell;
        Display display = Display.getCurrent();
        Shell shell2 = shell = display == null ? null : display.getActiveShell();
        if (shell == null && display != null && (shells = display.getShells()).length > 0) {
            shell = shells[0];
        }
        return shell;
    }

    private JaxbProject getJaxbProject() {
        return JptJaxbCorePlugin.getJaxbProject((IProject)this.javaProject.getProject());
    }

    private boolean isOverwritingClasses(ClassesGeneratorOptions generatorOptions) {
        if (generatorOptions == null) {
            throw new NullPointerException();
        }
        return !generatorOptions.showsVersion() && !generatorOptions.showsHelp();
    }

    private boolean displayOverwritingClassesWarning(ClassesGeneratorOptions generatorOptions) {
        if (!this.isOverwritingClasses(generatorOptions) || !OptionalMessageDialog.isDialogEnabled((String)"dontShowOverwriteJaxbClassesFromSchemas.warning")) {
            return true;
        }
        OverwriteConfirmerDialog dialog = new OverwriteConfirmerDialog(this.getShell());
        return dialog.open() == 2;
    }

    private Shell getCurrentShell() {
        return Display.getCurrent().getActiveShell();
    }

    static class OverwriteConfirmerDialog
    extends OptionalMessageDialog {
        private static final String ID = "dontShowOverwriteJaxbClassesFromSchemas.warning";

        OverwriteConfirmerDialog(Shell parent) {
            super(ID, parent, JptJaxbUiMessages.ClassesGeneratorUi_generatingClassesWarningTitle, JptJaxbUiMessages.ClassesGeneratorUi_generatingClassesWarningMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
        }
    }
}

