/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TableModelAdapter;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.SchemaEntry;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.properties.JaxbProjectModel;
import org.eclipse.jpt.jaxb.ui.internal.wizards.classesgen.SelectFileOrXMLCatalogIdPanel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbSchemasPropertiesPage
extends PropertyPage {
    private static final int SIZING_SELECTION_PANE_WIDTH = 450;
    protected final WritablePropertyValueModel<IProject> projectModel = new SimplePropertyValueModel();
    private final PropertyValueModel<JaxbProject> jaxbProjectModel = new JaxbProjectModel((PropertyValueModel<IProject>)this.projectModel);
    protected final BufferedWritablePropertyValueModel.Trigger trigger = new BufferedWritablePropertyValueModel.Trigger();
    private final SchemasModel schemasModel = new SchemasModel(this.jaxbProjectModel, (PropertyValueModel<Boolean>)this.trigger);
    private final WritableCollectionValueModel<Schema> schemasSelectionModel = new SimpleCollectionValueModel();

    public JaxbSchemasPropertiesPage() {
        this.setDescription(JptJaxbUiMessages.SchemasPage_description);
    }

    protected IProject getProject() {
        return (IProject)this.projectModel.getValue();
    }

    public final void createControl(Composite parent) {
        super.createControl(parent);
        Button revertButton = this.getDefaultsButton();
        revertButton.setText(JptJaxbUiMessages.SchemasPage_revert);
        GridData gd = new GridData(256);
        Point minButtonSize = revertButton.computeSize(-1, -1, true);
        gd.widthHint = Math.max(this.convertHorizontalDLUsToPixels(61), minButtonSize.x);
        revertButton.setLayoutData((Object)gd);
        this.updateButtons();
        this.getShell().layout(true, true);
    }

    protected final Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        IProject project = null;
        project = element instanceof IProject ? (IProject)element : (IProject)Platform.getAdapterManager().loadAdapter((Object)element, IProject.class.getName());
        this.projectModel.setValue((Object)project);
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 450;
        pageComponent.setLayoutData((Object)data);
        Label schemasLabel = new Label(pageComponent, 16384);
        schemasLabel.setText(JptJaxbUiMessages.SchemasPage_schemas);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        schemasLabel.setLayoutData((Object)data);
        Composite tableComposite = new Composite(pageComponent, 0);
        data = new GridData(4, 4, true, true);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.widthHint = 450;
        tableComposite.setLayoutData((Object)data);
        TableViewer schemasTable = new TableViewer(tableComposite, 67586);
        TableModelAdapter.adapt((ListValueModel)new SortedListValueModelAdapter((CollectionValueModel)this.schemasModel), this.schemasSelectionModel, (Table)schemasTable.getTable(), (ColumnAdapter)new SchemaColumnAdapter(), (ITableLabelProvider)new SchemaTableLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)schemasTable, (int)2);
        schemasTable.getTable().setHeaderVisible(true);
        schemasTable.getTable().setToolTipText(null);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)schemasTable.getTable().getColumn(0), (ColumnLayoutData)new ColumnWeightData(15));
        tableLayout.setColumnData((Widget)schemasTable.getTable().getColumn(1), (ColumnLayoutData)new ColumnWeightData(25));
        tableComposite.setLayout((Layout)tableLayout);
        data = new GridData(1808);
        data.heightHint = schemasTable.getTable().getItemHeight() * 7;
        data.widthHint = 200;
        schemasTable.getTable().setLayoutData((Object)data);
        this.createButtonGroup(pageComponent);
        Dialog.applyDialogFont((Control)parent);
        return pageComponent;
    }

    protected void createButtonGroup(Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        Button addButton = new Button(groupComponent, 8);
        addButton.setText(JptJaxbUiMessages.SchemasPage_addButtonLabel);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxbSchemasPropertiesPage.this.addSchema();
            }
        });
        this.setButtonLayoutData(addButton);
        Button editButton = new Button(groupComponent, 8);
        editButton.setText(JptJaxbUiMessages.SchemasPage_editButtonLabel);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxbSchemasPropertiesPage.this.editSelectedSchema();
            }
        });
        SWTTools.controlEnabledState(this.buildEditEnabledModel(), (Control[])new Control[]{editButton});
        this.setButtonLayoutData(editButton);
        Button removeButton = new Button(groupComponent, 8);
        removeButton.setText(JptJaxbUiMessages.SchemasPage_removeButtonLabel);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JaxbSchemasPropertiesPage.this.removeSelectedSchemas();
            }
        });
        SWTTools.controlEnabledState(this.buildRemoveEnabledModel(), (Control[])new Control[]{removeButton});
        this.setButtonLayoutData(removeButton);
    }

    private void addSchema() {
        AddEditSchemaDialog dialog = new AddEditSchemaDialog(this.getShell(), null, (Iterable<Schema>)this.schemasModel.getValue());
        if (dialog.open() == 1) {
            return;
        }
        Schema schema = this.schemasModel.addSchema(dialog.getNamespace(), dialog.getLocation());
        this.schemasSelectionModel.setValues((Iterable)new SingleElementIterable((Object)schema));
    }

    private PropertyValueModel<Boolean> buildEditEnabledModel() {
        return new CollectionPropertyValueModelAdapter<Boolean>(this.schemasSelectionModel){

            protected Boolean buildValue() {
                return this.collectionModel.size() == 1;
            }
        };
    }

    private void editSelectedSchema() {
        Schema schema = (Schema)this.schemasSelectionModel.iterator().next();
        AddEditSchemaDialog dialog = new AddEditSchemaDialog(this.getShell(), schema, (Iterable<Schema>)this.schemasModel.getValue());
        if (dialog.open() == 1) {
            return;
        }
        schema.setNamespace(dialog.getNamespace());
        schema.setLocation(dialog.getLocation());
    }

    private PropertyValueModel<Boolean> buildRemoveEnabledModel() {
        return new CollectionPropertyValueModelAdapter<Boolean>(this.schemasSelectionModel){

            protected Boolean buildValue() {
                return this.collectionModel.size() >= 1;
            }
        };
    }

    private void removeSelectedSchemas() {
        this.schemasModel.removeSchemas(CollectionTools.iterable((Iterator)this.schemasSelectionModel.iterator()));
    }

    private void updateButtons() {
        Button revertButton;
        boolean enableApply = this.isValid();
        boolean enableRevert = true;
        Button applyButton = this.getApplyButton();
        if (applyButton != null) {
            applyButton.setEnabled(enableApply);
        }
        if ((revertButton = this.getDefaultsButton()) != null) {
            revertButton.setEnabled(enableRevert);
        }
    }

    public boolean performOk() {
        try {
            this.buildOkProgressMonitorDialog().run(true, false, this.buildOkRunnableWithProgress());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getTargetException());
        }
        return true;
    }

    private IRunnableContext buildOkProgressMonitorDialog() {
        return new ProgressMonitorDialog(this.getShell());
    }

    private IRunnableWithProgress buildOkRunnableWithProgress() {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                try {
                    ws.run(JaxbSchemasPropertiesPage.this.buildOkWorkspaceRunnable(), (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException ex) {
                    throw new InvocationTargetException(ex);
                }
            }
        };
    }

    IWorkspaceRunnable buildOkWorkspaceRunnable() {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JaxbSchemasPropertiesPage.this.performOk_(monitor);
            }
        };
    }

    void performOk_(IProgressMonitor monitor) throws CoreException {
        if (this.schemasModel.hasChanges()) {
            this.trigger.accept();
            JptJaxbCorePlugin.getProjectManager().rebuildJaxbProject(this.getProject());
            this.getProject().build(6, monitor);
        }
    }

    protected void performDefaults() {
        this.trigger.reset();
    }

    public void dispose() {
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AddEditSchemaDialog
    extends TitleAreaDialog {
        private Schema currentSchema;
        private String defaultMessage;
        private final WritablePropertyValueModel<String> location;
        private final WritablePropertyValueModel<String> namespace;
        private XSDSchema resolvedSchema;
        private final Mode mode;
        private Iterable<Schema> allSchemas;

        public AddEditSchemaDialog(Shell shell, Schema currentSchema, Iterable<Schema> allSchemas) {
            super(shell);
            this.currentSchema = currentSchema;
            this.allSchemas = allSchemas;
            this.location = new SimplePropertyValueModel();
            this.namespace = new SimplePropertyValueModel();
            Mode mode = this.mode = this.currentSchema == null ? Mode.ADD : Mode.EDIT;
            if (this.mode == Mode.ADD) {
                this.defaultMessage = JptJaxbUiMessages.SchemasPage_addSchemaMessage;
                this.location.setValue(null);
                this.namespace.setValue(null);
            } else {
                this.defaultMessage = JptJaxbUiMessages.SchemasPage_editSchemaMessage;
                this.location.setValue((Object)currentSchema.getLocation());
                this.namespace.setValue((Object)currentSchema.getNamespace());
            }
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            if (this.mode == Mode.ADD) {
                newShell.setText(JptJaxbUiMessages.SchemasPage_addSchemaDialogTitle);
            } else {
                newShell.setText(JptJaxbUiMessages.SchemasPage_editSchemaDialogTitle);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            this.setMessage(this.defaultMessage);
            if (this.mode == Mode.ADD) {
                this.setTitle(JptJaxbUiMessages.SchemasPage_addSchemaTitle);
            } else {
                this.setTitle(JptJaxbUiMessages.SchemasPage_editSchemaTitle);
            }
            Composite composite = new Composite(dialogArea, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            composite.setLayoutData((Object)new GridData(768));
            Label locationLabel = new Label(composite, 0);
            locationLabel.setText(JptJaxbUiMessages.SchemasPage_locationLabel);
            locationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            final Text locationText = new Text(composite, 2052);
            locationText.setText(this.locationDisplayString());
            locationText.setEditable(false);
            locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.location.addPropertyChangeListener("value", new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    locationText.setText(AddEditSchemaDialog.this.locationDisplayString());
                }
            });
            Button browseButton = new Button(composite, 8);
            browseButton.setText(JptJaxbUiMessages.SchemasPage_browseButtonLabel);
            browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, true, 1, 1));
            browseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AddEditSchemaDialog.this.browseForSchemaLocation();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Label namespaceLabel = new Label(composite, 0);
            namespaceLabel.setText(JptJaxbUiMessages.SchemasPage_namespaceLabel);
            namespaceLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            final Text namespaceText = new Text(composite, 2052);
            namespaceText.setText(this.namespaceDisplayString());
            namespaceText.setEditable(false);
            namespaceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.namespace.addPropertyChangeListener("value", new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    namespaceText.setText(AddEditSchemaDialog.this.namespaceDisplayString());
                }
            });
            Dialog.applyDialogFont((Control)dialogArea);
            return dialogArea;
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(false);
        }

        protected boolean isResizable() {
            return true;
        }

        private void browseForSchemaLocation() {
            SchemaLocationDialog dialog = new SchemaLocationDialog(this.getShell());
            if (dialog.open() == 1) {
                return;
            }
            String location = dialog.getLocation();
            this.location.setValue((Object)location);
            String resolvedUri = XsdUtil.getResolvedUri((String)location);
            XSDSchema schema = XSDImpl.buildXSDModel((String)resolvedUri);
            String newNamespace = schema == null ? null : (schema.getTargetNamespace() == null ? "" : schema.getTargetNamespace());
            this.namespace.setValue((Object)newNamespace);
            this.resolvedSchema = schema;
            this.validate();
        }

        public String getNamespace() {
            return (String)this.namespace.getValue();
        }

        protected String namespaceDisplayString() {
            return Schema.namespaceDisplayString(this.getNamespace());
        }

        public String getLocation() {
            return (String)this.location.getValue();
        }

        protected String locationDisplayString() {
            return Schema.locationDisplayString(this.getLocation());
        }

        private void validate() {
            if (this.resolvedSchema == null) {
                this.setErrorMessage(JptJaxbUiMessages.SchemasPage_schemaUnresolvedMessage);
            } else if (this.isDuplicateNamespace()) {
                this.setErrorMessage(JptJaxbUiMessages.SchemasPage_duplicateNamespaceMessage);
            } else if (StringTools.stringIsEmpty((String)((String)this.location.getValue()))) {
                this.setErrorMessage(JptJaxbUiMessages.SchemasPage_noLocationMessage);
            } else {
                this.setErrorMessage(null);
                this.setMessage(this.defaultMessage);
            }
            this.getButton(0).setEnabled(this.getErrorMessage() == null);
        }

        private boolean isDuplicateNamespace() {
            for (Schema schema : this.allSchemas) {
                if (this.currentSchema == schema || !this.getNamespace().equals(schema.getNamespace())) continue;
                return true;
            }
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Mode {
            ADD,
            EDIT;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Schema
    extends AbstractModel
    implements Comparable<Schema> {
        private String namespace;
        static final String NAMESPACE_PROPERTY = "namespace";
        private String location;
        static final String LOCATION_PROPERTY = "location";

        static String locationDisplayString(String location) {
            if (location == null) {
                return "";
            }
            URI uri = URI.createURI((String)location);
            if (uri.isPlatformResource()) {
                return uri.toPlatformString(false);
            }
            return location;
        }

        static String namespaceDisplayString(String namespace) {
            if (namespace == null || "".equals(namespace)) {
                return JptJaxbUiMessages.SchemasPage_noNamespaceText;
            }
            return namespace;
        }

        Schema(String namespace, String location) {
            this.namespace = namespace;
            this.location = location;
        }

        String getNamespace() {
            return this.namespace;
        }

        void setNamespace(String namespace) {
            String old = this.namespace;
            this.namespace = namespace;
            this.firePropertyChanged(NAMESPACE_PROPERTY, old, namespace);
        }

        String namespaceDisplayString() {
            return Schema.namespaceDisplayString(this.namespace);
        }

        String getLocation() {
            return this.location;
        }

        String locationDisplayString() {
            return Schema.locationDisplayString(this.getLocation());
        }

        void setLocation(String location) {
            String old = this.location;
            this.location = location;
            this.firePropertyChanged(LOCATION_PROPERTY, old, location);
        }

        @Override
        public int compareTo(Schema o) {
            return this.namespaceDisplayString().compareTo(o.namespaceDisplayString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SchemaColumnAdapter
    implements ColumnAdapter<Schema> {
        static final int COLUMN_COUNT = 2;
        static final int NAMESPACE_COLUMN = 0;
        static final int LOCATION_COLUMN = 1;

        SchemaColumnAdapter() {
        }

        public int columnCount() {
            return 2;
        }

        public String columnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return JptJaxbUiMessages.SchemasPage_namespaceColumnLabel;
                }
                case 1: {
                    return JptJaxbUiMessages.SchemasPage_locationColumnLabel;
                }
            }
            return null;
        }

        public WritablePropertyValueModel<?>[] cellModels(Schema subject) {
            WritablePropertyValueModel[] cellModels = new WritablePropertyValueModel[]{this.buildNamespaceCellModel(subject), this.buildLocationCellModel(subject)};
            return cellModels;
        }

        private WritablePropertyValueModel<String> buildNamespaceCellModel(Schema subject) {
            return new PropertyAspectAdapter<Schema, String>("namespace", subject){

                protected String buildValue_() {
                    return ((Schema)this.subject).getNamespace();
                }
            };
        }

        private WritablePropertyValueModel<String> buildLocationCellModel(Schema subject) {
            return new PropertyAspectAdapter<Schema, String>("location", subject){

                protected String buildValue_() {
                    return ((Schema)this.subject).getLocation();
                }
            };
        }
    }

    static class SchemaLocationDialog
    extends TrayDialog {
        private SelectFileOrXMLCatalogIdPanel locationPanel;
        private String location;

        public SchemaLocationDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(JptJaxbUiMessages.SchemasPage_chooseLocationTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.locationPanel = new SelectFileOrXMLCatalogIdPanel(composite, (IStructuredSelection)StructuredSelection.EMPTY);
            this.locationPanel.setFilterExtensions(new String[]{".xsd"});
            this.locationPanel.update();
            this.locationPanel.setVisibleHelper(true);
            return composite;
        }

        protected boolean isResizable() {
            return true;
        }

        protected void okPressed() {
            IFile file = this.locationPanel.getFile();
            this.location = file != null ? URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false).toString() : this.locationPanel.getXMLCatalogId();
            super.okPressed();
        }

        public String getLocation() {
            return this.location;
        }
    }

    static class SchemaTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SchemaTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Schema)element).namespaceDisplayString();
                }
                case 1: {
                    return ((Schema)element).locationDisplayString();
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SchemasModel
    extends AspectAdapter<JaxbProject>
    implements CollectionValueModel<Schema> {
        protected final Collection<Schema> schemas = new ArrayList<Schema>();
        protected final PropertyValueModel<Boolean> triggerHolder;
        protected final PropertyChangeListener triggerChangeListener;

        SchemasModel(PropertyValueModel<JaxbProject> subjectHolder, PropertyValueModel<Boolean> triggerHolder) {
            super(subjectHolder);
            this.triggerHolder = triggerHolder;
            this.triggerChangeListener = this.buildTriggerChangeListener();
        }

        protected PropertyChangeListener buildTriggerChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    SchemasModel.this.triggerChanged(event);
                }
            };
        }

        protected Collection<Schema> buildSchemas_() {
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            for (SchemaEntry entry : ((JaxbProject)this.subject).getSchemaLibrary().getSchemaEntries()) {
                schemas.add(new Schema(entry.getNamespace(), entry.getLocation()));
            }
            return schemas;
        }

        public boolean hasChanges() {
            return this.subject == null ? false : !this.schemas.equals(this.buildSchemas_());
        }

        protected void triggerChanged(PropertyChangeEvent event) {
            if (this.hasChanges()) {
                if (this.subject != null && ((Boolean)event.getNewValue()).booleanValue()) {
                    this.accept();
                } else {
                    this.reset();
                }
            }
        }

        public void accept() {
            Vector<String> schemaLocations = new Vector<String>();
            for (Schema schema : this.schemas) {
                schemaLocations.add(schema.getLocation());
            }
            ((JaxbProject)this.subject).getSchemaLibrary().setSchemaLocations(schemaLocations);
        }

        public void reset() {
            this.schemas.clear();
            if (this.subject != null) {
                this.schemas.addAll(this.buildSchemas_());
            }
            this.fireCollectionChanged("values", (Collection)this.getValue());
        }

        public Schema addSchema(String namespace, String location) {
            Schema schema = new Schema(namespace, location);
            this.addItemToCollection(schema, this.schemas, "values");
            return schema;
        }

        public void removeSchemas(Iterable<Schema> schemas) {
            this.removeItemsFromCollection(schemas, this.schemas, "values");
        }

        protected String getListenerAspectName() {
            return "values";
        }

        protected Class<? extends EventListener> getListenerClass() {
            return CollectionChangeListener.class;
        }

        protected boolean hasListeners() {
            return this.hasAnyCollectionChangeListeners("values");
        }

        protected void fireAspectChanged(Object oldValue, Object newValue) {
            this.fireCollectionChanged("values", (Collection)this.getValue());
        }

        protected void engageSubject_() {
            this.schemas.addAll(this.buildSchemas_());
        }

        protected void disengageSubject_() {
            this.schemas.clear();
        }

        protected void engageModels() {
            super.engageModels();
            this.triggerHolder.addPropertyChangeListener("value", this.triggerChangeListener);
        }

        protected void disengageModels() {
            this.triggerHolder.removePropertyChangeListener("value", this.triggerChangeListener);
            super.disengageModels();
        }

        protected Collection<Schema> getValue() {
            return CollectionTools.collection(this.iterator());
        }

        public Iterator<Schema> iterator() {
            return this.schemas.iterator();
        }

        public int size() {
            return this.schemas.size();
        }
    }
}

