/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.connection;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.jpt.jpa.db.JptJpaDbPlugin;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.Connection;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiPlugin;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.connection.JdbcBindParametersComposite;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.connection.JdbcDriverComposite;
import org.eclipse.jpt.jpa.ui.internal.jpa2.persistence.JptUiPersistence2_0Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcConnectionPropertiesComposite<T extends Connection>
extends Pane<T> {
    private static final String DIALOG_SETTINGS = "org.eclipse.jpt.jpa.eclipselink.ui.dialogs.ConnectionDialog";

    public JdbcConnectionPropertiesComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private WritablePropertyValueModel<String> buildPasswordHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"password"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getPassword();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setPassword(value);
            }
        };
    }

    private Runnable buildPopulateFromConnectionAction() {
        return new Runnable(){

            public void run() {
                JdbcConnectionPropertiesComposite.this.promptConnection();
            }
        };
    }

    private WritablePropertyValueModel<String> buildUrlHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"url"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getUrl();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setUrl(value);
            }
        };
    }

    private WritablePropertyValueModel<String> buildUserHolder() {
        return new PropertyAspectAdapter<Connection, String>(this.getSubjectHolder(), new String[]{"user"}){

            protected String buildValue_() {
                return ((Connection)this.subject).getUser();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Connection)this.subject).setUser(value);
            }
        };
    }

    protected void initializeLayout(Composite container) {
        this.addHyperlink(container, JptUiPersistence2_0Messages.JdbcConnectionPropertiesComposite_populateFromConnectionHyperLink, this.buildPopulateFromConnectionAction());
        new JdbcDriverComposite(this, container);
        this.addLabeledText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_urlLabel, this.buildUrlHolder());
        this.addLabeledText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_userLabel, this.buildUserHolder());
        this.addLabeledPasswordText(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_passwordLabel, this.buildPasswordHolder());
        new JdbcBindParametersComposite(this, container);
    }

    void promptConnection() {
        ConnectionSelectionDialog dialog = new ConnectionSelectionDialog();
        if (dialog.open() != 0) {
            return;
        }
        String name = (String)dialog.getResult()[0];
        ConnectionProfile cp = this.getConnectionProfileFactory().buildConnectionProfile(name);
        Connection connection = (Connection)this.getSubject();
        connection.setUrl(cp == null ? "" : cp.getURL());
        connection.setUser(cp == null ? "" : cp.getUserName());
        connection.setPassword(cp == null ? "" : cp.getUserPassword());
        connection.setDriver(cp == null ? "" : cp.getDriverClassName());
    }

    ConnectionProfileFactory getConnectionProfileFactory() {
        return JptJpaDbPlugin.getConnectionProfileFactory();
    }

    Shell getShell_() {
        return this.getShell();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConnectionSelectionDialog
    extends FilteredItemsSelectionDialog {
        protected ConnectionSelectionDialog() {
            super(JdbcConnectionPropertiesComposite.this.getShell_(), false);
            this.setMessage(EclipseLinkUiMessages.JdbcConnectionPropertiesComposite_ConnectionDialog_Message);
            this.setTitle(EclipseLinkUiMessages.JdbcConnectionPropertiesComposite_ConnectionDialog_Title);
            this.setListLabelProvider(this.buildLabelProvider());
            this.setDetailsLabelProvider(this.buildLabelProvider());
        }

        protected ILabelProvider buildLabelProvider() {
            return new LabelProvider(){

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    return element == null ? "" : element.toString();
                }
            };
        }

        protected Control createExtendedContentArea(Composite parent) {
            return null;
        }

        protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
            return new ConnectionItemsFilter();
        }

        protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
            Iterable<String> profileNames = this.getConnectionProfileNames();
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)CollectionTools.size(profileNames));
            for (String name : profileNames) {
                provider.add((Object)name, itemsFilter);
                sm.worked(1);
            }
        }

        private Iterable<String> getConnectionProfileNames() {
            return JdbcConnectionPropertiesComposite.this.getConnectionProfileFactory().getConnectionProfileNames();
        }

        protected IDialogSettings getDialogSettings() {
            IDialogSettings dialogSettings = JptJpaEclipseLinkUiPlugin.instance().getDialogSettings();
            IDialogSettings settings = dialogSettings.getSection(JdbcConnectionPropertiesComposite.DIALOG_SETTINGS);
            if (settings == null) {
                settings = dialogSettings.addNewSection(JdbcConnectionPropertiesComposite.DIALOG_SETTINGS);
            }
            return settings;
        }

        public String getElementName(Object object) {
            return object.toString();
        }

        protected Comparator<String> getItemsComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String item1, String item2) {
                    return item1.compareTo(item2);
                }
            };
        }

        protected IStatus validateItem(Object item) {
            if (item == null) {
                return new Status(4, "org.eclipse.jpt.jpa.eclipselink.ui", 4, "", null);
            }
            return Status.OK_STATUS;
        }

        private class ConnectionItemsFilter
        extends FilteredItemsSelectionDialog.ItemsFilter {
            ConnectionItemsFilter() {
                super((FilteredItemsSelectionDialog)ConnectionSelectionDialog.this);
                if (StringTools.stringIsEmpty((String)this.getPattern())) {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                return this.matches(item.toString());
            }
        }
    }
}

