/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal;

import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Table;

public interface DatabaseAnnotationNameBuilder {
    public String buildTableAnnotationName(String var1, Table var2);

    public String buildColumnAnnotationName(String var1, Column var2);

    public String buildJoinColumnAnnotationName(String var1, ForeignKey var2);

    public String buildJoinColumnAnnotationName(Column var1);

    public String buildJoinTableAnnotationName(Table var1);

    public static final class Default
    implements DatabaseAnnotationNameBuilder {
        public static final DatabaseAnnotationNameBuilder INSTANCE = new Default();

        public static DatabaseAnnotationNameBuilder instance() {
            return INSTANCE;
        }

        private Default() {
        }

        public String buildTableAnnotationName(String entityName, Table table) {
            return table.getName();
        }

        public String buildColumnAnnotationName(String attributeName, Column column) {
            return column.getName();
        }

        public String buildJoinColumnAnnotationName(String attributeName, ForeignKey foreignKey) {
            return foreignKey.getColumnPair().getBaseColumn().getName();
        }

        public String buildJoinColumnAnnotationName(Column column) {
            return column.getName();
        }

        public String buildJoinTableAnnotationName(Table table) {
            return table.getName();
        }

        public String toString() {
            return "DatabaseAnnotationNameBuilder.Default";
        }
    }
}

