/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.jpa.gen.internal.JptGenMessages;
import org.eclipse.jpt.jpa.gen.internal.JptJpaGenPlugin;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.gen.internal.ORMGenTable;
import org.eclipse.jpt.jpa.gen.internal.OverwriteConfirmer;
import org.eclipse.jpt.jpa.gen.internal.util.CompilationUnitModifier;
import org.eclipse.jpt.jpa.gen.internal.util.FileUtil;
import org.eclipse.jpt.jpa.gen.internal.util.UrlUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageGenerator {
    private static final String LOGGER_NAME = "org.eclipse.jpt.entities.gen.log";
    private final JpaProject jpaProject;
    private final ORMGenCustomizer customizer;
    private final OverwriteConfirmer overwriteConfirmer;

    public static void generate(JpaProject jpaProject, ORMGenCustomizer customizer, OverwriteConfirmer overwriteConfirmer, IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        PackageGenerator generator = new PackageGenerator(jpaProject, customizer, overwriteConfirmer);
        sm.worked(1);
        try {
            generator.doGenerate((IProgressMonitor)sm.newChild(19));
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jpa.gen", JptGenMessages.Error_Generating_Entities, (Throwable)e));
        }
    }

    private PackageGenerator(JpaProject jpaProject, ORMGenCustomizer customizer, OverwriteConfirmer confirmer) {
        this.jpaProject = jpaProject;
        this.customizer = customizer;
        this.overwriteConfirmer = confirmer;
    }

    private Object getCustomizer() {
        return this.customizer;
    }

    private IJavaProject getJavaProject() {
        return this.jpaProject.getJavaProject();
    }

    protected void doGenerate(IProgressMonitor monitor) throws Exception {
        this.generateInternal(monitor);
    }

    protected void generateInternal(IProgressMonitor monitor) throws Exception {
        File templDir = this.prepareTemplatesFolder();
        ArrayList<String> genClasses = new ArrayList<String>();
        List<String> tableNames = this.customizer.getGenTableNames();
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(tableNames.size() + 2));
        Iterator<String> iter = tableNames.iterator();
        while (iter.hasNext()) {
            if (sm.isCanceled()) {
                return;
            }
            String tableName = iter.next();
            ORMGenTable table = this.customizer.getTable(tableName);
            String className = table.getQualifiedClassName();
            this.generateClass(table, templDir.getAbsolutePath(), (IProgressMonitor)sm.newChild(1, 0));
            genClasses.add(className);
            if (!table.isCompositeKey()) continue;
            genClasses.add(table.getQualifiedCompositeKeyClassName());
        }
        if (sm.isCanceled()) {
            return;
        }
        if (this.customizer.updatePersistenceXml()) {
            this.updatePersistenceXml(genClasses);
        }
        sm.worked(2);
    }

    private void updatePersistenceXml(final List<String> genClasses) {
        JpaXmlResource resource = this.jpaProject.getPersistenceXmlResource();
        if (resource == null) {
            return;
        }
        resource.modify(new Runnable(){

            public void run() {
                PersistenceUnit persistenceUnit;
                Persistence persistence = PackageGenerator.this.jpaProject.getRootContextNode().getPersistenceXml().getPersistence();
                if (persistence == null) {
                    return;
                }
                if (persistence.getPersistenceUnitsSize() == 0) {
                    persistenceUnit = persistence.addPersistenceUnit();
                    persistenceUnit.setName(PackageGenerator.this.jpaProject.getName());
                } else {
                    persistenceUnit = (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
                }
                for (String className : genClasses) {
                    if (!CollectionTools.isEmpty((Iterable)persistenceUnit.getMappingFileRefsContaining(className)) || persistenceUnit.specifiesPersistentType(className)) continue;
                    persistenceUnit.addSpecifiedClassRef(className);
                }
            }
        });
    }

    private File prepareTemplatesFolder() throws IOException, Exception, CoreException {
        String templatesPath;
        Path path;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jpt.jpa.gen");
        URL url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(templatesPath = "templates/entities/")), null);
        if (url == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jpa.gen", String.valueOf(JptGenMessages.Templates_notFound) + " " + "org.eclipse.jpt.jpa.gen" + "/" + templatesPath));
        }
        URL templUrl = FileLocator.resolve((URL)url);
        File templDir = null;
        templDir = UrlUtil.isJarUrl(templUrl) ? FileUtil.extractFilesFromBundle(templUrl, bundle, templatesPath) : UrlUtil.getUrlFile(templUrl);
        if (templDir == null || !templDir.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jpa.gen", String.valueOf(JptGenMessages.Templates_notFound) + " " + "org.eclipse.jpt.jpa.gen"));
        }
        return templDir;
    }

    protected void generateClass(ORMGenTable table, String templateDirPath, IProgressMonitor monitor) throws Exception {
        String subTaskName = NLS.bind((String)JptGenMessages.EntityGenerator_taskName, (Object)table.getName());
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)subTaskName, (int)10);
        try {
            IFolder javaPackageFolder = this.getJavaPackageFolder(table, monitor);
            IFile javaFile = javaPackageFolder.getFile(String.valueOf(table.getClassName()) + ".java");
            if (javaFile.exists() && this.overwriteConfirmer != null && !this.overwriteConfirmer.overwrite(javaFile.getName())) {
                return;
            }
            Logger logger = Logger.getLogger(LOGGER_NAME);
            logger.setLevel(Level.SEVERE);
            Properties vep = new Properties();
            vep.setProperty("file.resource.loader.path", templateDirPath);
            vep.setProperty("runtime.log.logsystem.jdk.logger", LOGGER_NAME);
            VelocityEngine ve = new VelocityEngine();
            ve.init(vep);
            sm.worked(2);
            this.generateJavaFile(table, javaFile, ve, "main.java.vm", true, (IProgressMonitor)sm.newChild(6));
            if (table.isCompositeKey()) {
                IFile compositeKeyFile = javaPackageFolder.getFile(String.valueOf(table.getCompositeKeyClassName()) + ".java");
                this.generateJavaFile(table, compositeKeyFile, ve, "pk.java.vm", false, (IProgressMonitor)sm.newChild(1));
            } else {
                sm.setWorkRemaining(1);
            }
            javaFile.refreshLocal(1, (IProgressMonitor)sm.newChild(1));
        }
        catch (Throwable e) {
            CoreException ce = new CoreException((IStatus)new Status(4, "org.eclipse.jpt.jpa.gen", String.valueOf(JptGenMessages.Templates_notFound) + "org.eclipse.jpt.jpa.gen", e));
            JptJpaGenPlugin.logException(ce);
        }
    }

    private void generateJavaFile(ORMGenTable table, IFile javaFile, VelocityEngine ve, String templateName, boolean isDomainClass, IProgressMonitor monitor) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("table", (Object)table);
        context.put("customizer", this.getCustomizer());
        StringWriter w = new StringWriter();
        ve.mergeTemplate(templateName, (Context)context, (Writer)w);
        String fileContent = w.toString();
        if (javaFile.exists()) {
            if (isDomainClass) {
                this.updateExistingDomainClass(table.getQualifiedClassName(), javaFile, fileContent);
            } else {
                byte[] content = fileContent.getBytes(javaFile.getCharset());
                javaFile.setContents((InputStream)new ByteArrayInputStream(content), true, true, monitor);
            }
        } else {
            byte[] content = fileContent.getBytes(javaFile.getCharset());
            this.createFile(javaFile, new ByteArrayInputStream(content));
        }
    }

    protected void updateExistingDomainClass(String className, IFile javaFile, String fileContent) throws Exception {
        CompilationUnitModifier modifier = new CompilationUnitModifier(this.getJavaProject(), className);
        modifier.setJavaSource(fileContent);
        modifier.save();
    }

    public void createFile(IFile file, InputStream contents) throws CoreException {
        file.create(contents, false, null);
    }

    public IFolder getJavaPackageFolder(ORMGenTable table, IProgressMonitor monitor) throws CoreException {
        IPackageFragment packageFragment;
        IPackageFragmentRoot root = this.getDefaultJavaSourceLocation(this.getJavaProject(), table.getSourceFolder());
        String packageName = table.getPackage();
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageFragment = root.getPackageFragment(packageName)).exists()) {
            root.createPackageFragment(packageName, true, monitor);
        }
        return (IFolder)packageFragment.getResource();
    }

    private IPackageFragmentRoot getDefaultJavaSourceLocation(IJavaProject jproject, String sourceFolder) {
        IPackageFragmentRoot defaultSrcPath = null;
        if (jproject != null && jproject.exists()) {
            try {
                IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1) {
                        String path;
                        if (defaultSrcPath == null) {
                            defaultSrcPath = roots[i];
                        }
                        if ((path = roots[i].getPath().toString()).equals(String.valueOf('/') + sourceFolder)) {
                            return roots[i];
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                JptJpaGenPlugin.logException((CoreException)e);
            }
        }
        return defaultSrcPath;
    }
}

