/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.IntegerCombo;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.ReadOnlyColumn;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.db.ColumnCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.DatabaseObjectCombo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnComposite
extends Pane<ReadOnlyColumn> {
    public ColumnComposite(Pane<?> parentPane, PropertyValueModel<? extends ReadOnlyColumn> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    private ColumnCombo<ReadOnlyColumn> addColumnCombo(Composite container) {
        return new ColumnCombo<ReadOnlyColumn>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            protected void propertyChanged(String propertyName) {
                if (propertyName == "defaultTable" || propertyName == "specifiedTable") {
                    this.doPopulate();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((ReadOnlyColumn)this.getSubject()).getDefaultName();
            }

            protected void setValue(String value) {
                ((Column)this.getSubject()).setSpecifiedName(value);
            }

            @Override
            protected Table getDbTable_() {
                ReadOnlyColumn column = (ReadOnlyColumn)this.getSubject();
                return column == null ? null : column.getDbTable();
            }

            protected String getValue() {
                return ((ReadOnlyColumn)this.getSubject()).getSpecifiedName();
            }

            protected String buildNullDefaultValueEntry() {
                return NLS.bind((String)JptCommonUiMessages.DefaultWithOneParam, (Object)JptCommonUiMessages.NoneSelected);
            }

            public String toString() {
                return "ColumnComposite.columnCombo";
            }
        };
    }

    WritablePropertyValueModel<String> buildColumnDefinitionHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, String>(this.getSubjectHolder(), new String[]{"columnDefinition"}){

            protected String buildValue_() {
                return ((ReadOnlyColumn)this.subject).getColumnDefinition();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((Column)this.subject).setColumnDefinition(value);
            }
        };
    }

    WritablePropertyValueModel<Boolean> buildInsertableHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable"}){

            protected Boolean buildValue_() {
                return ((ReadOnlyColumn)this.subject).getSpecifiedInsertable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedInsertable(value);
            }
        };
    }

    PropertyValueModel<String> buildInsertableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultInsertableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.Boolean_True : JptCommonUiMessages.Boolean_False;
                    return NLS.bind((String)JptUiDetailsMessages.ColumnComposite_insertableWithDefault, (Object)defaultStringValue);
                }
                return JptUiDetailsMessages.ColumnComposite_insertable;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultInsertableHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedInsertable", "defaultInsertable"}){

            protected Boolean buildValue_() {
                if (((ReadOnlyColumn)this.subject).getSpecifiedInsertable() != null) {
                    return null;
                }
                return ((ReadOnlyColumn)this.subject).isDefaultInsertable();
            }
        };
    }

    WritablePropertyValueModel<Boolean> buildNullableHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedNullable"}){

            protected Boolean buildValue_() {
                return ((ReadOnlyColumn)this.subject).getSpecifiedNullable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedNullable(value);
            }
        };
    }

    PropertyValueModel<String> buildNullableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultNullableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.Boolean_True : JptCommonUiMessages.Boolean_False;
                    return NLS.bind((String)JptUiDetailsMessages.ColumnComposite_nullableWithDefault, (Object)defaultStringValue);
                }
                return JptUiDetailsMessages.ColumnComposite_nullable;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultNullableHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedNullable", "defaultNullable"}){

            protected Boolean buildValue_() {
                if (((ReadOnlyColumn)this.subject).getSpecifiedNullable() != null) {
                    return null;
                }
                return ((ReadOnlyColumn)this.subject).isDefaultNullable();
            }
        };
    }

    private Pane<ReadOnlyColumn> addTableCombo(Composite container) {
        return new DatabaseObjectCombo<ReadOnlyColumn>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTable");
                propertyNames.add("specifiedTable");
            }

            protected String getDefaultValue() {
                return ((ReadOnlyColumn)this.getSubject()).getDefaultTable();
            }

            protected void setValue(String value) {
                ((Column)this.getSubject()).setSpecifiedTable(value);
            }

            protected String getValue() {
                return ((ReadOnlyColumn)this.getSubject()).getSpecifiedTable();
            }

            @Override
            protected Iterable<String> getValues_() {
                ReadOnlyColumn column = (ReadOnlyColumn)this.getSubject();
                return column != null ? column.getCandidateTableNames() : EmptyIterable.instance();
            }

            protected String buildNullDefaultValueEntry() {
                return NLS.bind((String)JptCommonUiMessages.DefaultWithOneParam, (Object)JptCommonUiMessages.NoneSelected);
            }

            public String toString() {
                return "ColumnComposite.tableCombo";
            }
        };
    }

    WritablePropertyValueModel<Boolean> buildUniqueHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUnique"}){

            protected Boolean buildValue_() {
                return ((ReadOnlyColumn)this.subject).getSpecifiedUnique();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUnique(value);
            }
        };
    }

    PropertyValueModel<String> buildUniqueStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultUniqueHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.Boolean_True : JptCommonUiMessages.Boolean_False;
                    return NLS.bind((String)JptUiDetailsMessages.ColumnComposite_uniqueWithDefault, (Object)defaultStringValue);
                }
                return JptUiDetailsMessages.ColumnComposite_unique;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultUniqueHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUnique", "defaultUnique"}){

            protected Boolean buildValue_() {
                if (((ReadOnlyColumn)this.subject).getSpecifiedUnique() != null) {
                    return null;
                }
                return ((ReadOnlyColumn)this.subject).isDefaultUnique();
            }
        };
    }

    WritablePropertyValueModel<Boolean> buildUpdatableHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"defaultUpdatable", "specifiedUpdatable"}){

            protected Boolean buildValue_() {
                return ((ReadOnlyColumn)this.subject).getSpecifiedUpdatable();
            }

            protected void setValue_(Boolean value) {
                ((Column)this.subject).setSpecifiedUpdatable(value);
            }
        };
    }

    PropertyValueModel<String> buildUpdatableStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultUpdatableHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.Boolean_True : JptCommonUiMessages.Boolean_False;
                    return NLS.bind((String)JptUiDetailsMessages.ColumnComposite_updatableWithDefault, (Object)defaultStringValue);
                }
                return JptUiDetailsMessages.ColumnComposite_updatable;
            }
        };
    }

    PropertyValueModel<Boolean> buildDefaultUpdatableHolder() {
        return new PropertyAspectAdapter<ReadOnlyColumn, Boolean>(this.getSubjectHolder(), new String[]{"specifiedUpdatable", "defaultUpdatable"}){

            protected Boolean buildValue_() {
                if (((ReadOnlyColumn)this.subject).getSpecifiedUpdatable() != null) {
                    return null;
                }
                return ((ReadOnlyColumn)this.subject).isDefaultUpdatable();
            }
        };
    }

    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiDetailsMessages.ColumnComposite_columnSection);
        this.addLabeledComposite(container, JptUiDetailsMessages.ColumnComposite_name, (Pane)this.addColumnCombo(container), "org.eclipse.jpt.jpa.ui.mapping_column");
        this.addLabeledComposite(container, JptUiDetailsMessages.ColumnComposite_table, this.addTableCombo(container), "org.eclipse.jpt.jpa.ui.mapping_columnTable");
        container = this.addCollapsibleSubSection(container, JptUiDetailsMessages.ColumnComposite_details, (PropertyValueModel)new SimplePropertyValueModel((Object)Boolean.FALSE));
        new DetailsComposite(this, (PropertyValueModel<? extends ReadOnlyColumn>)this.getSubjectHolder(), this.addSubPane(container, 0, 16));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DetailsComposite
    extends Pane<ReadOnlyColumn> {
        public DetailsComposite(Pane<?> parentPane, PropertyValueModel<? extends ReadOnlyColumn> subjectHolder, Composite parent) {
            super(parentPane, subjectHolder, parent, false);
        }

        protected void initializeLayout(Composite container) {
            this.addTriStateCheckBoxWithDefault(this.addSubPane(container, 4), JptUiDetailsMessages.ColumnComposite_insertable, ColumnComposite.this.buildInsertableHolder(), ColumnComposite.this.buildInsertableStringHolder(), "org.eclipse.jpt.jpa.ui.mapping_columnInsertable");
            this.addTriStateCheckBoxWithDefault(container, JptUiDetailsMessages.ColumnComposite_updatable, ColumnComposite.this.buildUpdatableHolder(), ColumnComposite.this.buildUpdatableStringHolder(), "org.eclipse.jpt.jpa.ui.mapping_columnUpdatable");
            this.addTriStateCheckBoxWithDefault(container, JptUiDetailsMessages.ColumnComposite_unique, ColumnComposite.this.buildUniqueHolder(), ColumnComposite.this.buildUniqueStringHolder(), "org.eclipse.jpt.jpa.ui.mapping_columnUnique");
            this.addTriStateCheckBoxWithDefault(container, JptUiDetailsMessages.ColumnComposite_nullable, ColumnComposite.this.buildNullableHolder(), ColumnComposite.this.buildNullableStringHolder(), "org.eclipse.jpt.jpa.ui.mapping_columnNullable");
            this.addLengthCombo(container);
            this.addPrecisionCombo(container);
            this.addScaleCombo(container);
            this.addLabeledText(container, JptUiDetailsMessages.ColumnComposite_columnDefinition, ColumnComposite.this.buildColumnDefinitionHolder());
        }

        private void addLengthCombo(Composite container) {
            new IntegerCombo<ReadOnlyColumn>((Pane)this, container){

                protected String getLabelText() {
                    return JptUiDetailsMessages.ColumnComposite_length;
                }

                protected String getHelpId() {
                    return "org.eclipse.jpt.jpa.ui.mapping_columnLength";
                }

                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<ReadOnlyColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultLength"}){

                        protected Integer buildValue_() {
                            return ((ReadOnlyColumn)this.subject).getDefaultLength();
                        }
                    };
                }

                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<ReadOnlyColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedLength"}){

                        protected Integer buildValue_() {
                            return ((ReadOnlyColumn)this.subject).getSpecifiedLength();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedLength(value);
                        }
                    };
                }
            };
        }

        private void addPrecisionCombo(Composite container) {
            new IntegerCombo<ReadOnlyColumn>((Pane)this, container){

                protected String getLabelText() {
                    return JptUiDetailsMessages.ColumnComposite_precision;
                }

                protected String getHelpId() {
                    return "org.eclipse.jpt.jpa.ui.mapping_columnPrecision";
                }

                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<ReadOnlyColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultPrecision"}){

                        protected Integer buildValue_() {
                            return ((ReadOnlyColumn)this.subject).getDefaultPrecision();
                        }
                    };
                }

                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<ReadOnlyColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedPrecision"}){

                        protected Integer buildValue_() {
                            return ((ReadOnlyColumn)this.subject).getSpecifiedPrecision();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedPrecision(value);
                        }
                    };
                }
            };
        }

        private void addScaleCombo(Composite container) {
            new IntegerCombo<ReadOnlyColumn>((Pane)this, container){

                protected String getLabelText() {
                    return JptUiDetailsMessages.ColumnComposite_scale;
                }

                protected String getHelpId() {
                    return "org.eclipse.jpt.jpa.ui.mapping_columnScale";
                }

                protected PropertyValueModel<Integer> buildDefaultHolder() {
                    return new PropertyAspectAdapter<ReadOnlyColumn, Integer>(this.getSubjectHolder(), new String[]{"defaultScale"}){

                        protected Integer buildValue_() {
                            return ((ReadOnlyColumn)this.subject).getDefaultScale();
                        }
                    };
                }

                protected WritablePropertyValueModel<Integer> buildSelectedItemHolder() {
                    return new PropertyAspectAdapter<ReadOnlyColumn, Integer>(this.getSubjectHolder(), new String[]{"specifiedScale"}){

                        protected Integer buildValue_() {
                            return ((ReadOnlyColumn)this.subject).getSpecifiedScale();
                        }

                        protected void setValue_(Integer value) {
                            ((Column)this.subject).setSpecifiedScale(value);
                        }
                    };
                }
            };
        }
    }
}

