/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.NonEmptyStringFilter;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationListValueModel;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.GeneratedValue;
import org.eclipse.jpt.jpa.core.context.GenerationType;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedValueComposite
extends Pane<IdMapping> {
    public GeneratedValueComposite(Pane<? extends IdMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected void initializeLayout(Composite container) {
        this.addLabeledComposite(container, JptUiDetailsMessages.GeneratedValueComposite_strategy, (Pane)this.addStrategyComboViewer(container), "org.eclipse.jpt.jpa.ui.mapping_generatedValueStrategy");
        this.addLabeledEditableCombo(container, JptUiDetailsMessages.GeneratedValueComposite_generatorName, this.buildSortedGeneraterNamesModel(), this.buildGeneratorNameHolder(), "org.eclipse.jpt.jpa.ui.mapping_generatedValueGeneratorName");
    }

    private EnumFormComboViewer<GeneratedValue, GenerationType> addStrategyComboViewer(Composite parent) {
        return new EnumFormComboViewer<GeneratedValue, GenerationType>((Pane)this, this.buildGeneratedValueHolder(), parent){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultStrategy");
                propertyNames.add("specifiedStrategy");
            }

            protected GenerationType[] getChoices() {
                return GenerationType.values();
            }

            protected GenerationType getDefaultValue() {
                return ((GeneratedValue)this.getSubject()).getDefaultStrategy();
            }

            protected String displayString(GenerationType value) {
                return this.buildDisplayString(JptUiDetailsMessages.class, (Object)GeneratedValueComposite.this, value);
            }

            protected GenerationType getValue() {
                return ((GeneratedValue)this.getSubject()).getSpecifiedStrategy();
            }

            protected void setValue(GenerationType value) {
                GeneratedValueComposite.this.getGeneratedValueForUpdate().setSpecifiedStrategy(value);
            }
        };
    }

    private PropertyValueModel<GeneratedValue> buildGeneratedValueHolder() {
        return new PropertyAspectAdapter<IdMapping, GeneratedValue>(this.getSubjectHolder(), new String[]{"generatedValue"}){

            protected GeneratedValue buildValue_() {
                return ((IdMapping)GeneratedValueComposite.this.getSubject()).getGeneratedValue();
            }
        };
    }

    protected final WritablePropertyValueModel<String> buildGeneratorNameHolder() {
        return new PropertyAspectAdapter<GeneratedValue, String>(this.buildGeneratedValueHolder(), new String[]{"specifiedGenerator"}){

            protected String buildValue_() {
                return ((GeneratedValue)this.subject).getSpecifiedGenerator();
            }

            public void setValue(String value) {
                if (this.subject != null) {
                    this.setValue_(value);
                    return;
                }
                if (value.length() == 0) {
                    return;
                }
                GeneratedValueComposite.this.getGeneratedValueForUpdate().setSpecifiedGenerator(value);
            }

            protected void setValue_(String value) {
                if (value != null && value.length() == 0) {
                    value = null;
                }
                ((GeneratedValue)this.subject).setSpecifiedGenerator(value);
            }
        };
    }

    protected ListValueModel<String> buildSortedGeneraterNamesModel() {
        return new SortedListValueModelAdapter(this.buildUniqueGeneratorNamesModel());
    }

    protected CollectionValueModel<String> buildUniqueGeneratorNamesModel() {
        return new SetCollectionValueModel(this.buildGeneratorNamesModel());
    }

    protected CollectionValueModel<String> buildGeneratorNamesModel() {
        return new FilteringCollectionValueModel(this.buildGeneratorNamesModel_(), NonEmptyStringFilter.instance());
    }

    protected ListValueModel<String> buildGeneratorNamesModel_() {
        return new TransformationListValueModel<Generator, String>(this.buildGeneratorsModel()){

            protected String transformItem_(Generator generator) {
                return generator.getName();
            }
        };
    }

    protected ListValueModel<Generator> buildGeneratorsModel() {
        return new ItemPropertyListValueModelAdapter(this.buildGeneratorsModel_(), new String[]{"name"});
    }

    protected CollectionValueModel<Generator> buildGeneratorsModel_() {
        return new CollectionAspectAdapter<PersistenceUnit, Generator>(this.buildPersistenceUnitModel(), new String[]{"generators"}){

            protected Iterable<Generator> getIterable() {
                return ((PersistenceUnit)this.subject).getGenerators();
            }

            protected int size_() {
                return ((PersistenceUnit)this.subject).getGeneratorsSize();
            }
        };
    }

    protected PropertyValueModel<PersistenceUnit> buildPersistenceUnitModel() {
        return new PropertyAspectAdapter<IdMapping, PersistenceUnit>(this.getSubjectHolder()){

            protected PersistenceUnit buildValue_() {
                return ((IdMapping)this.subject).getPersistenceUnit();
            }
        };
    }

    GeneratedValue getGeneratedValueForUpdate() {
        GeneratedValue generatedValue = ((IdMapping)this.getSubject()).getGeneratedValue();
        if (generatedValue == null) {
            generatedValue = ((IdMapping)this.getSubject()).addGeneratedValue();
        }
        return generatedValue;
    }
}

