/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Collection;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ReadOnlyWritablePropertyValueModelWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.ValueListAdapter;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jpa.core.context.BaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.ReferenceTable;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnInReferenceTableDialog;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnInReferenceTableStateObject;
import org.eclipse.jpt.jpa.ui.internal.details.JoinColumnsComposite;
import org.eclipse.jpt.jpa.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.TableCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReferenceTableComposite<T extends ReadOnlyReferenceTable>
extends Pane<T> {
    protected Button overrideDefaultJoinColumnsCheckBox;
    protected JoinColumnsComposite<T> joinColumnsComposite;

    protected ReferenceTableComposite(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent, false);
    }

    protected ReferenceTableComposite(PropertyValueModel<? extends T> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    protected void installJoinColumnsPaneEnabler(JoinColumnsComposite<T> pane) {
        pane.installJoinColumnsPaneEnabler((PropertyValueModel<Boolean>)new JoinColumnPaneEnablerHolder());
    }

    void addJoinColumn(T referenceTable) {
        JoinColumnInReferenceTableDialog dialog = new JoinColumnInReferenceTableDialog(this.getShell(), (ReadOnlyReferenceTable)referenceTable, null);
        dialog.openDialog(this.buildAddJoinColumnPostExecution());
    }

    void addJoinColumnFromDialog(JoinColumnInReferenceTableStateObject stateObject) {
        JoinColumn joinColumn = ((ReferenceTable)this.getSubject()).addSpecifiedJoinColumn();
        stateObject.updateJoinColumn((BaseJoinColumn)joinColumn);
        this.setSelectedJoinColumn(joinColumn);
    }

    private void setSelectedJoinColumn(JoinColumn joinColumn) {
        this.joinColumnsComposite.setSelectedJoinColumn(joinColumn);
    }

    private PostExecution<JoinColumnInReferenceTableDialog> buildAddJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInReferenceTableDialog>(){

            public void execute(JoinColumnInReferenceTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    ReferenceTableComposite.this.addJoinColumnFromDialog((JoinColumnInReferenceTableStateObject)dialog.getSubject());
                }
            }
        };
    }

    private PostExecution<JoinColumnInReferenceTableDialog> buildEditJoinColumnPostExecution() {
        return new PostExecution<JoinColumnInReferenceTableDialog>(){

            public void execute(JoinColumnInReferenceTableDialog dialog) {
                if (dialog.wasConfirmed()) {
                    ReferenceTableComposite.this.editJoinColumn((JoinColumnInReferenceTableStateObject)dialog.getSubject());
                }
            }
        };
    }

    protected JoinColumnsProvider buildJoinColumnsEditor() {
        return new JoinColumnsProvider();
    }

    protected WritablePropertyValueModel<Boolean> buildOverrideDefaultJoinColumnHolder() {
        return new OverrideDefaultJoinColumnHolder();
    }

    ListValueModel<ReadOnlyJoinColumn> buildSpecifiedJoinColumnsListHolder() {
        return new ListAspectAdapter<T, ReadOnlyJoinColumn>(this.getSubjectHolder(), new String[]{"specifiedJoinColumns"}){

            protected ListIterable<ReadOnlyJoinColumn> getListIterable() {
                return new SuperListIterableWrapper(((ReadOnlyReferenceTable)this.subject).getSpecifiedJoinColumns());
            }

            protected int size_() {
                return ((ReadOnlyReferenceTable)this.subject).getSpecifiedJoinColumnsSize();
            }
        };
    }

    protected Composite addPane(Composite container, int groupBoxMargin) {
        return this.addSubPane(container, 0, groupBoxMargin, 10, groupBoxMargin);
    }

    protected TableCombo<T> addTableCombo(Composite container) {
        return new TableCombo<T>(this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultSchema" || propertyName == "specifiedSchema" || propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            protected String getDefaultValue() {
                return ((ReadOnlyReferenceTable)this.getSubject()).getDefaultName();
            }

            protected void setValue(String value) {
                ((ReferenceTable)this.getSubject()).setSpecifiedName(value);
            }

            protected String getValue() {
                return ((ReadOnlyReferenceTable)this.getSubject()).getSpecifiedName();
            }

            @Override
            protected Schema getDbSchema_() {
                ReferenceTable table = this.getTable();
                return table == null ? null : table.getDbSchema();
            }

            protected ReferenceTable getTable() {
                ReadOnlyReferenceTable table = (ReadOnlyReferenceTable)this.getSubject();
                return table instanceof ReferenceTable ? (ReferenceTable)table : null;
            }
        };
    }

    protected SchemaCombo<T> addSchemaCombo(Composite container) {
        return new SchemaCombo<T>(this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected void propertyChanged(String propertyName) {
                super.propertyChanged(propertyName);
                if (propertyName == "defaultCatalog" || propertyName == "specifiedCatalog") {
                    this.repopulate();
                }
            }

            protected String getDefaultValue() {
                return ((ReadOnlyReferenceTable)this.getSubject()).getDefaultSchema();
            }

            protected void setValue(String value) {
                ((ReferenceTable)this.getSubject()).setSpecifiedSchema(value);
            }

            protected String getValue() {
                return ((ReadOnlyReferenceTable)this.getSubject()).getSpecifiedSchema();
            }

            @Override
            protected SchemaContainer getDbSchemaContainer_() {
                ReferenceTable table = this.getTable();
                return table == null ? null : table.getDbSchemaContainer();
            }

            protected ReferenceTable getTable() {
                ReadOnlyReferenceTable table = (ReadOnlyReferenceTable)this.getSubject();
                return table instanceof ReferenceTable ? (ReferenceTable)table : null;
            }
        };
    }

    protected CatalogCombo<T> addCatalogCombo(Composite container) {
        return new CatalogCombo<T>(this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected String getDefaultValue() {
                return ((ReadOnlyReferenceTable)this.getSubject()).getDefaultCatalog();
            }

            protected void setValue(String value) {
                ((ReferenceTable)this.getSubject()).setSpecifiedCatalog(value);
            }

            protected String getValue() {
                return ((ReadOnlyReferenceTable)this.getSubject()).getSpecifiedCatalog();
            }
        };
    }

    void editJoinColumn(ReadOnlyJoinColumn joinColumn) {
        JoinColumnInReferenceTableDialog dialog = new JoinColumnInReferenceTableDialog(this.getShell(), (ReadOnlyReferenceTable)this.getSubject(), joinColumn);
        dialog.openDialog(this.buildEditJoinColumnPostExecution());
    }

    void editJoinColumn(JoinColumnInReferenceTableStateObject stateObject) {
        stateObject.updateJoinColumn((BaseJoinColumn)stateObject.getJoinColumn());
    }

    void updateJoinColumns() {
        if (this.isPopulating()) {
            return;
        }
        ReferenceTable referenceTable = (ReferenceTable)this.getSubject();
        if (referenceTable == null) {
            return;
        }
        boolean selected = this.overrideDefaultJoinColumnsCheckBox.getSelection();
        this.setPopulating(true);
        try {
            if (selected) {
                referenceTable.convertDefaultJoinColumnToSpecified();
                this.setSelectedJoinColumn(referenceTable.getSpecifiedJoinColumn(0));
            } else {
                int index = referenceTable.getSpecifiedJoinColumnsSize();
                while (--index >= 0) {
                    referenceTable.removeSpecifiedJoinColumn(index);
                }
            }
        }
        finally {
            this.setPopulating(false);
        }
    }

    protected abstract boolean tableIsVirtual(T var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JoinColumnPaneEnablerHolder
    extends CachingTransformationPropertyValueModel<T, Boolean> {
        private StateChangeListener stateChangeListener;

        public JoinColumnPaneEnablerHolder() {
            super((PropertyValueModel)new ValueListAdapter((WritablePropertyValueModel)new ReadOnlyWritablePropertyValueModelWrapper(ReferenceTableComposite.this.getSubjectHolder()), new String[]{"specifiedJoinColumns"}));
            this.stateChangeListener = this.buildStateChangeListener();
        }

        private StateChangeListener buildStateChangeListener() {
            return new StateChangeListener(){

                public void stateChanged(StateChangeEvent event) {
                    JoinColumnPaneEnablerHolder.this.valueStateChanged();
                }
            };
        }

        void valueStateChanged() {
            Object oldValue = this.cachedValue;
            Object newValue = this.transformNew((ReadOnlyReferenceTable)this.valueHolder.getValue());
            this.firePropertyChanged("value", oldValue, newValue);
        }

        protected Boolean transform(T value) {
            if (value == null) {
                return Boolean.FALSE;
            }
            return (Boolean)super.transform(value);
        }

        protected Boolean transform_(T value) {
            boolean virtual = ReferenceTableComposite.this.tableIsVirtual(value);
            return !virtual && value.getSpecifiedJoinColumnsSize() > 0;
        }

        protected void engageModel() {
            super.engageModel();
            this.valueHolder.addStateChangeListener(this.stateChangeListener);
        }

        protected void disengageModel() {
            this.valueHolder.removeStateChangeListener(this.stateChangeListener);
            super.disengageModel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class JoinColumnsProvider
    implements JoinColumnsComposite.JoinColumnsEditor<T> {
        JoinColumnsProvider() {
        }

        @Override
        public void addJoinColumn(T subject) {
            ReferenceTableComposite.this.addJoinColumn(subject);
        }

        @Override
        public ReadOnlyJoinColumn getDefaultJoinColumn(T subject) {
            return subject.getDefaultJoinColumn();
        }

        @Override
        public String getDefaultPropertyName() {
            return "defaultJoinColumn";
        }

        @Override
        public void editJoinColumn(T subject, ReadOnlyJoinColumn joinColumn) {
            ReferenceTableComposite.this.editJoinColumn(joinColumn);
        }

        @Override
        public boolean hasSpecifiedJoinColumns(T subject) {
            return subject.hasSpecifiedJoinColumns();
        }

        @Override
        public void removeJoinColumns(T subject, int[] selectedIndices) {
            int index = selectedIndices.length;
            while (index-- > 0) {
                ((ReferenceTable)subject).removeSpecifiedJoinColumn(selectedIndices[index]);
            }
        }

        @Override
        public ListIterable<ReadOnlyJoinColumn> getSpecifiedJoinColumns(T subject) {
            return new SuperListIterableWrapper(subject.getSpecifiedJoinColumns());
        }

        @Override
        public int getSpecifiedJoinColumnsSize(T subject) {
            return subject.getSpecifiedJoinColumnsSize();
        }

        @Override
        public String getSpecifiedJoinColumnsListPropertyName() {
            return "specifiedJoinColumns";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverrideDefaultJoinColumnHolder
    extends ListPropertyValueModelAdapter<Boolean>
    implements WritablePropertyValueModel<Boolean> {
        public OverrideDefaultJoinColumnHolder() {
            super(ReferenceTableComposite.this.buildSpecifiedJoinColumnsListHolder());
        }

        protected Boolean buildValue() {
            return this.listHolder.size() > 0;
        }

        public void setValue(Boolean value) {
            ReferenceTableComposite.this.updateJoinColumns();
        }
    }
}

