/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.oracle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherDefaultListener;

public class AdvancedJDBCORDescriptorBuilder
extends PublisherDefaultListener {
    public static final String ITEMS_ATTRIBUTE_NAME = "items";
    protected Stack<PublisherDefaultListener.ListenerHelper> stac = new Stack();
    protected Map<String, ObjectRelationalDataTypeDescriptor> descriptorMap = new HashMap<String, ObjectRelationalDataTypeDescriptor>();
    protected String packageName = null;

    public AdvancedJDBCORDescriptorBuilder() {
    }

    public AdvancedJDBCORDescriptorBuilder(String packageName) {
        this();
        this.packageName = packageName;
    }

    public List<ObjectRelationalDataTypeDescriptor> getDescriptors() {
        if (this.descriptorMap.isEmpty()) {
            return null;
        }
        ArrayList<ObjectRelationalDataTypeDescriptor> al = new ArrayList<ObjectRelationalDataTypeDescriptor>();
        al.addAll(this.descriptorMap.values());
        return al;
    }

    @Override
    public void beginPackage(String packageName) {
        if (this.packageName == null) {
            this.packageName = this.trimDotPrefix(packageName);
        }
    }

    @Override
    public void handleMethodReturn(String returnTypeName) {
        String returnType = this.trimDotPrefix(returnTypeName);
        this.stac.push(new PublisherDefaultListener.ReturnArgHelper("", returnType));
    }

    @Override
    public void handleSqlType(String sqlTypeName, int typecode, String targetTypeName) {
        if (!this.stac.isEmpty()) {
            PublisherDefaultListener.ListenerHelper listenerHelper = this.stac.pop();
            if (listenerHelper.isAttribute()) {
                PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper;
                ObjectRelationalDataTypeDescriptor ordt;
                DatabaseMapping dm;
                PublisherDefaultListener.AttributeFieldHelper attributeFieldHelper = (PublisherDefaultListener.AttributeFieldHelper)listenerHelper;
                attributeFieldHelper.setSqlTypeName(sqlTypeName);
                String fieldName = attributeFieldHelper.attributeFieldName();
                String attributeName = fieldName.toLowerCase();
                PublisherDefaultListener.ListenerHelper listenerHelper2 = this.stac.peek();
                if (listenerHelper2.isObject()) {
                    int numAttributes;
                    PublisherDefaultListener.ObjectTypeHelper objectTypeHelper = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper2;
                    ObjectRelationalDataTypeDescriptor ordt2 = this.descriptorMap.get(objectTypeHelper.objectTypename());
                    DatabaseMapping dm2 = ordt2.getMappingForAttributeName(attributeName);
                    if (dm2 == null) {
                        ordt2.addFieldOrdering(fieldName);
                        DirectToFieldMapping dfm = new DirectToFieldMapping();
                        dfm.setFieldName(fieldName);
                        dfm.setAttributeName(attributeName);
                        ordt2.addMapping((DatabaseMapping)dfm);
                    }
                    if ((numAttributes = objectTypeHelper.decrNumAttributes()) == 0) {
                        this.stac.pop();
                    }
                } else if (listenerHelper2.isArray() && (dm = (ordt = this.descriptorMap.get((sqlArrayTypeHelper = (PublisherDefaultListener.SqlArrayTypeHelper)listenerHelper2).arrayTypename())).getMappingForAttributeName(attributeName)) == null) {
                    ordt.addFieldOrdering(fieldName);
                    ArrayMapping arrayMapping = new ArrayMapping();
                    arrayMapping.setFieldName(fieldName);
                    arrayMapping.setAttributeName(attributeName);
                    arrayMapping.useCollectionClass(ArrayList.class);
                    arrayMapping.setStructureName(sqlArrayTypeHelper.arrayTypename().toUpperCase());
                    DatabaseField nestedField = new DatabaseField("");
                    nestedField.setSqlType(typecode);
                    nestedField.setColumnDefinition(sqlTypeName);
                    ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)arrayMapping.getField();
                    field.setNestedTypeField(nestedField);
                    ordt.addMapping((DatabaseMapping)arrayMapping);
                }
            } else if (listenerHelper.isArray()) {
                PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper = (PublisherDefaultListener.SqlArrayTypeHelper)listenerHelper;
                ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(sqlArrayTypeHelper.arrayTypename());
                DatabaseMapping dm = ordt.getMappingForAttributeName(ITEMS_ATTRIBUTE_NAME);
                if (dm == null) {
                    ArrayMapping arrayMapping = new ArrayMapping();
                    arrayMapping.setFieldName(ITEMS_ATTRIBUTE_NAME);
                    arrayMapping.setAttributeName(ITEMS_ATTRIBUTE_NAME);
                    arrayMapping.useCollectionClass(ArrayList.class);
                    arrayMapping.setStructureName(sqlArrayTypeHelper.arrayTypename().toUpperCase());
                    DatabaseField nestedField = new DatabaseField("");
                    nestedField.setSqlType(typecode);
                    nestedField.setColumnDefinition(sqlTypeName);
                    ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)arrayMapping.getField();
                    field.setNestedTypeField(nestedField);
                    ordt.addMapping((DatabaseMapping)arrayMapping);
                }
                PublisherDefaultListener.ListenerHelper listenerHelper3 = this.stac.peek();
                PublisherDefaultListener.ListenerHelper listenerHelper4 = null;
                if (listenerHelper3.isArray()) {
                    PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper2 = (PublisherDefaultListener.SqlArrayTypeHelper)listenerHelper3;
                    this.stac.pop();
                    ObjectRelationalDataTypeDescriptor ordt3 = this.descriptorMap.get(sqlArrayTypeHelper2.arrayTypename());
                    DatabaseMapping dm3 = ordt3.getMappingForAttributeName(ITEMS_ATTRIBUTE_NAME);
                    if (dm3 == null) {
                        ObjectArrayMapping objArrayMapping = new ObjectArrayMapping();
                        objArrayMapping.setAttributeName(ITEMS_ATTRIBUTE_NAME);
                        objArrayMapping.setFieldName(ITEMS_ATTRIBUTE_NAME);
                        objArrayMapping.setStructureName(sqlArrayTypeHelper2.arrayTypename().toUpperCase());
                        objArrayMapping.setReferenceClassName(ordt.getJavaClassName());
                        objArrayMapping.useCollectionClass(ArrayList.class);
                        ordt3.addMapping((DatabaseMapping)objArrayMapping);
                    }
                    if (this.stac.peek().isAttribute()) {
                        listenerHelper4 = this.stac.peek();
                    }
                } else {
                    listenerHelper4 = listenerHelper3;
                }
                if (listenerHelper4.isAttribute()) {
                    PublisherDefaultListener.AttributeFieldHelper fieldHelper = (PublisherDefaultListener.AttributeFieldHelper)listenerHelper4;
                    this.stac.pop();
                    PublisherDefaultListener.ListenerHelper listenerHelper5 = this.stac.peek();
                    if (listenerHelper5.isObject()) {
                        int numAttributes;
                        String fieldName;
                        PublisherDefaultListener.ObjectTypeHelper objectTypeHelper = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper5;
                        ObjectRelationalDataTypeDescriptor ordt2 = this.descriptorMap.get(objectTypeHelper.objectTypename());
                        DatabaseMapping dm2 = ordt2.getMappingForAttributeName((fieldName = fieldHelper.attributeFieldName()).toLowerCase());
                        if (dm2 == null) {
                            ordt2.addFieldOrdering(fieldName);
                            if (listenerHelper4 == listenerHelper3) {
                                ArrayMapping arrayMapping2 = new ArrayMapping();
                                arrayMapping2.setAttributeName(fieldName.toLowerCase());
                                arrayMapping2.setFieldName(fieldName);
                                arrayMapping2.setStructureName(sqlArrayTypeHelper.arrayTypename().toUpperCase());
                                arrayMapping2.useCollectionClass(ArrayList.class);
                                DatabaseField nestedField = new DatabaseField("");
                                nestedField.setSqlType(typecode);
                                nestedField.setColumnDefinition(sqlTypeName);
                                ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)arrayMapping2.getField();
                                field.setNestedTypeField(nestedField);
                                ordt2.addMapping((DatabaseMapping)arrayMapping2);
                            } else {
                                ObjectArrayMapping objArrayMapping2 = new ObjectArrayMapping();
                                objArrayMapping2.setAttributeName(fieldName.toLowerCase());
                                objArrayMapping2.setFieldName(fieldName);
                                String structureName = "";
                                String referenceClassName = "";
                                if (listenerHelper3.isObject()) {
                                    PublisherDefaultListener.ObjectTypeHelper objectTypeHelper2 = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper3;
                                    structureName = objectTypeHelper2.objectTypename().toUpperCase();
                                    ObjectRelationalDataTypeDescriptor ordt3 = this.descriptorMap.get(objectTypeHelper2.objectTypename());
                                    referenceClassName = ordt3.getJavaClassName();
                                } else if (listenerHelper3.isArray()) {
                                    PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper3 = (PublisherDefaultListener.SqlArrayTypeHelper)listenerHelper3;
                                    structureName = sqlArrayTypeHelper3.arrayTypename().toUpperCase();
                                    ObjectRelationalDataTypeDescriptor ordt3 = this.descriptorMap.get(sqlArrayTypeHelper3.arrayTypename());
                                    referenceClassName = ordt3.getJavaClassName();
                                }
                                objArrayMapping2.setStructureName(structureName);
                                objArrayMapping2.setReferenceClassName(referenceClassName);
                                objArrayMapping2.useCollectionClass(ArrayList.class);
                                ordt2.addMapping((DatabaseMapping)objArrayMapping2);
                            }
                        }
                        if ((numAttributes = objectTypeHelper.decrNumAttributes()) == 0) {
                            this.stac.pop();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void handleObjectType(String objectTypeName, String targetTypeName, int numAttributes) {
        if (numAttributes > 0) {
            String objectTypeNameAlias = this.trimDotPrefix(objectTypeName).toLowerCase();
            ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(objectTypeNameAlias);
            if (ordt == null) {
                ordt = new ObjectRelationalDataTypeDescriptor();
                ordt.setStructureName(objectTypeNameAlias.toUpperCase());
                ordt.descriptorIsAggregate();
                ordt.setAlias(objectTypeNameAlias);
                ordt.setJavaClassName(this.packageName.toLowerCase() + "." + objectTypeNameAlias);
                ordt.getQueryManager();
                this.descriptorMap.put(objectTypeNameAlias, ordt);
            }
            if (!this.stac.isEmpty()) {
                DatabaseMapping dm;
                PublisherDefaultListener.SqlArrayTypeHelper sqlArrayTypeHelper;
                String sqlArrayTypeNameAlias;
                ObjectRelationalDataTypeDescriptor ordt2;
                PublisherDefaultListener.ListenerHelper listenerHelper = this.stac.peek();
                if (listenerHelper.isAttribute()) {
                    PublisherDefaultListener.ObjectTypeHelper objectTypeHelper2;
                    String objectTypeNameAlias2;
                    ObjectRelationalDataTypeDescriptor ordt22;
                    PublisherDefaultListener.AttributeFieldHelper fieldHelper = (PublisherDefaultListener.AttributeFieldHelper)this.stac.pop();
                    String fieldName = fieldHelper.attributeFieldName();
                    String attributeName = fieldName.toLowerCase();
                    PublisherDefaultListener.ListenerHelper listenerHelper2 = this.stac.peek();
                    if (listenerHelper2.isObject() && (ordt22 = this.descriptorMap.get(objectTypeNameAlias2 = (objectTypeHelper2 = (PublisherDefaultListener.ObjectTypeHelper)listenerHelper2).objectTypename())) != null) {
                        int numAttributes2;
                        DatabaseMapping dm2 = ordt22.getMappingForAttributeName(attributeName);
                        if (dm2 == null) {
                            ordt22.addFieldOrdering(fieldName);
                            StructureMapping structMapping = new StructureMapping();
                            structMapping.setFieldName(fieldName);
                            structMapping.setAttributeName(attributeName);
                            structMapping.setReferenceClassName(ordt.getJavaClassName());
                            ordt22.addMapping((DatabaseMapping)structMapping);
                        }
                        if ((numAttributes2 = objectTypeHelper2.decrNumAttributes()) == 0) {
                            this.stac.pop();
                        }
                    }
                } else if (listenerHelper.isArray() && (ordt2 = this.descriptorMap.get(sqlArrayTypeNameAlias = (sqlArrayTypeHelper = (PublisherDefaultListener.SqlArrayTypeHelper)this.stac.pop()).arrayTypename())) != null && (dm = ordt2.getMappingForAttributeName(ITEMS_ATTRIBUTE_NAME)) == null) {
                    ObjectArrayMapping arrayMapping = new ObjectArrayMapping();
                    arrayMapping.setAttributeName(ITEMS_ATTRIBUTE_NAME);
                    arrayMapping.setFieldName(ITEMS_ATTRIBUTE_NAME);
                    arrayMapping.setStructureName(sqlArrayTypeNameAlias.toUpperCase());
                    arrayMapping.setReferenceClassName(ordt.getJavaClassName());
                    arrayMapping.useCollectionClass(ArrayList.class);
                    ordt2.addMapping((DatabaseMapping)arrayMapping);
                }
            }
            this.stac.push(new PublisherDefaultListener.ObjectTypeHelper(objectTypeNameAlias, targetTypeName, numAttributes));
        }
    }

    @Override
    public void handleSqlArrayType(String arrayTypename, String targetTypeName) {
        String arrayTypenameAlias = this.trimDotPrefix(arrayTypename).toLowerCase();
        ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(arrayTypenameAlias);
        if (ordt == null) {
            ordt = new ObjectRelationalDataTypeDescriptor();
            ordt.descriptorIsAggregate();
            ordt.setAlias(arrayTypenameAlias);
            ordt.setJavaClassName(this.packageName.toLowerCase() + "." + arrayTypenameAlias + "_CollectionWrapper");
            ordt.getQueryManager();
            this.descriptorMap.put(arrayTypenameAlias, ordt);
        }
        if (!this.stac.isEmpty()) {
            // empty if block
        }
        this.stac.push(new PublisherDefaultListener.SqlArrayTypeHelper(arrayTypenameAlias, targetTypeName));
    }

    @Override
    public void handleSqlTableType(String tableTypeName, String targetTypeName) {
        String sqlTableTypeAlias = this.trimDotPrefix(tableTypeName).toLowerCase();
        ObjectRelationalDataTypeDescriptor ordt = this.descriptorMap.get(sqlTableTypeAlias);
        if (ordt == null) {
            ordt = new ObjectRelationalDataTypeDescriptor();
            ordt.descriptorIsAggregate();
            ordt.setAlias(sqlTableTypeAlias);
            ordt.setJavaClassName(this.packageName.toLowerCase() + "." + sqlTableTypeAlias + "_CollectionWrapper");
            ordt.getQueryManager();
            this.descriptorMap.put(sqlTableTypeAlias, ordt);
        }
        this.stac.push(new PublisherDefaultListener.SqlArrayTypeHelper(sqlTableTypeAlias, targetTypeName));
    }

    @Override
    public void handleAttributeField(String attributeFieldName, int idx) {
        this.stac.push(new PublisherDefaultListener.AttributeFieldHelper(attributeFieldName, null));
    }
}

