/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPACreateFactory {
    public static final String JPA_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.jpa.jar";
    public static final String ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY = "org.eclipse.jpt.eclipselink.jar";
    private static JPACreateFactory factory = null;
    private IFacetedProject facetedProject;
    private IProject project;
    private IJavaProject javaProject;
    JpaProject jpaProject;

    public static synchronized JPACreateFactory instance() {
        if (factory == null) {
            factory = new JPACreateFactory();
        }
        return factory;
    }

    private IProject buildPlatformProject(String projectName) throws CoreException {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        description.setAutoBuilding(true);
        ResourcesPlugin.getWorkspace().setDescription(description);
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        p.create(null);
        p.open(null);
        return p;
    }

    protected IDataModel buildJpaConfigDataModel() {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new JpaFacetInstallDataModelProvider());
        dataModel.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        dataModel.setProperty("JpaFacetDataModelProperties.PLATFORM", null);
        dataModel.setProperty("JpaFacetInstallDataModelProperties.CREATE_ORM_XML", (Object)Boolean.TRUE);
        return dataModel;
    }

    public JpaProject createJPAProject(String projectName) throws CoreException {
        return this.createJPAProject(projectName, null, "1.0");
    }

    public JpaProject createJPA20Project(String projectName) throws CoreException {
        return this.createJPAProject(projectName, null, "2.0");
    }

    public JpaProject createJPAProject(String projectName, IDataModel jpaConfig, String jpaFacetVersion) throws CoreException {
        this.project = this.buildPlatformProject(projectName);
        this.javaProject = this.createJavaProject(this.project, true);
        if (jpaConfig != null) {
            jpaFacetVersion = jpaConfig.getStringProperty("IFacetDataModelProperties.FACET_VERSION_STR");
        }
        this.installFacet(this.facetedProject, "jst.utility", "1.0");
        this.installFacet(this.facetedProject, "jpt.jpa", jpaFacetVersion, jpaConfig);
        this.addJar(this.javaProject, JPACreateFactory.jpaJarName());
        if (JPACreateFactory.eclipseLinkJarName() != null) {
            this.addJar(this.javaProject, JPACreateFactory.eclipseLinkJarName());
        }
        this.project.refreshLocal(2, null);
        this.jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.project);
        int cnt = 0;
        while (this.jpaProject == null && cnt < 1000) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.project);
            ++cnt;
        }
        this.jpaProject.setDiscoversAnnotatedClasses(true);
        return this.jpaProject;
    }

    public static String eclipseLinkJarName() {
        return JPACreateFactory.getSystemProperty(ECLIPSELINK_JAR_NAME_SYSTEM_PROPERTY);
    }

    public void installFacet(IFacetedProject facetedProject, String facetName, String versionName) throws CoreException {
        this.installFacet(facetedProject, facetName, versionName, null);
    }

    public void uninstallFacet(IFacetedProject facetedProject, String facetName, String versionName) throws CoreException {
        this.uninstallFacet(facetedProject, facetName, versionName, null);
    }

    public void installFacet(IFacetedProject facetedProject, String facetName, String versionName, IDataModel config) throws CoreException {
        facetedProject.installProjectFacet(this.facetVersion(facetName, versionName), (Object)config, null);
    }

    public void uninstallFacet(IFacetedProject facetedProject, String facetName, String versionName, IDataModel config) throws CoreException {
        facetedProject.uninstallProjectFacet(this.facetVersion(facetName, versionName), (Object)config, null);
    }

    private IProjectFacetVersion facetVersion(String facetName, String versionName) {
        return ProjectFacetsManager.getProjectFacet((String)facetName).getVersion(versionName);
    }

    protected static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    public void addJar(IJavaProject javaProject, String jarPath) throws JavaModelException {
        this.addClasspathEntry(javaProject, JavaCore.newLibraryEntry((IPath)new Path(jarPath), null, null));
    }

    private void addClasspathEntry(IJavaProject javaProject, IClasspathEntry entry) throws JavaModelException {
        javaProject.setRawClasspath((IClasspathEntry[])ArrayTools.add((Object[])javaProject.getRawClasspath(), (Object)entry), null);
    }

    private IFacetedProject createFacetedProject(IProject project) throws CoreException {
        return ProjectFacetsManager.create((IProject)project, (boolean)true, null);
    }

    public IJavaProject createJavaProject(IProject project, boolean autoBuild) throws CoreException {
        this.facetedProject = this.createFacetedProject(project);
        this.installFacet(this.facetedProject, "jst.java", "5.0");
        this.javaProject = JavaCore.create((IProject)project);
        return this.javaProject;
    }

    public static String jpaJarName() {
        return JPACreateFactory.getSystemProperty(JPA_JAR_NAME_SYSTEM_PROPERTY);
    }

    public IFile createEntity(JpaProject jpaProject, String fullyQualifiedName) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(fullyQualifiedName, ".");
        ArrayList<String> nameElements = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            nameElements.add(tokenizer.nextToken());
        }
        ArrayList<String> packageFragments = new ArrayList<String>();
        int i = 0;
        while (i < nameElements.size() - 1) {
            packageFragments.add((String)nameElements.get(i));
            ++i;
        }
        String[] packageStrings = new String[packageFragments.size()];
        int i2 = 0;
        while (i2 < packageFragments.size()) {
            packageStrings[i2] = (String)packageFragments.get(i2);
            ++i2;
        }
        String name = (String)nameElements.get(Math.max(0, nameElements.size() - 1));
        JpaRootContextNode jpaProjectContent = jpaProject.getRootContextNode();
        PersistenceXml persXML = jpaProjectContent.getPersistenceXml();
        int cnt = 0;
        while (persXML == null && cnt < 100) {
            Thread.sleep(250L);
            persXML = jpaProjectContent.getPersistenceXml();
            ++cnt;
        }
        if (persXML == null) {
            throw new NullPointerException("The persistence XML is not created");
        }
        IFile entity1 = this.createEntityInProject(jpaProject.getProject(), packageStrings, name);
        JavaResourceAbstractType jrpt = jpaProject.getJavaResourceType(fullyQualifiedName);
        cnt = 0;
        while (jrpt == null && cnt < 100) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
            jrpt = jpaProject.getJavaResourceType(fullyQualifiedName);
            ++cnt;
        }
        if (jrpt == null) {
            throw new NullPointerException("The entity '" + fullyQualifiedName + "' could not be created");
        }
        return entity1;
    }

    public IFile createEntityInProject(IProject project, String[] packageFragments, String entityName) throws IOException, CoreException, JavaModelException {
        String folderName = this.getFolderName(project, packageFragments);
        String packageName = packageFragments[0];
        int i = 1;
        while (i < packageFragments.length) {
            packageName = String.valueOf(packageName) + "." + packageFragments[i];
            ++i;
        }
        Path path = new Path(folderName);
        IFolder folder = project.getFolder((IPath)path);
        return this.createEntity(folder, packageName, entityName);
    }

    private String getFolderName(IProject project, String[] packageFragments) throws JavaModelException {
        IClasspathEntry[] classpathEntries;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] packageFragmentRoots = new IPackageFragmentRoot[]{};
        IClasspathEntry[] iClasspathEntryArray = classpathEntries = javaProject.getRawClasspath();
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 3) {
                packageFragmentRoots = javaProject.getPackageFragmentRoots(classpathEntry);
                break;
            }
            ++n2;
        }
        String folderName = packageFragmentRoots[0].getResource().getName();
        String[] stringArray = packageFragments;
        int n3 = packageFragments.length;
        n = 0;
        while (n < n3) {
            String fragment = stringArray[n];
            folderName = String.valueOf(folderName) + '/' + fragment;
            ++n;
        }
        return folderName;
    }

    private IFile createEntity(IFolder folder, String packageName, String entityName) throws IOException, CoreException {
        IFile file;
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            this.createDirectories((IContainer)folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(entityShortName) + ".java")).exists()) {
            String content = "package " + packageName + ";\n\n" + "import javax.persistence.*;\n\n" + "@Entity \n" + "public class " + entityShortName + " {\n" + "\tprivate int id;\n" + "\t@Id \n" + "\tpublic int getId() {\n" + "\t\treturn id;\n" + "\t}\n" + "\tpublic void setId(int id) {\n" + "\t\tthis.id = id;\n" + "\t}\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    public IFile createEntityWithCompositePKInProject(IProject project, String[] packageFragments, String entityName) throws IOException, CoreException, JavaModelException {
        String folderName = this.getFolderName(project, packageFragments);
        String packageName = packageFragments[0];
        int i = 1;
        while (i < packageFragments.length) {
            packageName = String.valueOf(packageName) + "." + packageFragments[i];
            ++i;
        }
        Path path = new Path(folderName);
        IFolder folder = project.getFolder((IPath)path);
        return this.createEntityWithCompositePK(folder, packageName, entityName);
    }

    public IFile createIdClassInProject(IProject project, String[] packageFragments, String entityName) throws IOException, CoreException, JavaModelException {
        String folderName = this.getFolderName(project, packageFragments);
        String packageName = packageFragments[0];
        int i = 1;
        while (i < packageFragments.length) {
            packageName = String.valueOf(packageName) + "." + packageFragments[i];
            ++i;
        }
        Path path = new Path(folderName);
        IFolder folder = project.getFolder((IPath)path);
        return this.createIdClass(folder, packageName, entityName);
    }

    public IFile createEmbeddedClassInProject(IProject project, String[] packageFragments, String entityName) throws IOException, CoreException, JavaModelException {
        String folderName = this.getFolderName(project, packageFragments);
        String packageName = packageFragments[0];
        int i = 1;
        while (i < packageFragments.length) {
            packageName = String.valueOf(packageName) + "." + packageFragments[i];
            ++i;
        }
        Path path = new Path(folderName);
        IFolder folder = project.getFolder((IPath)path);
        return this.createEmbeddedClass(folder, packageName, entityName);
    }

    public IFile createEntityWithEmbeddedPKInProject(IProject project, String[] packageFragments, String entityName) throws IOException, CoreException, JavaModelException {
        String folderName = this.getFolderName(project, packageFragments);
        String packageName = packageFragments[0];
        int i = 1;
        while (i < packageFragments.length) {
            packageName = String.valueOf(packageName) + "." + packageFragments[i];
            ++i;
        }
        Path path = new Path(folderName);
        IFolder folder = project.getFolder((IPath)path);
        return this.createEntityWithEmbeddedPK(folder, packageName, entityName);
    }

    private IFile createEntityWithCompositePK(IFolder folder, String packageName, String entityName) throws IOException, CoreException {
        IFile file;
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            this.createDirectories((IContainer)folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(entityShortName) + ".java")).exists()) {
            String content = "package " + packageName + ";\n\n" + "import javax.persistence.*;\n\n" + "@Entity \n" + "@IdClass(" + entityShortName + "Id.class)" + "public class " + entityShortName + " {\n" + "\t@Id \n" + "\tprivate String firstName;\n" + "\t@Id \n" + "\tprivate String lastName;\n" + " public " + entityShortName + "Id() {}\n" + " public " + entityShortName + "Id(String firstName, String lastName)\n{" + "     this.firstName = firstName;\n" + "     this.lastName = lastName;\n" + " }\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    private IFile createIdClass(IFolder folder, String packageName, String entityName) throws IOException, CoreException {
        IFile file;
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            this.createDirectories((IContainer)folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(entityShortName) + "Id.java")).exists()) {
            String content = "package " + packageName + ";\n\n" + "import javax.persistence.*;\n\n" + "import java.io.Serializable;" + "public class " + entityShortName + "Id {\n" + "\tprivate String firstName;\n" + "\tprivate String lastName;\n" + "\tpublic String getFirstName() {\n" + "\t\treturn firstName;\n" + "\t}\n" + "\tpublic void setFirstName(String firstName) {\n" + "\t\tthis.firstName = firstName;\n" + "\t}\n" + "\tpublic String getLastName() {\n" + "\t\treturn lastName;\n" + "\t}\n" + "\tpublic void setLastName(String lastName) {\n" + "\t\tthis.lastName = lastName;\n" + "\t}\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    private IFile createEntityWithEmbeddedPK(IFolder folder, String packageName, String entityName) throws IOException, CoreException {
        IFile file;
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            this.createDirectories((IContainer)folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(entityShortName) + ".java")).exists()) {
            String content = "package " + packageName + ";\n\n" + "import javax.persistence.*;\n\n" + "@Entity\n" + "public class " + entityShortName + " {\n" + "@EmbeddedId\n" + "\tprivate " + entityShortName + "Id id;\n" + "public void setId(" + entityShortName + "Id param) {\n" + "\tthis.id = param;\n" + "}\n" + "public " + entityShortName + "Id getId() {\n" + "return id;\n" + "}\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    private IFile createEmbeddedClass(IFolder folder, String packageName, String entityName) throws IOException, CoreException {
        IFile file;
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            this.createDirectories((IContainer)folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(entityShortName) + ".java")).exists()) {
            String content = "package " + packageName + ";\n\n" + "import javax.persistence.*;\n" + "@Embeddable\n" + "public class " + entityShortName + " {\n" + "private String firstName;\n" + "public String getFirstName() {\n" + "\treturn firstName;\n" + "}\n" + "public void setFirstName(String firstName) {\n" + "this.firstName = firstName;\n" + "}\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    private void createDirectories(IContainer container, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        if (container != null && container instanceof IFolder && !(folder = (IFolder)container).exists()) {
            IContainer parent = folder.getParent();
            this.createDirectories(parent, force, local, null);
            folder.create(force, local, monitor);
        }
    }

    public static ReadOnlyPersistentAttribute getPersistentAttribute(IFile entity, String attributeName) {
        Set<ReadOnlyPersistentAttribute> result = JPACreateFactory.getEntityFields(entity);
        for (ReadOnlyPersistentAttribute attribute : result) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute;
        }
        return null;
    }

    public static PersistentType getPersistentType(IFile file) {
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        Iterator<JpaStructureNode> iterator = JPACreateFactory.getRootNodes(jpaFile).iterator();
        if (iterator.hasNext()) {
            JpaStructureNode node = iterator.next();
            PersistentType entity = (PersistentType)node;
            return entity;
        }
        return null;
    }

    private static Iterable<JpaStructureNode> getRootNodes(JpaFile jpaFile) {
        if (jpaFile == null) {
            return EmptyIterable.instance();
        }
        return jpaFile.getRootStructureNodes();
    }

    public static Set<ReadOnlyPersistentAttribute> getEntityFields(IFile file) {
        HashSet<ReadOnlyPersistentAttribute> result = new HashSet<ReadOnlyPersistentAttribute>();
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        if (jpaFile == null) {
            return result;
        }
        for (JpaStructureNode node : JPACreateFactory.getRootNodes(jpaFile)) {
            PersistentType entity = (PersistentType)node;
            for (ReadOnlyPersistentAttribute attribute : entity.getAllAttributes()) {
                result.add(attribute);
            }
        }
        return result;
    }

    public void addAttributes(IFile entity, String attName, String attType, String annotation, String attActName, boolean isCollection) {
        JavaPersistentType javaPersistentType = (JavaPersistentType)JPACreateFactory.getPersistentType(entity);
        int cnt = 0;
        while (javaPersistentType == null && cnt < 100) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            javaPersistentType = (JavaPersistentType)JPACreateFactory.getPersistentType(entity);
            ++cnt;
        }
        if (javaPersistentType == null) {
            throw new RuntimeException("The entity could not be created");
        }
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)entity);
        JpaArtifactFactory.instance().addNewAttribute(javaPersistentType, compilationUnit, attName, attType, annotation, attActName, isCollection, null);
    }

    private IFile createFieldAnnotatedEntity(IFolder folder, String packageName, String entityName) throws IOException, CoreException {
        IFile file;
        String entityShortName = entityName.substring(entityName.lastIndexOf(46) + 1);
        if (!folder.exists()) {
            this.createDirectories((IContainer)folder, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!(file = folder.getFile(String.valueOf(entityShortName) + ".java")).exists()) {
            String content = "package " + packageName + ";\n\n" + "import javax.persistence.*;\n\n" + "@Entity \n" + "public class " + entityShortName + " {\n" + "\t@Id \n" + "\tprivate int id;\n" + "\tpublic int getId() {\n" + "\t\treturn id;\n" + "\t}\n" + "\tpublic void setId(int id) {\n" + "\t\tthis.id = id;\n" + "\t}\n" + "}";
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                stream.write(content.getBytes());
                stream.flush();
                file.create((InputStream)new ByteArrayInputStream(stream.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                stream.close();
            }
        }
        return file;
    }

    public IFile createFieldAnnotatedEntityInProject(IProject project, String[] packageFragments, String entityName) throws IOException, CoreException, JavaModelException {
        String folderName = this.getFolderName(project, packageFragments);
        String packageName = packageFragments[0];
        int i = 1;
        while (i < packageFragments.length) {
            packageName = String.valueOf(packageName) + "." + packageFragments[i];
            ++i;
        }
        Path path = new Path(folderName);
        IFolder folder = project.getFolder((IPath)path);
        return this.createFieldAnnotatedEntity(folder, packageName, entityName);
    }
}

