/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.feature;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IDirectEditingInfo;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickAddAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util.IEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClickAddFeatureTest {
    private IJPAEditorFeatureProvider featureProvider;
    private ICreateContext context;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    JavaPersistentType jpt = null;
    ICompilationUnit cu = null;

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.eclipse.jpt.jpa.jar", "C:\\lib\\persistence-api-1.0.jar");
        JptJpaCorePlugin.getJpaProjectManager();
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        ContainerShape cs = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        this.context = (ICreateContext)EasyMock.createMock(ICreateContext.class);
        EasyMock.expect((Object)this.context.getTargetContainer()).andStubReturn((Object)cs);
        EasyMock.expect((Object)this.context.getX()).andStubReturn((Object)0);
        EasyMock.expect((Object)this.context.getY()).andStubReturn((Object)0);
        EasyMock.expect((Object)this.context.getWidth()).andStubReturn((Object)100);
        EasyMock.expect((Object)this.context.getHeight()).andStubReturn((Object)100);
        EasyMock.expect((Object)this.context.getTargetConnection()).andStubReturn(null);
        IDirectEditingInfo dei = (IDirectEditingInfo)EasyMock.createMock(IDirectEditingInfo.class);
        dei.setActive(true);
        Thread.sleep(2000L);
        this.jpt = (JavaPersistentType)JPACreateFactory.getPersistentType(entity);
        int cnt = 0;
        while (cnt < 50 && this.jpt == null) {
            Thread.sleep(200L);
            this.jpt = (JavaPersistentType)JPACreateFactory.getPersistentType(entity);
            ++cnt;
        }
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement((PictogramElement)cs)).andStubReturn((Object)this.jpt);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)this.jpt)).andStubReturn(null);
        this.cu = JavaCore.createCompilationUnitFrom((IFile)entity);
        cnt = 0;
        while (cnt < 50 && this.cu == null) {
            Thread.sleep(200L);
            this.cu = JavaCore.createCompilationUnitFrom((IFile)entity);
            ++cnt;
        }
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((JavaPersistentType)EasyMock.anyObject())).andReturn((Object)this.cu).anyTimes();
        EasyMock.expect((Object)this.featureProvider.addIfPossible((IAddContext)EasyMock.isA(IAddContext.class))).andStubReturn(null);
        EasyMock.expect((Object)this.featureProvider.getDirectEditingInfo()).andStubReturn((Object)dei);
        IJPAEditorUtil ut = (IJPAEditorUtil)EasyMock.createMock(IJPAEditorUtil.class);
        EasyMock.expect((Object)this.featureProvider.getJPAEditorUtil()).andStubReturn((Object)ut);
        IDiagramTypeProvider diagramTypeProvider = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andStubReturn((Object)diagramTypeProvider);
        IEditor ed = (IEditor)EasyMock.createMock(IEditor.class);
        EasyMock.expect((Object)diagramTypeProvider.getDiagramEditor()).andStubReturn((Object)ed);
        IWorkbenchPartSite ws = (IWorkbenchPartSite)EasyMock.createMock(IWorkbenchPartSite.class);
        EasyMock.expect((Object)ed.getSite()).andStubReturn((Object)ws);
        ut.formatCode((ICompilationUnit)EasyMock.anyObject(), (IWorkbenchSite)((IWorkbenchPartSite)EasyMock.anyObject()));
        this.featureProvider.addAddIgnore(this.jpt, "attribute1");
        EasyMock.replay((Object[])new Object[]{this.featureProvider, cs, this.context, dei, diagramTypeProvider, ed, ws, ut});
    }

    @Test
    public void testClickAddAttributeButtonFeature() {
        if (this.jpt == null || this.cu == null) {
            return;
        }
        ClickAddAttributeButtonFeature feature = new ClickAddAttributeButtonFeature((IFeatureProvider)this.featureProvider);
        Object[] created = feature.create(this.context);
        Assert.assertNotNull((Object)created[0]);
    }
}

