/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.relation;

import java.util.Iterator;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaOneToOneMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRelationAttributesTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)CreateRelationAttributesTest.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((JavaPersistentType)EasyMock.isA(JavaPersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.featureProvider});
    }

    public static PersistentType getPersistentType(IFile file) {
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        Iterator<JpaStructureNode> iterator = CreateRelationAttributesTest.getRootNodes(jpaFile).iterator();
        if (iterator.hasNext()) {
            JpaStructureNode node = iterator.next();
            PersistentType entity = (PersistentType)node;
            return entity;
        }
        return null;
    }

    private static Iterable<JpaStructureNode> getRootNodes(JpaFile jpaFile) {
        if (jpaFile == null) {
            return EmptyIterable.instance();
        }
        return jpaFile.getRootStructureNodes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)file);
        if (!cu.isWorkingCopy()) {
            try {
                cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return cu;
    }

    @Test
    public void testAddAnnotation() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = JPACreateFactory.instance().createEntityInProject(this.jpaProject.getProject(), new String[]{"abc"}, "Customer");
        IFile addressFile = JPACreateFactory.instance().createEntityInProject(this.jpaProject.getProject(), new String[]{"abc"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("abc.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("abc.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        JavaPersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(this.featureProvider, t1, t2, "add", "add", false, this.createCompilationUnitFrom(customerFile), this.createCompilationUnitFrom(addressFile));
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        PersistenceUnit pu = (PersistenceUnit)this.jpaProject.getRootContextNode().getPersistenceXml().getPersistence().getPersistenceUnits().iterator().next();
        t1 = pu.getPersistentType("abc.Customer");
        Assert.assertNotNull((Object)attr);
    }

    @Test
    public void testAddOneToOneUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        IFile addressFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Address");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)addressFile.exists());
        JavaResourceAbstractType addressType = this.jpaProject.getJavaResourceType("com.Address");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        JavaPersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(this.featureProvider, t1, t2, "address", "address", false, this.createCompilationUnitFrom((IFile)t1.getResource()), this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)attr);
        JpaArtifactFactory.instance().addOneToOneUnidirectionalRelation((IFeatureProvider)this.featureProvider, t1, attr);
        JavaPersistentType pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (pt == null) {
            Thread.sleep(200L);
            pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, addressType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute cPersistentAttribute = pt.resolveAttribute("address");
        Assert.assertNotNull((Object)cPersistentAttribute);
    }

    @Test
    public void testAddOneToOneBidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Customer");
        IFile creditCardFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "CreditCard");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)creditCardFile.exists());
        JavaResourceAbstractType creditCardType = this.jpaProject.getJavaResourceType("com.CreditCard");
        Assert.assertNotNull((Object)creditCardFile);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getQualifiedName());
        }
        JavaPersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(this.featureProvider, t1, t2, "creditCard", "creditCard", false, this.createCompilationUnitFrom((IFile)t1.getResource()), this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)attr);
        JavaPersistentAttribute attr2 = JpaArtifactFactory.instance().addAttribute(this.featureProvider, t2, t1, "customer", "customer", false, this.createCompilationUnitFrom((IFile)t2.getResource()), this.createCompilationUnitFrom((IFile)t1.getResource()));
        Assert.assertNotNull((Object)attr2);
        JpaArtifactFactory.instance().addOneToOneBidirectionalRelation((IFeatureProvider)this.featureProvider, t1, attr, t2, attr2);
        JavaPersistentType ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (ownerPersistentType == null) {
            Thread.sleep(200L);
            ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute ownerPersistentAttribute = ownerPersistentType.resolveAttribute("creditCard");
        Assert.assertNotNull((Object)ownerPersistentAttribute);
        Assert.assertTrue((boolean)(ownerPersistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping ownerSideMapping = ownerPersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(ownerSideMapping instanceof JavaOneToOneMapping));
        Assert.assertTrue((boolean)((JavaOneToOneMapping)ownerSideMapping).isRelationshipOwner());
        JavaPersistentType inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getQualifiedName());
        while (inversePersistentType == null) {
            Thread.sleep(200L);
            inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, creditCardType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute inversePersistentAttribute = inversePersistentType.resolveAttribute("customer");
        Assert.assertNotNull((Object)inversePersistentAttribute);
        Assert.assertTrue((boolean)(inversePersistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping inverseSideMapping = inversePersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(inverseSideMapping instanceof JavaOneToOneMapping));
        Assert.assertFalse((boolean)((JavaOneToOneMapping)inverseSideMapping).isRelationshipOwner());
    }

    @Test
    public void testAddOneToManyUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Customer");
        IFile phoneFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Phone");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        Assert.assertTrue((boolean)phoneFile.exists());
        JavaResourceAbstractType phoneType = this.jpaProject.getJavaResourceType("com.Phone");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, phoneType.getQualifiedName());
        while (t2 == null) {
            Thread.sleep(200L);
            t2 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, phoneType.getQualifiedName());
        }
        JavaPersistentAttribute attr = JpaArtifactFactory.instance().addAttribute(this.featureProvider, t1, t2, "phones", "phones", true, this.createCompilationUnitFrom((IFile)t1.getResource()), this.createCompilationUnitFrom((IFile)t2.getResource()));
        Assert.assertNotNull((Object)attr);
        JpaArtifactFactory.instance().addOneToManyUnidirectionalRelation((IFeatureProvider)this.featureProvider, t1, attr, false);
        JavaPersistentType pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (pt == null) {
            Thread.sleep(200L);
            pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, phoneType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute cPersistentAttribute = pt.resolveAttribute("phones");
        Assert.assertNotNull((Object)cPersistentAttribute);
        AttributeMapping mapping = cPersistentAttribute.getMapping();
        Assert.assertNotNull((Object)mapping);
        Assert.assertTrue((boolean)(mapping instanceof JavaOneToManyMapping));
        Assert.assertTrue((boolean)((JavaOneToManyMapping)mapping).isRelationshipOwner());
    }

    @Test
    public void testAddOneToManyBidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile cruiseFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Cruise");
        IFile reservationFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Reservation");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)cruiseFile.exists());
        JavaResourceAbstractType cruiseType = this.jpaProject.getJavaResourceType("com.Cruise");
        Assert.assertNotNull((Object)cruiseType);
        JavaPersistentType singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        while (singleSidePersistentType == null) {
            Thread.sleep(200L);
            singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        }
        Assert.assertTrue((boolean)reservationFile.exists());
        JavaResourceAbstractType reservationType = this.jpaProject.getJavaResourceType("com.Reservation");
        Assert.assertNotNull((Object)reservationFile);
        JavaPersistentType manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        while (manySidePersistentType == null) {
            Thread.sleep(200L);
            manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        }
        JavaPersistentAttribute singleSideAttribute = JpaArtifactFactory.instance().addAttribute(this.featureProvider, singleSidePersistentType, manySidePersistentType, "reservations", "reservations", true, this.createCompilationUnitFrom((IFile)singleSidePersistentType.getResource()), this.createCompilationUnitFrom((IFile)manySidePersistentType.getResource()));
        Assert.assertNotNull((Object)singleSideAttribute);
        JavaPersistentAttribute manySideAttribute = JpaArtifactFactory.instance().addAttribute(this.featureProvider, manySidePersistentType, singleSidePersistentType, "cruise", "cruise", false, this.createCompilationUnitFrom((IFile)manySidePersistentType.getResource()), this.createCompilationUnitFrom((IFile)singleSidePersistentType.getResource()));
        Assert.assertNotNull((Object)manySideAttribute);
        JpaArtifactFactory.instance().addOneToManyBidirectionalRelation((IFeatureProvider)this.featureProvider, singleSidePersistentType, singleSideAttribute, manySidePersistentType, manySideAttribute, false);
        JavaPersistentType inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        while (inversePersistentType == null) {
            Thread.sleep(200L);
            inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute inversePersistentAttribute = inversePersistentType.resolveAttribute("reservations");
        Assert.assertNotNull((Object)inversePersistentAttribute);
        Assert.assertTrue((boolean)(inversePersistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping inverseSideMapping = inversePersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(inverseSideMapping instanceof JavaOneToManyMapping));
        Assert.assertFalse((boolean)((JavaOneToManyMapping)inverseSideMapping).isRelationshipOwner());
        JavaPersistentType ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        int c = 0;
        while (ownerPersistentType == null && c < 50) {
            Thread.sleep(200L);
            ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
            ++c;
        }
        Assert.assertNotNull((Object)ownerPersistentType);
        ReadOnlyPersistentAttribute ownerPersistentAttribute = ownerPersistentType.resolveAttribute("cruise");
        c = 0;
        while (ownerPersistentAttribute == null && c < 50) {
            Thread.sleep(200L);
            ownerPersistentAttribute = ownerPersistentType.resolveAttribute("cruise");
            ++c;
        }
        Assert.assertNotNull((Object)ownerPersistentAttribute);
        Assert.assertTrue((boolean)(ownerPersistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping ownerSideMapping = ownerPersistentAttribute.getMapping();
        c = 0;
        while (ownerSideMapping == null && c < 50) {
            Thread.sleep(200L);
            ownerSideMapping = ownerPersistentAttribute.getMapping();
            ++c;
        }
        if (ownerSideMapping == null) {
            return;
        }
        Assert.assertNotNull((String)"ownerSideMapping must not be null", (Object)ownerSideMapping);
        Assert.assertTrue((String)("ownerSideMapping class is " + ownerSideMapping.getClass().getName()), (boolean)JavaManyToOneMapping.class.isInstance(ownerSideMapping));
        Assert.assertTrue((boolean)((JavaManyToOneMapping)ownerSideMapping).isRelationshipOwner());
    }

    @Test
    public void testAddManyToOneUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile cruiseFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Cruise");
        IFile shipFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Ship");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)cruiseFile.exists());
        JavaResourceAbstractType cruiseType = this.jpaProject.getJavaResourceType("com.Cruise");
        Assert.assertNotNull((Object)cruiseType);
        JavaPersistentType manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        while (manySidePersistentType == null) {
            Thread.sleep(200L);
            manySidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        }
        Assert.assertTrue((boolean)shipFile.exists());
        JavaResourceAbstractType shipType = this.jpaProject.getJavaResourceType("com.Ship");
        Assert.assertNotNull((Object)cruiseType);
        JavaPersistentType singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, shipType.getQualifiedName());
        while (singleSidePersistentType == null) {
            Thread.sleep(200L);
            singleSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, shipType.getQualifiedName());
        }
        JavaPersistentAttribute mappedAttribute = JpaArtifactFactory.instance().addAttribute(this.featureProvider, manySidePersistentType, singleSidePersistentType, "ship", "ship", true, this.createCompilationUnitFrom((IFile)manySidePersistentType.getResource()), this.createCompilationUnitFrom((IFile)singleSidePersistentType.getResource()));
        Assert.assertNotNull((Object)mappedAttribute);
        JpaArtifactFactory.instance().addManyToOneUnidirectionalRelation((IFeatureProvider)this.featureProvider, manySidePersistentType, mappedAttribute);
        JavaPersistentType pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cruiseType.getQualifiedName());
        while (pt == null) {
            Thread.sleep(200L);
            pt = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, shipType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute cPersistentAttribute = pt.resolveAttribute("ship");
        int cnt = 0;
        while (cPersistentAttribute == null && cnt < 100) {
            Thread.sleep(250L);
            cPersistentAttribute = pt.resolveAttribute("ship");
            ++cnt;
        }
        Assert.assertNotNull((Object)cPersistentAttribute);
        AttributeMapping mapping = cPersistentAttribute.getMapping();
        cnt = 0;
        while (mapping == null && cnt < 100) {
            Thread.sleep(250L);
            mapping = cPersistentAttribute.getMapping();
            ++cnt;
        }
        Assert.assertNotNull((Object)mapping);
        Assert.assertTrue((boolean)(mapping instanceof JavaManyToOneMapping));
        Assert.assertTrue((boolean)((JavaManyToOneMapping)mapping).isRelationshipOwner());
    }

    @Test
    public void testAddManyToManyBidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile reservationFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Reservation");
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Customer");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)reservationFile.exists());
        JavaResourceAbstractType reservationType = this.jpaProject.getJavaResourceType("com.Reservation");
        Assert.assertNotNull((Object)reservationType);
        JavaPersistentType ownerSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        while (ownerSidePersistentType == null) {
            Thread.sleep(200L);
            ownerSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        }
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.Customer");
        Assert.assertNotNull((Object)customerFile);
        JavaPersistentType inverseSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (inverseSidePersistentType == null) {
            Thread.sleep(200L);
            inverseSidePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        JavaPersistentAttribute ownerSideAttribute = JpaArtifactFactory.instance().addAttribute(this.featureProvider, ownerSidePersistentType, inverseSidePersistentType, "customers", "customers", true, this.createCompilationUnitFrom((IFile)ownerSidePersistentType.getResource()), this.createCompilationUnitFrom((IFile)inverseSidePersistentType.getResource()));
        Assert.assertNotNull((Object)ownerSideAttribute);
        JavaPersistentAttribute inverseSideAttributes = JpaArtifactFactory.instance().addAttribute(this.featureProvider, inverseSidePersistentType, ownerSidePersistentType, "reservations", "reservations", true, this.createCompilationUnitFrom((IFile)inverseSidePersistentType.getResource()), this.createCompilationUnitFrom((IFile)ownerSidePersistentType.getResource()));
        Assert.assertNotNull((Object)inverseSideAttributes);
        JpaArtifactFactory.instance().addManyToManyBidirectionalRelation((IFeatureProvider)this.featureProvider, ownerSidePersistentType, ownerSideAttribute, inverseSidePersistentType, inverseSideAttributes, false);
        JavaPersistentType ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        while (ownerPersistentType == null) {
            Thread.sleep(200L);
            ownerPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute ownerPersistentAttribute = ownerPersistentType.resolveAttribute("customers");
        Assert.assertNotNull((Object)ownerPersistentAttribute);
        Assert.assertTrue((boolean)(ownerPersistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping ownerSideMapping = ownerPersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(ownerSideMapping instanceof JavaManyToManyMapping));
        Assert.assertTrue((boolean)((JavaManyToManyMapping)ownerSideMapping).isRelationshipOwner());
        JavaPersistentType inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (inversePersistentType == null) {
            Thread.sleep(200L);
            inversePersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute inversePersistentAttribute = inversePersistentType.resolveAttribute("reservations");
        Assert.assertNotNull((Object)inversePersistentAttribute);
        Assert.assertTrue((boolean)(inversePersistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping inverseSideMapping = inversePersistentAttribute.getMapping();
        Assert.assertTrue((boolean)(inverseSideMapping instanceof JavaManyToManyMapping));
        Assert.assertFalse((boolean)((JavaManyToManyMapping)inverseSideMapping).isRelationshipOwner());
    }

    @Test
    public void testAddManyToManyUnidirectionalRelationAttributes() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        IFile reservationFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Reservation");
        IFile cabinFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Cabin");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)reservationFile.exists());
        JavaResourceAbstractType reservationType = this.jpaProject.getJavaResourceType("com.Reservation");
        Assert.assertNotNull((Object)reservationType);
        JavaPersistentType annotatedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        while (annotatedPersistentType == null) {
            Thread.sleep(200L);
            annotatedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        }
        Assert.assertTrue((boolean)cabinFile.exists());
        JavaResourceAbstractType cabinType = this.jpaProject.getJavaResourceType("com.Cabin");
        Assert.assertNotNull((Object)cabinFile);
        JavaPersistentType referencedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cabinType.getQualifiedName());
        while (referencedPersistentType == null) {
            Thread.sleep(200L);
            referencedPersistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, cabinType.getQualifiedName());
        }
        JavaPersistentAttribute annotatedSideAttribute = JpaArtifactFactory.instance().addAttribute(this.featureProvider, annotatedPersistentType, referencedPersistentType, "cabins", "cabins", true, this.createCompilationUnitFrom((IFile)annotatedPersistentType.getResource()), this.createCompilationUnitFrom((IFile)referencedPersistentType.getResource()));
        Assert.assertNotNull((Object)annotatedSideAttribute);
        JpaArtifactFactory.instance().addManyToManyUnidirectionalRelation((IFeatureProvider)this.featureProvider, annotatedPersistentType, annotatedSideAttribute, false);
        JavaPersistentType persistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        while (persistentType == null) {
            Thread.sleep(200L);
            persistentType = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, reservationType.getQualifiedName());
        }
        ReadOnlyPersistentAttribute persistentAttribute = persistentType.resolveAttribute("cabins");
        Assert.assertNotNull((Object)persistentAttribute);
        Assert.assertTrue((boolean)(persistentAttribute instanceof JavaPersistentAttribute));
        AttributeMapping mapping = persistentAttribute.getMapping();
        Assert.assertTrue((boolean)(mapping instanceof JavaManyToManyMapping));
        Assert.assertTrue((boolean)((JavaManyToManyMapping)mapping).isRelationshipOwner());
    }
}

