/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.JpaRootContextNode;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CreateDeleteEntity {
    private static final String TEST_PROJECT = "Test";
    private JPACreateFactory factory = JPACreateFactory.instance();
    private JpaProject jpaProject = null;

    @Before
    public void setUp() throws Exception {
        JptJpaCorePlugin.getJpaProjectManager();
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        Thread.sleep(2000L);
    }

    @Test
    public void testCreateAndDeleteEntity() throws Exception {
        Assert.assertNotNull((Object)this.jpaProject);
        JpaRootContextNode jpaProjectContent = this.jpaProject.getRootContextNode();
        Assert.assertNotNull((Object)jpaProjectContent);
        Thread.sleep(2000L);
        PersistenceXml persistenceXml = jpaProjectContent.getPersistenceXml();
        Assert.assertNotNull((Object)persistenceXml);
        Persistence p = persistenceXml.getPersistence();
        int cnt = 0;
        while (p == null && cnt < 25) {
            Thread.sleep(250L);
            p = persistenceXml.getPersistence();
            ++cnt;
        }
        Assert.assertTrue((String)"Can't obtain persistence object", (p != null ? 1 : 0) != 0);
        Assert.assertTrue((persistenceXml.getPersistence().getPersistenceUnitsSize() == 1 ? 1 : 0) != 0);
        PersistenceUnit persistenceUnit = (PersistenceUnit)persistenceXml.getPersistence().getPersistenceUnits().iterator().next();
        Assert.assertNotNull((Object)persistenceUnit);
        Assert.assertTrue((persistenceUnit.getClassRefsSize() == 0 ? 1 : 0) != 0);
        IFile entity1 = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com"}, "Entity1");
        Assert.assertTrue((boolean)entity1.exists());
        JavaResourceAbstractType persistenceType = this.jpaProject.getJavaResourceType("com.Entity1");
        int c = 0;
        while (persistenceType == null && c < 100) {
            Thread.sleep(500L);
            this.jpaProject.getProject().refreshLocal(2, null);
            persistenceType = this.jpaProject.getJavaResourceType("com.Entity1");
            ++c;
        }
        Assert.assertNotNull((Object)persistenceType);
        JavaPersistentType t = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, persistenceType.getQualifiedName());
        c = 0;
        while (t == null && c < 100) {
            Thread.sleep(500L);
            t = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, persistenceType.getQualifiedName());
            ++c;
        }
        JpaArtifactFactory.instance().deletePersistenceTypeResource((PersistentType)t);
        Assert.assertFalse((boolean)entity1.exists());
        this.jpaProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        JptJpaCorePlugin.rebuildJpaProject((IProject)this.jpaProject.getProject());
        persistenceType = this.jpaProject.getJavaResourceType("com.Entity1");
        c = 0;
        while (persistenceType != null && c < 250) {
            Thread.sleep(500L);
            this.jpaProject = JptJpaCorePlugin.getJpaProject((IProject)this.jpaProject.getProject());
            persistenceType = this.jpaProject.getJavaResourceType("com.Entity1");
            ++c;
        }
        Assert.assertNull((Object)persistenceType);
        Assert.assertNotNull((Object)this.jpaProject);
    }
}

