/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util;

import java.util.List;
import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IPeServiceUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.SizePosition;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.eclipse.swt.graphics.Point;
import org.junit.Assert;
import org.junit.Test;

public class JPAEditorUtilTest {
    @Test
    public void testCapitalizeFirstLetter() {
        String s = "abcdef";
        String res = JPAEditorUtil.capitalizeFirstLetter((String)s);
        Assert.assertEquals((Object)res.substring(0, 1), (Object)"A");
        Assert.assertEquals((Object)s.substring(1), (Object)res.substring(1));
    }

    @Test
    public void testDecapitalizeFirstLetter() {
        String s = "ABCDEFGHIJK";
        String res = JPAEditorUtil.decapitalizeFirstLetter((String)s);
        Assert.assertEquals((Object)res.substring(0, 1), (Object)"a");
        Assert.assertEquals((Object)s.substring(1), (Object)res.substring(1));
    }

    @Test
    public void testRevertFirstLetterCase() {
        String s = "ABCDEFGHIJK";
        String res = JPAEditorUtil.revertFirstLetterCase((String)s);
        Assert.assertEquals((Object)res.substring(0, 1), (Object)"a");
        Assert.assertEquals((Object)s.substring(1), (Object)res.substring(1));
        String res1 = JPAEditorUtil.revertFirstLetterCase((String)res);
        Assert.assertEquals((Object)res1.substring(0, 1), (Object)"A");
        Assert.assertEquals((Object)res1.substring(1), (Object)res.substring(1));
    }

    @Test
    public void testEqualsIgnoreFirstLetterCase() {
        String s1 = "abcdefg";
        String s2 = "Abcdefg";
        Assert.assertTrue((boolean)JPAEditorUtil.equalsIgnoreFirstLetterCase((String)s1, (String)s2));
        s1 = "";
        s2 = "";
        Assert.assertTrue((boolean)JPAEditorUtil.equalsIgnoreFirstLetterCase((String)s1, (String)s2));
        s1 = "gjgIyguiyGUYuGUYGuyg";
        s2 = "gjgIyguiyGUYuGUYGuyg";
        Assert.assertTrue((boolean)JPAEditorUtil.equalsIgnoreFirstLetterCase((String)s1, (String)s2));
        s1 = "LjgIyguiyGUYuGUYGuyg";
        s2 = "LjgIyguiyGUYuGUYGuyg";
        Assert.assertTrue((boolean)JPAEditorUtil.equalsIgnoreFirstLetterCase((String)s1, (String)s2));
        s1 = "gjgIyguiyGUYuGUYGuygs";
        s2 = "gjgIyguiyGUYuGUYGuyg";
        Assert.assertFalse((boolean)JPAEditorUtil.equalsIgnoreFirstLetterCase((String)s1, (String)s2));
        s1 = "LjgIyguiyGUyuGUYGuyg";
        s2 = "LjgIyguiyGUYuGUYGuyg";
        Assert.assertFalse((boolean)JPAEditorUtil.equalsIgnoreFirstLetterCase((String)s1, (String)s2));
    }

    @Test
    public void testReturnSimpleName() {
        String s = "";
        String res = JPAEditorUtil.returnSimpleName((String)s);
        Assert.assertEquals((Object)s, (Object)res);
        s = "jdhksajhdk";
        res = JPAEditorUtil.returnSimpleName((String)s);
        Assert.assertEquals((Object)s, (Object)res);
        s = "jdhksajhdk.";
        res = JPAEditorUtil.returnSimpleName((String)s);
        Assert.assertEquals((Object)"", (Object)res);
        s = ".jdhksajhdk";
        res = JPAEditorUtil.returnSimpleName((String)s);
        Assert.assertEquals((Object)"jdhksajhdk", (Object)res);
        s = "jdhks.ajhdk";
        res = JPAEditorUtil.returnSimpleName((String)s);
        Assert.assertEquals((Object)"ajhdk", (Object)res);
        s = "dss.dsdsd.jd.hks.ajhdk";
        res = JPAEditorUtil.returnSimpleName((String)s);
        Assert.assertEquals((Object)"ajhdk", (Object)res);
    }

    @Test
    public void testStripQuotes() {
        String s = "";
        String res = JPAEditorUtil.stripQuotes((String)s);
        Assert.assertEquals((Object)"", (Object)res);
        s = "\"\"";
        res = JPAEditorUtil.stripQuotes((String)s);
        Assert.assertEquals((Object)"", (Object)res);
        s = "\"fdsjfjslkdjflks\"";
        res = JPAEditorUtil.stripQuotes((String)s);
        Assert.assertEquals((Object)"fdsjfjslkdjflks", (Object)res);
        s = "\"fdsjfjslkdjflks";
        res = JPAEditorUtil.stripQuotes((String)s);
        Assert.assertEquals((Object)"\"fdsjfjslkdjflks", (Object)res);
        s = "fdsjfjslkdjflks\"";
        res = JPAEditorUtil.stripQuotes((String)s);
        Assert.assertEquals((Object)"fdsjfjslkdjflks\"", (Object)res);
    }

    public void testGetJPType() throws Exception {
        String TEST_PROJECT = "Test";
        JpaProject jpaProject = null;
        JPACreateFactory factory = null;
        String testProjectName = String.valueOf(TEST_PROJECT) + "_" + System.currentTimeMillis();
        factory = JPACreateFactory.instance();
        jpaProject = factory.createJPAProject(testProjectName);
        Assert.assertNotNull((Object)jpaProject);
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)jpaProject);
        IFile customerFile = factory.createEntityInProject(jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        ICompilationUnit cu = this.createCompilationUnitFrom(customerFile);
        Thread.sleep(2000L);
        JavaPersistentType jpt = JPAEditorUtil.getJPType((ICompilationUnit)cu);
        Assert.assertEquals((Object)customerType.getQualifiedName(), (Object)jpt.getName());
    }

    @Test
    public void testProduceValidAttributeName() {
        String s = "a";
        String res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)s, (Object)res);
        s = "A";
        res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)"a", (Object)res);
        s = "aT";
        res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)"AT", (Object)res);
        s = "At";
        res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)"at", (Object)res);
        s = "AT";
        res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)"AT", (Object)res);
        s = "a1";
        res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)"a1", (Object)res);
        s = "A1";
        res = JPAEditorUtil.produceValidAttributeName((String)s);
        Assert.assertEquals((Object)"a1", (Object)res);
    }

    public void testCreateImports() throws Exception {
        String TEST_PROJECT = "Test";
        JpaProject jpaProject = null;
        JPACreateFactory factory = null;
        String testProjectName = String.valueOf(TEST_PROJECT) + "_" + System.currentTimeMillis();
        factory = JPACreateFactory.instance();
        jpaProject = factory.createJPAProject(testProjectName);
        Assert.assertNotNull((Object)jpaProject);
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)jpaProject);
        IFile customerFile = factory.createEntityInProject(jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        ICompilationUnit cu = this.createCompilationUnitFrom(customerFile);
        JPAEditorUtil.createImports((ICompilationUnit)cu, (String)"java.util.Hashtable<java.lang.StringBuffer,java.lang.Set<java.lang.String>>");
    }

    @Test
    public void testSizePosition() {
        SizePosition sp = new SizePosition(1, 2, 3, 4);
        Assert.assertTrue((sp.getWidth() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getHeight() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getX() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((sp.getY() == 4 ? 1 : 0) != 0);
    }

    public void testGetText() throws Exception {
        String TEST_PROJECT = "Test";
        JpaProject jpaProject = null;
        JPACreateFactory factory = null;
        String testProjectName = String.valueOf(TEST_PROJECT) + "_" + System.currentTimeMillis();
        factory = JPACreateFactory.instance();
        jpaProject = factory.createJPAProject(testProjectName);
        Assert.assertNotNull((Object)jpaProject);
        Thread.sleep(2000L);
        Assert.assertNotNull((Object)jpaProject);
        IFile customerFile = factory.createEntityInProject(jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(jpaProject, customerType.getQualifiedName());
        int cnt = 0;
        while (cnt < 25 && t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(jpaProject, customerType.getQualifiedName());
            ++cnt;
        }
        if (t1 == null) {
            return;
        }
        Assert.assertNotNull((Object)JPAEditorUtil.getText((JavaPersistentType)t1));
        Assert.assertNotNull((Object)JPAEditorUtil.getTooltipText((JavaPersistentType)t1));
        JavaPersistentAttribute jpa = t1.getAttributeNamed("id");
        Assert.assertNotNull((Object)jpa);
        Assert.assertNotNull((Object)JPAEditorUtil.getText((JavaPersistentAttribute)jpa));
        Assert.assertNotNull((Object)JPAEditorUtil.getTooltipText((JavaPersistentAttribute)jpa));
    }

    public void testSetJPTNameInShape() {
        ContainerShape cs = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        Shape sh = (Shape)EasyMock.createMock(Shape.class);
        GraphicsAlgorithm ga = (GraphicsAlgorithm)EasyMock.createMock(GraphicsAlgorithm.class);
        IPeServiceUtil peUtil = (IPeServiceUtil)EasyMock.createMock(IPeServiceUtil.class);
        EasyMock.expect((Object)peUtil.getPropertyValue((PropertyContainer)sh, JPAEditorConstants.PROP_SHAPE_TYPE)).andStubReturn((Object)JPAEditorConstants.ShapeType.HEADER.toString());
        BasicInternalEList shapes = new BasicInternalEList(Shape.class);
        shapes.add((Object)sh);
        EasyMock.expect((Object)cs.getChildren()).andStubReturn((Object)shapes);
        Text txt = (Text)EasyMock.createMock(Text.class);
        BasicInternalEList gaCh = new BasicInternalEList(GraphicsAlgorithm.class);
        gaCh.add((Object)txt);
        EasyMock.expect((Object)sh.getGraphicsAlgorithm()).andStubReturn((Object)ga);
        EasyMock.expect((Object)ga.getGraphicsAlgorithmChildren()).andStubReturn((Object)gaCh);
        txt.setValue("NewJPTName");
        EasyMock.replay((Object[])new Object[]{cs, sh, ga, peUtil, txt});
        JPAEditorUtil.setJPTNameInShape((ContainerShape)cs, (String)"NewJPTName", (IPeServiceUtil)peUtil);
    }

    public void testCreateBendPointList1() {
        FreeFormConnection c = (FreeFormConnection)EasyMock.createMock(FreeFormConnection.class);
        Anchor startAnchor = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor endAnchor = (Anchor)EasyMock.createMock(Anchor.class);
        AnchorContainer startAnchorContainer = (AnchorContainer)EasyMock.createMock(AnchorContainer.class);
        AnchorContainer endAnchorContainer = (AnchorContainer)EasyMock.createMock(AnchorContainer.class);
        EasyMock.expect((Object)c.getStart()).andStubReturn((Object)startAnchor);
        EasyMock.expect((Object)c.getEnd()).andStubReturn((Object)endAnchor);
        EasyMock.expect((Object)startAnchor.getParent()).andStubReturn((Object)startAnchorContainer);
        EasyMock.expect((Object)endAnchor.getParent()).andStubReturn((Object)endAnchorContainer);
        RoundedRectangle rectStart = (RoundedRectangle)EasyMock.createMock(RoundedRectangle.class);
        RoundedRectangle rectEnd = (RoundedRectangle)EasyMock.createMock(RoundedRectangle.class);
        EasyMock.expect((Object)startAnchorContainer.getGraphicsAlgorithm()).andStubReturn((Object)rectStart);
        EasyMock.expect((Object)endAnchorContainer.getGraphicsAlgorithm()).andStubReturn((Object)rectEnd);
        EasyMock.expect((Object)rectStart.getX()).andStubReturn((Object)100);
        EasyMock.expect((Object)rectStart.getY()).andStubReturn((Object)100);
        EasyMock.expect((Object)rectStart.getWidth()).andStubReturn((Object)200);
        EasyMock.expect((Object)rectStart.getHeight()).andStubReturn((Object)120);
        EasyMock.expect((Object)rectEnd.getX()).andStubReturn((Object)100);
        EasyMock.expect((Object)rectEnd.getY()).andStubReturn((Object)800);
        EasyMock.expect((Object)rectEnd.getWidth()).andStubReturn((Object)200);
        EasyMock.expect((Object)rectEnd.getHeight()).andStubReturn((Object)120);
        BasicInternalEList ccc = new BasicInternalEList(Connection.class);
        EasyMock.expect((Object)startAnchor.getOutgoingConnections()).andStubReturn((Object)ccc);
        EasyMock.expect((Object)endAnchor.getOutgoingConnections()).andStubReturn((Object)ccc);
        EasyMock.replay((Object[])new Object[]{c, startAnchor, endAnchor, startAnchorContainer, endAnchorContainer, rectStart, rectEnd});
        List lst = JPAEditorUtil.createBendPointList((FreeFormConnection)c, (boolean)false);
        Assert.assertTrue((lst.size() == 2 ? 1 : 0) != 0);
        for (Point p : lst) {
            Assert.assertTrue((p.x >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((p.y >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((p.x <= 1000000 ? 1 : 0) != 0);
            Assert.assertTrue((p.y <= 1000000 ? 1 : 0) != 0);
        }
    }

    public void testCreateBendPointList2() {
        FreeFormConnection c = (FreeFormConnection)EasyMock.createMock(FreeFormConnection.class);
        Anchor startAnchor = (Anchor)EasyMock.createMock(Anchor.class);
        Anchor endAnchor = (Anchor)EasyMock.createMock(Anchor.class);
        AnchorContainer startAnchorContainer = (AnchorContainer)EasyMock.createMock(AnchorContainer.class);
        AnchorContainer endAnchorContainer = (AnchorContainer)EasyMock.createMock(AnchorContainer.class);
        EasyMock.expect((Object)c.getStart()).andStubReturn((Object)startAnchor);
        EasyMock.expect((Object)c.getEnd()).andStubReturn((Object)endAnchor);
        EasyMock.expect((Object)startAnchor.getParent()).andStubReturn((Object)startAnchorContainer);
        EasyMock.expect((Object)endAnchor.getParent()).andStubReturn((Object)endAnchorContainer);
        RoundedRectangle rectStart = (RoundedRectangle)EasyMock.createMock(RoundedRectangle.class);
        RoundedRectangle rectEnd = (RoundedRectangle)EasyMock.createMock(RoundedRectangle.class);
        EasyMock.expect((Object)startAnchorContainer.getGraphicsAlgorithm()).andStubReturn((Object)rectStart);
        EasyMock.expect((Object)endAnchorContainer.getGraphicsAlgorithm()).andStubReturn((Object)rectEnd);
        EasyMock.expect((Object)rectStart.getX()).andStubReturn((Object)100);
        EasyMock.expect((Object)rectStart.getY()).andStubReturn((Object)100);
        EasyMock.expect((Object)rectStart.getWidth()).andStubReturn((Object)200);
        EasyMock.expect((Object)rectStart.getHeight()).andStubReturn((Object)120);
        EasyMock.expect((Object)rectEnd.getX()).andStubReturn((Object)800);
        EasyMock.expect((Object)rectEnd.getY()).andStubReturn((Object)100);
        EasyMock.expect((Object)rectEnd.getWidth()).andStubReturn((Object)200);
        EasyMock.expect((Object)rectEnd.getHeight()).andStubReturn((Object)120);
        BasicInternalEList ccc = new BasicInternalEList(Connection.class);
        EasyMock.expect((Object)startAnchor.getOutgoingConnections()).andStubReturn((Object)ccc);
        EasyMock.expect((Object)endAnchor.getOutgoingConnections()).andStubReturn((Object)ccc);
        EasyMock.replay((Object[])new Object[]{c, startAnchor, endAnchor, startAnchorContainer, endAnchorContainer, rectStart, rectEnd});
        List lst = JPAEditorUtil.createBendPointList((FreeFormConnection)c, (boolean)false);
        Assert.assertTrue((lst.size() == 2 ? 1 : 0) != 0);
        for (Point p : lst) {
            Assert.assertTrue((p.x >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((p.y >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((p.x <= 1000000 ? 1 : 0) != 0);
            Assert.assertTrue((p.y <= 1000000 ? 1 : 0) != 0);
        }
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @Test
    public void testAreHeadersEqual() {
        Assert.assertTrue((boolean)JPAEditorUtil.areHeadersEqual((String)"header", (String)"header"));
        Assert.assertTrue((boolean)JPAEditorUtil.areHeadersEqual((String)"* header", (String)"header"));
        Assert.assertTrue((boolean)JPAEditorUtil.areHeadersEqual((String)"header", (String)"* header"));
        Assert.assertFalse((boolean)JPAEditorUtil.areHeadersEqual((String)"header", (String)"headers"));
        Assert.assertFalse((boolean)JPAEditorUtil.areHeadersEqual((String)"headers", (String)"header"));
        Assert.assertFalse((boolean)JPAEditorUtil.areHeadersEqual((String)"* headers", (String)"header"));
        Assert.assertFalse((boolean)JPAEditorUtil.areHeadersEqual((String)"* header", (String)"headers"));
        Assert.assertFalse((boolean)JPAEditorUtil.areHeadersEqual((String)"headers", (String)"* header"));
        Assert.assertFalse((boolean)JPAEditorUtil.areHeadersEqual((String)"header", (String)"* headers"));
    }
}

