/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JpaArtifactFactoryTest {
    String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;
    public static int cnt = 0;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject(String.valueOf(this.TEST_PROJECT) + "_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        Thread.sleep(2000L);
    }

    @Test
    public void testEntityListener() throws Exception {
        IJPAEditorFeatureProvider featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        Assert.assertNotNull((Object)this.jpaProject);
        IFile customerFile = this.factory.createEntityInProject(this.jpaProject.getProject(), new String[]{"com", "test"}, "Customer");
        this.jpaProject.getProject().build(15, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)customerFile.exists());
        JavaResourceAbstractType customerType = this.jpaProject.getJavaResourceType("com.test.Customer");
        Assert.assertNotNull((Object)customerType);
        JavaPersistentType t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        while (t1 == null) {
            Thread.sleep(200L);
            t1 = JpaArtifactFactory.instance().getContextPersistentType(this.jpaProject, customerType.getQualifiedName());
        }
        ICompilationUnit cu1 = this.createCompilationUnitFrom(customerFile);
        EasyMock.expect((Object)featureProvider.getCompilationUnit(t1)).andStubReturn((Object)cu1);
        EasyMock.replay((Object[])new Object[]{featureProvider});
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    public class EntityAttributesChangeListener
    implements ListChangeListener {
        public void listChanged(ListChangeEvent event) {
        }

        public void itemsAdded(ListAddEvent arg0) {
        }

        public void itemsMoved(ListMoveEvent arg0) {
        }

        public void itemsRemoved(ListRemoveEvent arg0) {
            ++cnt;
        }

        public void itemsReplaced(ListReplaceEvent arg0) {
        }

        public void listCleared(ListClearEvent arg0) {
        }
    }
}

