/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db.internal.vendor;

import java.util.ArrayList;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jpt.db.internal.vendor.AbstractVendor;
import org.eclipse.jpt.db.internal.vendor.CatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FauxCatalogStrategy;
import org.eclipse.jpt.db.internal.vendor.FoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.UpperCaseFoldingStrategy;
import org.eclipse.jpt.db.internal.vendor.Vendor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Derby
extends AbstractVendor {
    private static final Vendor INSTANCE = new Derby();
    private static final String DEFAULT_USER_NAME = "APP";
    private static final char[] EXTENDED_NORMAL_NAME_PART_CHARACTERS = new char[]{'_'};

    static Vendor instance() {
        return INSTANCE;
    }

    private Derby() {
    }

    @Override
    public String getDTPVendorName() {
        return "Derby";
    }

    @Override
    CatalogStrategy getCatalogStrategy() {
        return FauxCatalogStrategy.instance();
    }

    @Override
    FoldingStrategy getFoldingStrategy() {
        return UpperCaseFoldingStrategy.instance();
    }

    @Override
    void addDefaultSchemaIdentifiersTo(Database database, String userName, ArrayList<String> identifiers) {
        identifiers.add(this.buildDefaultSchemaIdentifier(userName));
    }

    private String buildDefaultSchemaIdentifier(String userName) {
        return userName != null && userName.length() != 0 ? userName : DEFAULT_USER_NAME;
    }

    @Override
    char[] getExtendedNormalNamePartCharacters() {
        return EXTENDED_NORMAL_NAME_PART_CHARACTERS;
    }
}

