/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.util.EmptyStackException;
import org.eclipse.jpt.utility.internal.SimpleStack;
import org.eclipse.jpt.utility.internal.Stack;
import org.eclipse.jpt.utility.internal.SynchronizedStack;
import org.eclipse.jpt.utility.tests.internal.SimpleStackTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedStackTests
extends SimpleStackTests {
    private volatile SynchronizedStack<String> ss;
    private volatile boolean exCaught;
    private volatile boolean timeoutOccurred;
    private volatile long startTime;
    private volatile long endTime;
    private volatile Object poppedObject;
    static final String ITEM_1 = new String();
    static final String ITEM_2 = new String();

    public SynchronizedStackTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ss = new SynchronizedStack();
        this.exCaught = false;
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.poppedObject = null;
    }

    public void testConcurrentAccess() throws Exception {
        this.verifyConcurrentAccess(new SlowSimpleStack<String>(), "second");
        this.verifyConcurrentAccess(new SlowSynchronizedStack<String>(), "first");
    }

    private void verifyConcurrentAccess(SlowStack<String> slowStack, String expected) throws Exception {
        slowStack.push("first");
        slowStack.push("second");
        new Thread(this.buildRunnable(slowStack)).start();
        Thread.sleep(200L);
        SynchronizedStackTests.assertEquals((String)expected, (String)((String)slowStack.pop()));
    }

    private Runnable buildRunnable(final SlowStack<String> slowStack) {
        return new Runnable(){

            public void run() {
                slowStack.slowPop();
            }
        };
    }

    public void testWaitToPop() throws Exception {
        this.verifyWaitToPop(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.elapsedTime() > 150L ? 1 : 0) != 0);
    }

    public void testWaitToPopTimeout() throws Exception {
        this.verifyWaitToPop(20L);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertNull((Object)this.poppedObject);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.elapsedTime() < 150L ? 1 : 0) != 0);
    }

    private void verifyWaitToPop(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildPushCommand(), this.ss, 200L);
        Runnable r2 = this.buildRunnable(this.buildWaitToPopCommand(timeout), this.ss, 0L);
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            Thread.sleep(50L);
        }
        SynchronizedStackTests.assertFalse((boolean)this.exCaught);
    }

    public void testWaitToPush() throws Exception {
        this.verifyWaitToPush(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_2, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.elapsedTime() > 150L ? 1 : 0) != 0);
    }

    public void testWaitToPushTimeout() throws Exception {
        this.verifyWaitToPush(20L);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.elapsedTime() < 150L ? 1 : 0) != 0);
    }

    private void verifyWaitToPush(long timeout) throws Exception {
        this.ss.push((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildPopCommand(), this.ss, 200L);
        Runnable r2 = this.buildRunnable(this.buildWaitToPushCommand(timeout), this.ss, 0L);
        Thread t1 = new Thread(r1);
        Thread t2 = new Thread(r2);
        t1.start();
        t2.start();
        while (t1.isAlive() || t2.isAlive()) {
            Thread.sleep(50L);
        }
        SynchronizedStackTests.assertFalse((boolean)this.exCaught);
    }

    private Command buildPushCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) {
                synchronizedStack.push((Object)ITEM_1);
            }
        };
    }

    private Command buildWaitToPopCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws Exception {
                SynchronizedStackTests.this.setStartTime(System.currentTimeMillis());
                try {
                    SynchronizedStackTests.this.setPoppedObject(synchronizedStack.waitToPop(timeout));
                }
                catch (EmptyStackException emptyStackException) {
                    SynchronizedStackTests.this.setTimeoutOccurred(true);
                }
                SynchronizedStackTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Command buildPopCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) {
                SynchronizedStackTests.this.setPoppedObject(synchronizedStack.pop());
            }
        };
    }

    private Command buildWaitToPushCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws Exception {
                SynchronizedStackTests.this.setStartTime(System.currentTimeMillis());
                SynchronizedStackTests.this.setTimeoutOccurred(!synchronizedStack.waitToPush((Object)ITEM_2, timeout));
                SynchronizedStackTests.this.setEndTime(System.currentTimeMillis());
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedStack<String> synchronizedStack, final long sleep) {
        return new Runnable(){

            public void run() {
                try {
                    if (sleep != 0L) {
                        Thread.sleep(sleep);
                    }
                    command.execute((SynchronizedStack<String>)synchronizedStack);
                }
                catch (Exception exception) {
                    SynchronizedStackTests.this.setExCaught(true);
                }
            }
        };
    }

    void setExCaught(boolean exCaught) {
        this.exCaught = exCaught;
    }

    void setTimeoutOccurred(boolean timeoutOccurred) {
        this.timeoutOccurred = timeoutOccurred;
    }

    void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    void setPoppedObject(Object poppedObject) {
        this.poppedObject = poppedObject;
    }

    long elapsedTime() {
        return this.endTime - this.startTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Command {
        public void execute(SynchronizedStack<String> var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlowSimpleStack<E>
    extends SimpleStack<E>
    implements SlowStack<E> {
        SlowSimpleStack() {
        }

        @Override
        public Object slowPop() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface SlowStack<E>
    extends Stack<E> {
        public Object slowPop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SlowSynchronizedStack<E>
    extends SynchronizedStack<E>
    implements SlowStack<E> {
        SlowSynchronizedStack() {
        }

        @Override
        public synchronized Object slowPop() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.pop();
        }
    }
}

