/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Field;
import org.eclipse.jem.internal.proxy.initParser.Message;
import org.eclipse.jem.internal.proxy.initParser.Statement;

public class Block
extends Expression {
    protected boolean fIsClosed = false;
    protected boolean fIsComplete = false;
    protected boolean fMessageOrField = false;

    public Block(Expression anExpression) {
        this.currentExpression = anExpression;
    }

    public Block(ClassLoader fClassLoader) {
        this.currentExpression = new Statement(fClassLoader);
    }

    public Object evaluate() throws Exception {
        return this.currentExpression.evaluate();
    }

    public boolean isComplete() {
        return this.fIsComplete;
    }

    public Class getTypeClass() throws Exception {
        return this.currentExpression.getTypeClass();
    }

    public Expression push(char[] token, char tokenDelimiter) {
        if ((this.fIsClosed || this.currentExpression.isComplete()) && (tokenDelimiter == ')' || tokenDelimiter == ',')) {
            this.fIsComplete = true;
            return this;
        }
        if (this.fMessageOrField) {
            this.fMessageOrField = false;
            if (tokenDelimiter == '(') {
                Message message = new Message(this.currentExpression, token, this.fClassLoader);
                this.currentExpression = message;
                return message;
            }
            Field field = new Field(this.currentExpression, token, this.fClassLoader);
            this.currentExpression = field;
            return field;
        }
        if (this.currentExpression.isComplete() && tokenDelimiter == '.') {
            this.fMessageOrField = true;
            return this;
        }
        Expression result = this.currentExpression.push(token, tokenDelimiter);
        if (result != this.currentExpression) {
            this.pushExpressionStack(result);
        }
        if (this.currentExpression.isComplete() && tokenDelimiter == ')') {
            this.fIsClosed = true;
        }
        return this.currentExpression;
    }

    public boolean isPrimitive() throws Exception {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Block(");
        if (this.currentExpression != null) {
            buffer.append(this.currentExpression.toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String getTypeClassName() {
        return this.currentExpression.getTypeClassName();
    }
}

