/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import org.eclipse.jpt.db.ForeignKey;
import org.eclipse.jpt.gen.internal.GenTable;
import org.eclipse.jpt.utility.internal.StringTools;

class ManyToManyRelation {
    private final GenTable joinGenTable;
    private final ForeignKey owningForeignKey;
    private final GenTable owningGenTable;
    private final ForeignKey nonOwningForeignKey;
    private final GenTable nonOwningGenTable;
    private String mappedBy;

    ManyToManyRelation(GenTable joinGenTable, ForeignKey owningForeignKey, GenTable owningGenTable, ForeignKey nonOwningForeignKey, GenTable nonOwningGenTable) {
        this.joinGenTable = joinGenTable;
        this.owningForeignKey = owningForeignKey;
        this.owningGenTable = owningGenTable;
        owningGenTable.addOwnedManyToManyRelation(this);
        this.nonOwningForeignKey = nonOwningForeignKey;
        this.nonOwningGenTable = nonOwningGenTable;
        nonOwningGenTable.addNonOwnedManyToManyRelation(this);
    }

    GenTable getJoinGenTable() {
        return this.joinGenTable;
    }

    ForeignKey getOwningForeignKey() {
        return this.owningForeignKey;
    }

    GenTable getOwningGenTable() {
        return this.owningGenTable;
    }

    ForeignKey getNonOwningForeignKey() {
        return this.nonOwningForeignKey;
    }

    GenTable getNonOwningGenTable() {
        return this.nonOwningGenTable;
    }

    String getOwnedAttributeName() {
        return this.nonOwningGenTable.getCollectionAttributeName();
    }

    String getNonOwnedAttributeName() {
        return this.owningGenTable.getCollectionAttributeName();
    }

    void clear() {
        this.owningGenTable.removeOwnedManyToManyRelation(this);
        this.nonOwningGenTable.removeNonOwnedManyToManyRelation(this);
    }

    String getMappedBy() {
        return this.mappedBy;
    }

    void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    String getOwningEntityName() {
        return this.owningGenTable.getEntityName();
    }

    String getNonOwningEntityName() {
        return this.nonOwningGenTable.getEntityName();
    }

    boolean joinTableNameIsDefault() {
        return this.joinGenTable.joinTableNameIsDefault();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.joinGenTable);
    }
}

