/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.CustomConverter;
import org.eclipse.jpt.eclipselink.core.context.ObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.context.StructConverter;
import org.eclipse.jpt.eclipselink.core.context.TypeConverter;
import org.eclipse.jpt.eclipselink.core.context.java.JavaConverterHolder;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaObjectTypeConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaStructConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.java.EclipseLinkJavaTypeConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.ConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.StructConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.TypeConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkJavaConverterHolder
extends AbstractJavaJpaContextNode
implements JavaConverterHolder {
    protected JavaResourcePersistentType resourcePersistentType;
    protected EclipseLinkJavaCustomConverter customConverter;
    protected EclipseLinkJavaObjectTypeConverter objectTypeConverter;
    protected EclipseLinkJavaStructConverter structConverter;
    protected EclipseLinkJavaTypeConverter typeConverter;

    public EclipseLinkJavaConverterHolder(JavaTypeMapping parent) {
        super((JpaContextNode)parent);
    }

    @Override
    public CustomConverter getCustomConverter() {
        return this.customConverter;
    }

    @Override
    public CustomConverter addCustomConverter() {
        if (this.customConverter != null) {
            throw new IllegalStateException("custom converter already exists");
        }
        this.customConverter = this.buildCustomConverter();
        this.resourcePersistentType.addSupportingAnnotation(this.customConverter.getAnnotationName());
        this.firePropertyChanged("customConverter", null, this.customConverter);
        return this.customConverter;
    }

    protected void addCustomConverter_() {
        this.customConverter = this.buildCustomConverter();
        this.firePropertyChanged("customConverter", null, this.customConverter);
    }

    @Override
    public void removeCustomConverter() {
        if (this.customConverter == null) {
            throw new IllegalStateException("converter is null");
        }
        EclipseLinkJavaCustomConverter oldConverter = this.customConverter;
        this.customConverter = null;
        this.resourcePersistentType.removeSupportingAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("customConverter", oldConverter, null);
    }

    protected void removeCustomConverter_() {
        this.customConverter = null;
        this.firePropertyChanged("customConverter", this.customConverter, null);
    }

    protected String getConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    protected ConverterAnnotation getResourceConverter() {
        return (ConverterAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getConverterAnnotationName());
    }

    @Override
    public ObjectTypeConverter getObjectTypeConverter() {
        return this.objectTypeConverter;
    }

    @Override
    public ObjectTypeConverter addObjectTypeConverter() {
        if (this.objectTypeConverter != null) {
            throw new IllegalStateException("object type converter already exists");
        }
        this.objectTypeConverter = this.buildObjectTypeConverter();
        this.resourcePersistentType.addSupportingAnnotation(this.objectTypeConverter.getAnnotationName());
        this.firePropertyChanged("objectTypeConverter", null, this.objectTypeConverter);
        return this.objectTypeConverter;
    }

    protected void addObjectTypeConverter_() {
        this.objectTypeConverter = this.buildObjectTypeConverter();
        this.firePropertyChanged("objectTypeConverter", null, this.objectTypeConverter);
    }

    @Override
    public void removeObjectTypeConverter() {
        if (this.objectTypeConverter == null) {
            throw new IllegalStateException("object type converter is null");
        }
        EclipseLinkJavaObjectTypeConverter oldConverter = this.objectTypeConverter;
        this.objectTypeConverter = null;
        this.resourcePersistentType.removeSupportingAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("objectTypeConverter", oldConverter, null);
    }

    protected void removeObjectTypeConverter_() {
        EclipseLinkJavaObjectTypeConverter oldConverter = this.objectTypeConverter;
        this.objectTypeConverter = null;
        this.firePropertyChanged("objectTypeConverter", oldConverter, null);
    }

    protected String getObjectTypeConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    protected ObjectTypeConverterAnnotation getResourceObjectTypeConverter() {
        return (ObjectTypeConverterAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getObjectTypeConverterAnnotationName());
    }

    @Override
    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public TypeConverter addTypeConverter() {
        if (this.typeConverter != null) {
            throw new IllegalStateException("type converter already exists");
        }
        this.typeConverter = this.buildTypeConverter();
        this.resourcePersistentType.addSupportingAnnotation(this.typeConverter.getAnnotationName());
        this.firePropertyChanged("typeConverter", null, this.typeConverter);
        return this.typeConverter;
    }

    protected void addTypeConverter_() {
        this.typeConverter = this.buildTypeConverter();
        this.firePropertyChanged("typeConverter", null, this.typeConverter);
    }

    @Override
    public void removeTypeConverter() {
        if (this.typeConverter == null) {
            throw new IllegalStateException("type converter is null");
        }
        EclipseLinkJavaTypeConverter oldConverter = this.typeConverter;
        this.typeConverter = null;
        this.resourcePersistentType.removeSupportingAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("typeConverter", oldConverter, null);
    }

    protected void removeTypeConverter_() {
        EclipseLinkJavaTypeConverter oldConverter = this.typeConverter;
        this.typeConverter = null;
        this.firePropertyChanged("typeConverter", oldConverter, null);
    }

    protected String getTypeConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.TypeConverter";
    }

    protected TypeConverterAnnotation getResourceTypeConverter() {
        return (TypeConverterAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getTypeConverterAnnotationName());
    }

    @Override
    public StructConverter getStructConverter() {
        return this.structConverter;
    }

    @Override
    public StructConverter addStructConverter() {
        if (this.structConverter != null) {
            throw new IllegalStateException("struct converter already exists");
        }
        this.structConverter = this.buildStructConverter();
        this.resourcePersistentType.addSupportingAnnotation(this.structConverter.getAnnotationName());
        this.firePropertyChanged("structConverter", null, this.structConverter);
        return this.structConverter;
    }

    protected void addStructConverter_() {
        this.structConverter = this.buildStructConverter();
        this.firePropertyChanged("structConverter", null, this.structConverter);
    }

    @Override
    public void removeStructConverter() {
        if (this.structConverter == null) {
            throw new IllegalStateException("struct converter is null");
        }
        EclipseLinkJavaStructConverter oldConverter = this.structConverter;
        this.structConverter = null;
        this.resourcePersistentType.removeSupportingAnnotation(oldConverter.getAnnotationName());
        this.firePropertyChanged("structConverter", oldConverter, null);
    }

    protected void removeStructConverter_() {
        EclipseLinkJavaStructConverter oldConverter = this.structConverter;
        this.structConverter = null;
        this.firePropertyChanged("structConverter", oldConverter, null);
    }

    protected String getStructConverterAnnotationName() {
        return "org.eclipse.persistence.annotations.StructConverter";
    }

    protected StructConverterAnnotation getResourceStructConverter() {
        return (StructConverterAnnotation)this.resourcePersistentType.getSupportingAnnotation(this.getStructConverterAnnotationName());
    }

    @Override
    public void update(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.updateCustomConverter();
        this.updateObjectTypeConverter();
        this.updateTypeConverter();
        this.updateStructConverter();
    }

    protected void updateCustomConverter() {
        if (this.getResourceConverter() != null) {
            if (this.customConverter != null) {
                this.customConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addCustomConverter_();
            }
        } else if (this.customConverter != null) {
            this.removeCustomConverter_();
        }
    }

    protected void updateObjectTypeConverter() {
        if (this.getResourceObjectTypeConverter() != null) {
            if (this.objectTypeConverter != null) {
                this.objectTypeConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addObjectTypeConverter_();
            }
        } else if (this.objectTypeConverter != null) {
            this.removeObjectTypeConverter_();
        }
    }

    protected void updateTypeConverter() {
        if (this.getResourceTypeConverter() != null) {
            if (this.typeConverter != null) {
                this.typeConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addTypeConverter_();
            }
        } else if (this.typeConverter != null) {
            this.removeTypeConverter();
        }
    }

    protected void updateStructConverter() {
        if (this.getResourceStructConverter() != null) {
            if (this.structConverter != null) {
                this.structConverter.update((JavaResourcePersistentMember)this.resourcePersistentType);
            } else {
                this.addStructConverter_();
            }
        } else if (this.structConverter != null) {
            this.removeStructConverter_();
        }
    }

    @Override
    public void initialize(JavaResourcePersistentType jrpt) {
        this.resourcePersistentType = jrpt;
        this.initializeCustomConverter();
        this.initializeObjectTypeConverter();
        this.initializeTypeConverter();
        this.initializeStructConverter();
    }

    protected void initializeCustomConverter() {
        if (this.getResourceConverter() != null) {
            this.customConverter = this.buildCustomConverter();
        }
    }

    protected void initializeObjectTypeConverter() {
        if (this.getResourceObjectTypeConverter() != null) {
            this.objectTypeConverter = this.buildObjectTypeConverter();
        }
    }

    protected void initializeTypeConverter() {
        if (this.getResourceTypeConverter() != null) {
            this.typeConverter = this.buildTypeConverter();
        }
    }

    protected void initializeStructConverter() {
        if (this.getResourceStructConverter() != null) {
            this.structConverter = this.buildStructConverter();
        }
    }

    protected EclipseLinkJavaCustomConverter buildCustomConverter() {
        EclipseLinkJavaCustomConverter contextConverter = new EclipseLinkJavaCustomConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    protected EclipseLinkJavaTypeConverter buildTypeConverter() {
        EclipseLinkJavaTypeConverter contextConverter = new EclipseLinkJavaTypeConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    protected EclipseLinkJavaObjectTypeConverter buildObjectTypeConverter() {
        EclipseLinkJavaObjectTypeConverter contextConverter = new EclipseLinkJavaObjectTypeConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    protected EclipseLinkJavaStructConverter buildStructConverter() {
        EclipseLinkJavaStructConverter contextConverter = new EclipseLinkJavaStructConverter(this);
        contextConverter.initialize((JavaResourcePersistentMember)this.resourcePersistentType);
        return contextConverter;
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourcePersistentType.getTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.customConverter != null) {
            this.customConverter.validate(messages, reporter, astRoot);
        }
        if (this.objectTypeConverter != null) {
            this.objectTypeConverter.validate(messages, reporter, astRoot);
        }
        if (this.typeConverter != null) {
            this.typeConverter.validate(messages, reporter, astRoot);
        }
        if (this.structConverter != null) {
            this.structConverter.validate(messages, reporter, astRoot);
        }
    }
}

