/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.CacheCoordinationType;
import org.eclipse.jpt.eclipselink.core.context.CacheType;
import org.eclipse.jpt.eclipselink.core.context.ExistenceType;
import org.eclipse.jpt.eclipselink.core.context.ExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.context.java.JavaCaching;
import org.eclipse.jpt.eclipselink.core.context.orm.OrmCaching;
import org.eclipse.jpt.eclipselink.core.internal.context.orm.EclipseLinkOrmExpiryTimeOfDay;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCache;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCacheHolder;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlTimeOfDay;

public class EclipseLinkOrmCaching
extends AbstractXmlContextNode
implements OrmCaching {
    protected final XmlCacheHolder resource;
    protected int defaultSize;
    protected Integer specifiedSize;
    protected boolean defaultShared;
    protected Boolean specifiedShared;
    protected CacheType defaultType;
    protected CacheType specifiedType;
    protected boolean defaultAlwaysRefresh;
    protected Boolean specifiedAlwaysRefresh;
    protected boolean defaultRefreshOnlyIfNewer;
    protected Boolean specifiedRefreshOnlyIfNewer;
    protected boolean defaultDisableHits;
    protected Boolean specifiedDisableHits;
    protected CacheCoordinationType defaultCoordinationType;
    protected CacheCoordinationType specifiedCoordinationType;
    protected ExistenceType specifiedExistenceType;
    protected ExistenceType defaultExistenceType;
    protected Integer expiry;
    protected EclipseLinkOrmExpiryTimeOfDay expiryTimeOfDay;

    public EclipseLinkOrmCaching(OrmTypeMapping parent, XmlCacheHolder resource, JavaCaching javaCaching) {
        super((JpaContextNode)parent);
        this.resource = resource;
        XmlCache resourceCache = this.getResourceCache();
        this.defaultSize = this.defaultSize(javaCaching);
        this.specifiedSize = this.getResourceSize(resourceCache);
        this.defaultShared = this.defaultShared(javaCaching);
        this.specifiedShared = this.getResourceShared(resourceCache);
        this.defaultAlwaysRefresh = this.defaultAlwaysRefresh(javaCaching);
        this.specifiedAlwaysRefresh = this.getResourceAlwaysRefresh(resourceCache);
        this.defaultRefreshOnlyIfNewer = this.defaultRefreshOnlyIfNewer(javaCaching);
        this.specifiedRefreshOnlyIfNewer = this.getResourceRefreshOnlyIfNewer(resourceCache);
        this.defaultDisableHits = this.defaultDisableHits(javaCaching);
        this.specifiedDisableHits = this.getResourceDisableHits(resourceCache);
        this.defaultType = this.defaultType(javaCaching);
        this.specifiedType = this.getResourceType(resourceCache);
        this.defaultCoordinationType = this.defaultCoordinationType(javaCaching);
        this.specifiedCoordinationType = this.getResourceCoordinationType(resourceCache);
        this.defaultExistenceType = this.defaultExistenceType(javaCaching);
        this.specifiedExistenceType = this.getResourceExistenceChecking();
        this.initializeExpiry(resourceCache);
    }

    public int getSize() {
        return this.specifiedSize == null ? this.defaultSize : this.specifiedSize;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    protected void setDefaultSize(int newSize) {
        int oldSize = this.defaultSize;
        this.defaultSize = newSize;
        this.firePropertyChanged("defaultSize", oldSize, newSize);
    }

    public Integer getSpecifiedSize() {
        return this.specifiedSize;
    }

    public void setSpecifiedSize(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        if (oldSpecifiedSize != newSpecifiedSize) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setSize(newSpecifiedSize);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedSize != null) {
                this.addResourceCache();
                this.getResourceCache().setSize(newSpecifiedSize);
            }
        }
        this.firePropertyChanged("specifiedSize", oldSpecifiedSize, newSpecifiedSize);
    }

    protected void setSpecifiedSize_(Integer newSpecifiedSize) {
        Integer oldSpecifiedSize = this.specifiedSize;
        this.specifiedSize = newSpecifiedSize;
        this.firePropertyChanged("specifiedSize", oldSpecifiedSize, newSpecifiedSize);
    }

    public boolean isShared() {
        return this.specifiedShared == null ? this.defaultShared : this.specifiedShared;
    }

    public boolean isDefaultShared() {
        return this.defaultShared;
    }

    protected void setDefaultShared(boolean newDefaultShared) {
        boolean oldDefaultShared = this.defaultShared;
        this.defaultShared = newDefaultShared;
        this.firePropertyChanged("defaultShared", oldDefaultShared, newDefaultShared);
    }

    public Boolean getSpecifiedShared() {
        return this.specifiedShared;
    }

    public void setSpecifiedShared(Boolean newSpecifiedShared) {
        Boolean oldSpecifiedShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        if (oldSpecifiedShared != newSpecifiedShared) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setShared(newSpecifiedShared);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedShared != null) {
                this.addResourceCache();
                this.getResourceCache().setShared(newSpecifiedShared);
            }
        }
        this.firePropertyChanged("specifiedShared", oldSpecifiedShared, newSpecifiedShared);
        if (newSpecifiedShared == Boolean.FALSE) {
            this.setSpecifiedType(null);
            this.setSpecifiedSize(null);
            this.setSpecifiedAlwaysRefresh(null);
            this.setSpecifiedRefreshOnlyIfNewer(null);
            this.setSpecifiedDisableHits(null);
            this.setSpecifiedCoordinationType(null);
            this.setExpiry(null);
            if (this.expiryTimeOfDay != null) {
                this.removeExpiryTimeOfDay();
            }
        }
    }

    protected void setSpecifiedShared_(Boolean newSpecifiedShared) {
        Boolean oldSpecifiedShared = this.specifiedShared;
        this.specifiedShared = newSpecifiedShared;
        this.firePropertyChanged("specifiedShared", oldSpecifiedShared, newSpecifiedShared);
    }

    public boolean isAlwaysRefresh() {
        return this.specifiedAlwaysRefresh == null ? this.defaultAlwaysRefresh : this.specifiedAlwaysRefresh;
    }

    public boolean isDefaultAlwaysRefresh() {
        return this.defaultAlwaysRefresh;
    }

    protected void setDefaultAlwaysRefresh(boolean newDefaultAlwaysRefresh) {
        boolean oldDefaultAlwaysRefresh = this.defaultAlwaysRefresh;
        this.defaultAlwaysRefresh = newDefaultAlwaysRefresh;
        this.firePropertyChanged("defaultAlwaysRefresh", oldDefaultAlwaysRefresh, newDefaultAlwaysRefresh);
    }

    public Boolean getSpecifiedAlwaysRefresh() {
        return this.specifiedAlwaysRefresh;
    }

    public void setSpecifiedAlwaysRefresh(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldSpecifiedAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        if (oldSpecifiedAlwaysRefresh != newSpecifiedAlwaysRefresh) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setAlwaysRefresh(newSpecifiedAlwaysRefresh);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedAlwaysRefresh != null) {
                this.addResourceCache();
                this.getResourceCache().setAlwaysRefresh(newSpecifiedAlwaysRefresh);
            }
        }
        this.firePropertyChanged("specifiedAlwaysRefresh", oldSpecifiedAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    protected void setSpecifiedAlwaysRefresh_(Boolean newSpecifiedAlwaysRefresh) {
        Boolean oldSpecifiedAlwaysRefresh = this.specifiedAlwaysRefresh;
        this.specifiedAlwaysRefresh = newSpecifiedAlwaysRefresh;
        this.firePropertyChanged("specifiedAlwaysRefresh", oldSpecifiedAlwaysRefresh, newSpecifiedAlwaysRefresh);
    }

    public boolean isRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer == null ? this.defaultRefreshOnlyIfNewer : this.specifiedRefreshOnlyIfNewer;
    }

    public boolean isDefaultRefreshOnlyIfNewer() {
        return this.defaultRefreshOnlyIfNewer;
    }

    protected void setDefaultRefreshOnlyIfNewer(boolean newDefaultRefreshOnlyIfNewer) {
        boolean oldDefaultRefreshOnlyIfNewer = this.defaultRefreshOnlyIfNewer;
        this.defaultRefreshOnlyIfNewer = newDefaultRefreshOnlyIfNewer;
        this.firePropertyChanged("defaultRefreshOnlyIfNewer", oldDefaultRefreshOnlyIfNewer, newDefaultRefreshOnlyIfNewer);
    }

    public Boolean getSpecifiedRefreshOnlyIfNewer() {
        return this.specifiedRefreshOnlyIfNewer;
    }

    public void setSpecifiedRefreshOnlyIfNewer(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldSpecifiedRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        if (oldSpecifiedRefreshOnlyIfNewer != newSpecifiedRefreshOnlyIfNewer) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setRefreshOnlyIfNewer(newSpecifiedRefreshOnlyIfNewer);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedRefreshOnlyIfNewer != null) {
                this.addResourceCache();
                this.getResourceCache().setRefreshOnlyIfNewer(newSpecifiedRefreshOnlyIfNewer);
            }
        }
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", oldSpecifiedRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    protected void setSpecifiedRefreshOnlyIfNewer_(Boolean newSpecifiedRefreshOnlyIfNewer) {
        Boolean oldSpecifiedRefreshOnlyIfNewer = this.specifiedRefreshOnlyIfNewer;
        this.specifiedRefreshOnlyIfNewer = newSpecifiedRefreshOnlyIfNewer;
        this.firePropertyChanged("specifiedRefreshOnlyIfNewer", oldSpecifiedRefreshOnlyIfNewer, newSpecifiedRefreshOnlyIfNewer);
    }

    public boolean isDisableHits() {
        return this.specifiedDisableHits == null ? this.defaultDisableHits : this.specifiedDisableHits;
    }

    public boolean isDefaultDisableHits() {
        return this.defaultDisableHits;
    }

    protected void setDefaultDisableHits(boolean newDefaultDisableHits) {
        boolean oldDefaultDisableHits = this.defaultDisableHits;
        this.defaultDisableHits = newDefaultDisableHits;
        this.firePropertyChanged("defaultDisableHits", oldDefaultDisableHits, newDefaultDisableHits);
    }

    public Boolean getSpecifiedDisableHits() {
        return this.specifiedDisableHits;
    }

    public void setSpecifiedDisableHits(Boolean newSpecifiedDisableHits) {
        Boolean oldSpecifiedDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        if (oldSpecifiedDisableHits != newSpecifiedDisableHits) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setDisableHits(newSpecifiedDisableHits);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedDisableHits != null) {
                this.addResourceCache();
                this.getResourceCache().setDisableHits(newSpecifiedDisableHits);
            }
        }
        this.firePropertyChanged("specifiedDisableHits", oldSpecifiedDisableHits, newSpecifiedDisableHits);
    }

    protected void setSpecifiedDisableHits_(Boolean newSpecifiedDisableHits) {
        Boolean oldSpecifiedDisableHits = this.specifiedDisableHits;
        this.specifiedDisableHits = newSpecifiedDisableHits;
        this.firePropertyChanged("specifiedDisableHits", oldSpecifiedDisableHits, newSpecifiedDisableHits);
    }

    public CacheType getType() {
        return this.specifiedType == null ? this.defaultType : this.specifiedType;
    }

    public CacheType getDefaultType() {
        return this.defaultType;
    }

    protected void setDefaultType(CacheType newDefaultType) {
        CacheType oldDefaultType = this.defaultType;
        this.defaultType = newDefaultType;
        this.firePropertyChanged("defaultType", (Object)oldDefaultType, (Object)newDefaultType);
    }

    public CacheType getSpecifiedType() {
        return this.specifiedType;
    }

    public void setSpecifiedType(CacheType newSpecifiedType) {
        CacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        if (oldSpecifiedType != newSpecifiedType) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setType(CacheType.toOrmResourceModel(newSpecifiedType));
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedType != null) {
                this.addResourceCache();
                this.getResourceCache().setType(CacheType.toOrmResourceModel(newSpecifiedType));
            }
        }
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    protected void setSpecifiedType_(CacheType newSpecifiedType) {
        CacheType oldSpecifiedType = this.specifiedType;
        this.specifiedType = newSpecifiedType;
        this.firePropertyChanged("specifiedType", (Object)oldSpecifiedType, (Object)newSpecifiedType);
    }

    public CacheCoordinationType getCoordinationType() {
        return this.specifiedCoordinationType == null ? this.defaultCoordinationType : this.specifiedCoordinationType;
    }

    public CacheCoordinationType getDefaultCoordinationType() {
        return this.defaultCoordinationType;
    }

    protected void setDefaultCoordinationType(CacheCoordinationType newDefaultcCoordinationType) {
        CacheCoordinationType oldDefaultcCoordinationType = this.defaultCoordinationType;
        this.defaultCoordinationType = newDefaultcCoordinationType;
        this.firePropertyChanged("defaultCoordinationType", (Object)oldDefaultcCoordinationType, (Object)newDefaultcCoordinationType);
    }

    public CacheCoordinationType getSpecifiedCoordinationType() {
        return this.specifiedCoordinationType;
    }

    public void setSpecifiedCoordinationType(CacheCoordinationType newSpecifiedCoordinationType) {
        CacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        if (oldSpecifiedCoordinationType != newSpecifiedCoordinationType) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setCoordinationType(CacheCoordinationType.toOrmResourceModel(newSpecifiedCoordinationType));
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newSpecifiedCoordinationType != null) {
                this.addResourceCache();
                this.getResourceCache().setCoordinationType(CacheCoordinationType.toOrmResourceModel(newSpecifiedCoordinationType));
            }
        }
        this.firePropertyChanged("specifiedCoordinationType", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    protected void setSpecifiedCoordinationType_(CacheCoordinationType newSpecifiedCoordinationType) {
        CacheCoordinationType oldSpecifiedCoordinationType = this.specifiedCoordinationType;
        this.specifiedCoordinationType = newSpecifiedCoordinationType;
        this.firePropertyChanged("specifiedCoordinationType", (Object)oldSpecifiedCoordinationType, (Object)newSpecifiedCoordinationType);
    }

    public ExistenceType getExistenceType() {
        return this.specifiedExistenceType == null ? this.defaultExistenceType : this.specifiedExistenceType;
    }

    public ExistenceType getDefaultExistenceType() {
        return this.defaultExistenceType;
    }

    protected void setDefaultExistenceType(ExistenceType newDefaultExistenceType) {
        ExistenceType oldDefaultExistenceType = this.defaultExistenceType;
        this.defaultExistenceType = newDefaultExistenceType;
        this.firePropertyChanged("defaultExistenceType", (Object)oldDefaultExistenceType, (Object)newDefaultExistenceType);
    }

    public ExistenceType getSpecifiedExistenceType() {
        return this.specifiedExistenceType;
    }

    public void setSpecifiedExistenceType(ExistenceType newSpecifiedExistenceType) {
        ExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.resource.setExistenceChecking(ExistenceType.toOrmResourceModel(newSpecifiedExistenceType));
        this.firePropertyChanged("specifiedExistenceType", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    protected void setSpecifiedExistenceType_(ExistenceType newSpecifiedExistenceType) {
        ExistenceType oldSpecifiedExistenceType = this.specifiedExistenceType;
        this.specifiedExistenceType = newSpecifiedExistenceType;
        this.firePropertyChanged("specifiedExistenceType", (Object)oldSpecifiedExistenceType, (Object)newSpecifiedExistenceType);
    }

    public Integer getExpiry() {
        return this.expiry;
    }

    public void setExpiry(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        if (oldExpiry != newExpiry) {
            if (this.getResourceCache() != null) {
                this.getResourceCache().setExpiry(newExpiry);
                if (this.getResourceCache().isUnset()) {
                    this.removeResourceCache();
                }
            } else if (newExpiry != null) {
                this.addResourceCache();
                this.getResourceCache().setExpiry(newExpiry);
            }
        }
        this.firePropertyChanged("expiry", oldExpiry, newExpiry);
        if (newExpiry != null && this.expiryTimeOfDay != null) {
            this.removeExpiryTimeOfDay();
        }
    }

    protected void setExpiry_(Integer newExpiry) {
        Integer oldExpiry = this.expiry;
        this.expiry = newExpiry;
        this.firePropertyChanged("expiry", oldExpiry, newExpiry);
    }

    public ExpiryTimeOfDay getExpiryTimeOfDay() {
        return this.expiryTimeOfDay;
    }

    public ExpiryTimeOfDay addExpiryTimeOfDay() {
        EclipseLinkOrmExpiryTimeOfDay newExpiryTimeOfDay;
        if (this.expiryTimeOfDay != null) {
            throw new IllegalStateException("expiryTimeOfDay already exists, use getExpiryTimeOfDay()");
        }
        if (this.getResourceCache() == null) {
            this.addResourceCache();
        }
        this.expiryTimeOfDay = newExpiryTimeOfDay = new EclipseLinkOrmExpiryTimeOfDay(this);
        XmlTimeOfDay resourceTimeOfDay = EclipseLinkOrmFactory.eINSTANCE.createXmlTimeOfDay();
        newExpiryTimeOfDay.initialize(resourceTimeOfDay);
        this.getResourceCache().setExpiryTimeOfDay(resourceTimeOfDay);
        this.firePropertyChanged("expiryTimeOfDay", null, newExpiryTimeOfDay);
        this.setExpiry(null);
        return newExpiryTimeOfDay;
    }

    public void removeExpiryTimeOfDay() {
        if (this.expiryTimeOfDay == null) {
            throw new IllegalStateException("timeOfDayExpiry does not exist");
        }
        EclipseLinkOrmExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = null;
        this.getResourceCache().setExpiryTimeOfDay(null);
        if (this.getResourceCache().isUnset()) {
            this.removeResourceCache();
        }
        this.firePropertyChanged("expiryTimeOfDay", oldExpiryTimeOfDay, null);
    }

    protected void setExpiryTimeOfDay(EclipseLinkOrmExpiryTimeOfDay newExpiryTimeOfDay) {
        EclipseLinkOrmExpiryTimeOfDay oldExpiryTimeOfDay = this.expiryTimeOfDay;
        this.expiryTimeOfDay = newExpiryTimeOfDay;
        this.firePropertyChanged("expiryTimeOfDay", oldExpiryTimeOfDay, newExpiryTimeOfDay);
    }

    protected XmlCache getResourceCache() {
        return this.resource.getCache();
    }

    protected void addResourceCache() {
        this.resource.setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
    }

    protected void removeResourceCache() {
        this.resource.setCache(null);
    }

    protected void initializeExpiry(XmlCache resourceCache) {
        if (resourceCache == null) {
            return;
        }
        if (resourceCache.getExpiryTimeOfDay() == null) {
            this.expiry = resourceCache.getExpiry();
        } else if (resourceCache.getExpiry() == null) {
            this.expiryTimeOfDay = new EclipseLinkOrmExpiryTimeOfDay(this);
            this.expiryTimeOfDay.initialize(resourceCache.getExpiryTimeOfDay());
        }
    }

    protected void update(JavaCaching javaCaching) {
        XmlCache resourceCache = this.getResourceCache();
        this.setDefaultSize(this.defaultSize(javaCaching));
        this.setSpecifiedSize_(this.getResourceSize(resourceCache));
        this.setDefaultShared(this.defaultShared(javaCaching));
        this.setSpecifiedShared_(this.getResourceShared(resourceCache));
        this.setDefaultAlwaysRefresh(this.defaultAlwaysRefresh(javaCaching));
        this.setSpecifiedAlwaysRefresh_(this.getResourceAlwaysRefresh(resourceCache));
        this.setDefaultRefreshOnlyIfNewer(this.defaultRefreshOnlyIfNewer(javaCaching));
        this.setSpecifiedRefreshOnlyIfNewer_(this.getResourceRefreshOnlyIfNewer(resourceCache));
        this.setDefaultDisableHits(this.defaultDisableHits(javaCaching));
        this.setSpecifiedDisableHits_(this.getResourceDisableHits(resourceCache));
        this.setDefaultType(this.defaultType(javaCaching));
        this.setSpecifiedType_(this.getResourceType(resourceCache));
        this.setDefaultCoordinationType(this.defaultCoordinationType(javaCaching));
        this.setSpecifiedCoordinationType_(this.getResourceCoordinationType(resourceCache));
        this.setDefaultExistenceType(this.defaultExistenceType(javaCaching));
        this.setSpecifiedExistenceType_(this.getResourceExistenceChecking());
        this.updateExpiry(resourceCache);
    }

    protected void updateExpiry(XmlCache resourceCache) {
        if (resourceCache == null) {
            this.setExpiryTimeOfDay(null);
            this.setExpiry_(null);
            return;
        }
        if (resourceCache.getExpiryTimeOfDay() == null) {
            this.setExpiryTimeOfDay(null);
            this.setExpiry_(resourceCache.getExpiry());
        } else if (this.expiryTimeOfDay != null) {
            this.expiryTimeOfDay.update(resourceCache.getExpiryTimeOfDay());
        } else if (resourceCache.getExpiry() == null) {
            this.setExpiryTimeOfDay(new EclipseLinkOrmExpiryTimeOfDay(this));
            this.expiryTimeOfDay.initialize(resourceCache.getExpiryTimeOfDay());
        } else {
            this.setExpiryTimeOfDay(null);
        }
    }

    protected int defaultSize(JavaCaching javaCaching) {
        return javaCaching == null ? 100 : javaCaching.getSize();
    }

    protected Integer getResourceSize(XmlCache resource) {
        return resource == null ? null : resource.getSize();
    }

    protected boolean defaultShared(JavaCaching javaCaching) {
        if (javaCaching == null) {
            return true;
        }
        return this.getResourceCache() == null ? javaCaching.isShared() : true;
    }

    protected Boolean getResourceShared(XmlCache resource) {
        return resource == null ? null : resource.getShared();
    }

    protected boolean defaultAlwaysRefresh(JavaCaching javaCaching) {
        if (javaCaching == null) {
            return false;
        }
        return this.getResourceCache() == null ? javaCaching.isAlwaysRefresh() : false;
    }

    protected Boolean getResourceAlwaysRefresh(XmlCache resource) {
        return resource == null ? null : resource.getAlwaysRefresh();
    }

    protected boolean defaultRefreshOnlyIfNewer(JavaCaching javaCaching) {
        if (javaCaching == null) {
            return false;
        }
        return this.getResourceCache() == null ? javaCaching.isRefreshOnlyIfNewer() : false;
    }

    protected Boolean getResourceRefreshOnlyIfNewer(XmlCache resource) {
        return resource == null ? null : resource.getRefreshOnlyIfNewer();
    }

    protected boolean defaultDisableHits(JavaCaching javaCaching) {
        if (javaCaching == null) {
            return false;
        }
        return this.getResourceCache() == null ? javaCaching.isDisableHits() : false;
    }

    protected Boolean getResourceDisableHits(XmlCache resource) {
        return resource == null ? null : resource.getDisableHits();
    }

    protected CacheType defaultType(JavaCaching javaCaching) {
        if (javaCaching == null) {
            return DEFAULT_TYPE;
        }
        return this.getResourceCache() == null ? javaCaching.getType() : DEFAULT_TYPE;
    }

    protected CacheType getResourceType(XmlCache resource) {
        return resource == null ? null : CacheType.fromOrmResourceModel(resource.getType());
    }

    protected CacheCoordinationType defaultCoordinationType(JavaCaching javaCaching) {
        if (javaCaching == null) {
            return DEFAULT_COORDINATION_TYPE;
        }
        return this.getResourceCache() == null ? javaCaching.getCoordinationType() : DEFAULT_COORDINATION_TYPE;
    }

    protected CacheCoordinationType getResourceCoordinationType(XmlCache resource) {
        return resource == null ? null : CacheCoordinationType.fromOrmResourceModel(resource.getCoordinationType());
    }

    protected ExistenceType defaultExistenceType(JavaCaching javaCaching) {
        return javaCaching == null ? DEFAULT_EXISTENCE_TYPE : javaCaching.getExistenceType();
    }

    protected ExistenceType getResourceExistenceChecking() {
        return this.resource == null ? null : ExistenceType.fromOrmResourceModel(this.resource.getExistenceChecking());
    }

    protected Integer getResourceExpiry(XmlCache resource) {
        return resource == null ? null : resource.getExpiry();
    }

    public TextRange getValidationTextRange() {
        XmlCache resource = this.getResourceCache();
        return resource == null ? null : resource.getValidationTextRange();
    }
}

