/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.Mutable;
import org.eclipse.jpt.eclipselink.core.internal.context.java.AbstractEclipseLinkJavaPersistentAttribute;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlMutable;

public class EclipseLinkOrmMutable
extends AbstractXmlContextNode
implements Mutable {
    protected final XmlMutable resource;
    protected boolean defaultMutable;
    protected Boolean specifiedMutable;

    public EclipseLinkOrmMutable(OrmAttributeMapping parent, XmlMutable resource) {
        super((JpaContextNode)parent);
        this.resource = resource;
        this.defaultMutable = this.calculateDefaultMutable();
        this.specifiedMutable = this.getResourceMutable();
    }

    public EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    protected OrmAttributeMapping getAttributeMapping() {
        return (OrmAttributeMapping)this.getParent();
    }

    public boolean isMutable() {
        return this.specifiedMutable != null ? this.specifiedMutable : this.defaultMutable;
    }

    public boolean isDefaultMutable() {
        return this.defaultMutable;
    }

    protected void setDefaultMutable(boolean newDefaultMutable) {
        boolean oldDefaultMutable = this.defaultMutable;
        this.defaultMutable = newDefaultMutable;
        this.firePropertyChanged("defaultMutable", oldDefaultMutable, newDefaultMutable);
    }

    public Boolean getSpecifiedMutable() {
        return this.specifiedMutable;
    }

    public void setSpecifiedMutable(Boolean newSpecifiedMutable) {
        Boolean oldSpecifiedMutable = this.specifiedMutable;
        this.specifiedMutable = newSpecifiedMutable;
        this.resource.setMutable(newSpecifiedMutable);
        this.firePropertyChanged("specifiedMutable", oldSpecifiedMutable, newSpecifiedMutable);
    }

    protected void setSpecifiedMutable_(Boolean newSpecifiedMutable) {
        Boolean oldSpecifiedMutable = this.specifiedMutable;
        this.specifiedMutable = newSpecifiedMutable;
        this.firePropertyChanged("specifiedMutable", oldSpecifiedMutable, newSpecifiedMutable);
    }

    protected void update() {
        this.setDefaultMutable(this.calculateDefaultMutable());
        this.setSpecifiedMutable_(this.getResourceMutable());
    }

    protected Boolean getResourceMutable() {
        return this.resource.getMutable();
    }

    protected boolean calculateDefaultMutable() {
        AbstractEclipseLinkJavaPersistentAttribute javaAttribute = (AbstractEclipseLinkJavaPersistentAttribute)this.getAttributeMapping().getPersistentAttribute().getJavaPersistentAttribute();
        if (javaAttribute == null) {
            return false;
        }
        if (javaAttribute.typeIsDateOrCalendar()) {
            Boolean persistenceUnitDefaultMutable = this.getPersistenceUnit().getOptions().getTemporalMutable();
            return persistenceUnitDefaultMutable == null ? false : persistenceUnitDefaultMutable;
        }
        return javaAttribute.typeIsSerializable();
    }

    public TextRange getValidationTextRange() {
        return this.resource.getMutableTextRange();
    }
}

