/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.ImpliedMappingFileRef;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.EclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.Connection;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.connection.EclipseLinkConnection;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.EclipseLinkCustomization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.EclipseLinkGeneralProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.GeneralProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.EclipseLinkLogging;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging.Logging;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.EclipseLinkOptions;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.options.Options;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.SchemaGeneration;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnit
extends AbstractPersistenceUnit {
    protected MappingFileRef impliedEclipseLinkMappingFileRef;
    private GeneralProperties generalProperties;
    private Connection connection;
    private Customization customization;
    private Caching caching;
    private Logging logging;
    private Options options;
    private SchemaGeneration schemaGeneration;
    protected final List<EclipseLinkConverter> converters = new ArrayList<EclipseLinkConverter>();
    public static final String IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY = "impliedEclipseLinkMappingFileRef";
    public static final String CONVERTERS_LIST = "converters";

    public EclipseLinkPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent, xmlPersistenceUnit);
    }

    protected void initializeProperties() {
        super.initializeProperties();
        this.generalProperties = new EclipseLinkGeneralProperties((PersistenceUnit)this);
        this.connection = new EclipseLinkConnection((PersistenceUnit)this);
        this.customization = new EclipseLinkCustomization((PersistenceUnit)this);
        this.caching = new EclipseLinkCaching((PersistenceUnit)this);
        this.logging = new EclipseLinkLogging((PersistenceUnit)this);
        this.options = new EclipseLinkOptions((PersistenceUnit)this);
        this.schemaGeneration = new EclipseLinkSchemaGeneration((PersistenceUnit)this);
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add(CONVERTERS_LIST);
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        super.propertyValueChanged(propertyName, newValue);
        this.generalProperties.propertyValueChanged(propertyName, newValue);
        this.connection.propertyValueChanged(propertyName, newValue);
        this.customization.propertyValueChanged(propertyName, newValue);
        this.caching.propertyValueChanged(propertyName, newValue);
        this.logging.propertyValueChanged(propertyName, newValue);
        this.options.propertyValueChanged(propertyName, newValue);
        this.schemaGeneration.propertyValueChanged(propertyName, newValue);
    }

    public void propertyRemoved(String propertyName) {
        super.propertyRemoved(propertyName);
        this.generalProperties.propertyRemoved(propertyName);
        this.connection.propertyRemoved(propertyName);
        this.customization.propertyRemoved(propertyName);
        this.caching.propertyRemoved(propertyName);
        this.logging.propertyRemoved(propertyName);
        this.options.propertyRemoved(propertyName);
        this.schemaGeneration.propertyRemoved(propertyName);
    }

    public ListIterator<MappingFileRef> mappingFileRefs() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            return super.mappingFileRefs();
        }
        return new ReadOnlyCompositeListIterator(super.mappingFileRefs(), (Object)this.impliedEclipseLinkMappingFileRef);
    }

    public int mappingFileRefsSize() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            return super.mappingFileRefsSize();
        }
        return 1 + super.mappingFileRefsSize();
    }

    public MappingFileRef getImpliedEclipseLinkMappingFileRef() {
        return this.impliedEclipseLinkMappingFileRef;
    }

    protected MappingFileRef setImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef != null) {
            throw new IllegalStateException("The implied eclipselink mapping file ref is already set.");
        }
        ImpliedMappingFileRef mappingFileRef = this.buildEclipseLinkImpliedMappingFileRef();
        this.impliedEclipseLinkMappingFileRef = mappingFileRef;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, null, mappingFileRef);
        return mappingFileRef;
    }

    protected void unsetImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            throw new IllegalStateException("The implied eclipselink mapping file ref is already unset.");
        }
        MappingFileRef mappingFileRef = this.impliedEclipseLinkMappingFileRef;
        this.impliedEclipseLinkMappingFileRef.dispose();
        this.impliedEclipseLinkMappingFileRef = null;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, mappingFileRef, null);
    }

    public GeneralProperties getGeneralProperties() {
        return this.generalProperties;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Options getOptions() {
        return this.options;
    }

    public SchemaGeneration getSchemaGeneration() {
        return this.schemaGeneration;
    }

    public void addConverter(EclipseLinkConverter converter) {
        this.converters.add(converter);
    }

    public ListIterator<EclipseLinkConverter> allConverters() {
        return new CloneListIterator(this.converters);
    }

    public int convertersSize() {
        return this.converters.size();
    }

    public String[] uniqueConverterNames() {
        HashSet names = CollectionTools.set(this.allNonNullConverterNames());
        return names.toArray(new String[names.size()]);
    }

    protected Iterator<String> allNonNullConverterNames() {
        return new FilteringIterator<String, String>(this.allConverterNames()){

            protected boolean accept(String converterName) {
                return converterName != null;
            }
        };
    }

    protected Iterator<String> allConverterNames() {
        return new TransformationIterator<EclipseLinkConverter, String>(this.allConverters()){

            protected String transform(EclipseLinkConverter converter) {
                return converter.getName();
            }
        };
    }

    public void update(XmlPersistenceUnit persistenceUnit) {
        this.converters.clear();
        super.update(persistenceUnit);
        this.convertersUpdated();
    }

    public void postUpdate() {
        super.postUpdate();
        if (this.impliedEclipseLinkMappingFileRef != null) {
            this.impliedEclipseLinkMappingFileRef.postUpdate();
        }
    }

    protected void initializeMappingFileRefs() {
        super.initializeMappingFileRefs();
        if (!this.impliedEclipseLinkMappingFileIsExcluded() && !this.impliedEclipseLinkMappingFileIsSpecified() && this.impliedEclipseLinkMappingFileExists()) {
            this.impliedEclipseLinkMappingFileRef = this.buildEclipseLinkImpliedMappingFileRef();
        }
    }

    private ImpliedMappingFileRef buildEclipseLinkImpliedMappingFileRef() {
        return new ImpliedMappingFileRef((PersistenceUnit)this, "META-INF/eclipselink-orm.xml");
    }

    protected void updateMappingFileRefs() {
        super.updateMappingFileRefs();
        if (!this.impliedEclipseLinkMappingFileIsExcluded() && !this.impliedEclipseLinkMappingFileIsSpecified() && this.impliedEclipseLinkMappingFileExists()) {
            if (this.impliedEclipseLinkMappingFileRef == null) {
                this.setImpliedEclipseLinkMappingFileRef();
            }
            this.getImpliedEclipseLinkMappingFileRef().update(null);
        } else if (this.impliedEclipseLinkMappingFileRef != null) {
            this.unsetImpliedEclipseLinkMappingFileRef();
        }
    }

    protected boolean impliedEclipseLinkMappingFileIsExcluded() {
        return this.getGeneralProperties().getExcludeEclipselinkOrm() == Boolean.TRUE;
    }

    protected boolean impliedEclipseLinkMappingFileIsSpecified() {
        String impliedMappingFile = "META-INF/eclipselink-orm.xml";
        ListIterator stream = this.specifiedMappingFileRefs();
        while (stream.hasNext()) {
            if (!impliedMappingFile.equals(((MappingFileRef)stream.next()).getFileName())) continue;
            return true;
        }
        return false;
    }

    public EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    protected boolean impliedEclipseLinkMappingFileExists() {
        return this.getJpaProject().getDefaultEclipseLinkOrmXmlResource() != null;
    }

    protected void convertersUpdated() {
        this.fireListChanged(CONVERTERS_LIST);
    }
}

