/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching;

import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.CacheType;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.FlushClearCache;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkCaching
extends EclipseLinkPersistenceUnitProperties
implements Caching {
    private CacheType cacheTypeDefault;
    private Integer cacheSizeDefault;
    private Boolean sharedCacheDefault;
    private FlushClearCache flushClearCache;
    private Map<String, CacheProperties> entitiesCacheProperties;

    public EclipseLinkCaching(PersistenceUnit parent) {
        super(parent);
    }

    @Override
    protected void initializeProperties() {
        this.entitiesCacheProperties = new HashMap<String, CacheProperties>();
        this.cacheTypeDefault = (CacheType)this.getEnumValue("eclipselink.cache.type.default", CacheType.values());
        this.cacheSizeDefault = this.getIntegerValue("eclipselink.cache.size.default");
        this.sharedCacheDefault = this.getBooleanValue("eclipselink.cache.shared.default");
        this.flushClearCache = (FlushClearCache)this.getEnumValue("eclipselink.flush-clear.cache", FlushClearCache.values());
        Set<PersistenceUnit.Property> cacheTypeProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.type.");
        Set<PersistenceUnit.Property> cacheSizeProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.size.");
        Set<PersistenceUnit.Property> sharedCacheProperties = this.getPropertiesSetWithPrefix("eclipselink.cache.shared.");
        this.initializeEntitiesCacheType(cacheTypeProperties);
        this.initializeEntitiesCacheSize(cacheSizeProperties);
        this.initializeEntitiesSharedCache(sharedCacheProperties);
    }

    private void initializeEntitiesCacheType(Set<PersistenceUnit.Property> properties) {
        for (PersistenceUnit.Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setCacheType_(property.getValue(), entityName);
        }
    }

    private void initializeEntitiesCacheSize(Set<PersistenceUnit.Property> properties) {
        for (PersistenceUnit.Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setCacheSize_(property.getValue(), entityName);
        }
    }

    private void initializeEntitiesSharedCache(Set<PersistenceUnit.Property> properties) {
        for (PersistenceUnit.Property property : properties) {
            String entityName = this.getEntityName(property);
            this.setSharedCache_(property.getValue(), entityName);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.cache.type.default")) {
            this.cacheTypeDefaultChanged(newValue);
        } else if (propertyName.equals("eclipselink.cache.size.default")) {
            this.cacheSizeDefaultChanged(newValue);
        } else if (propertyName.equals("eclipselink.cache.shared.default")) {
            this.sharedCacheDefaultChanged(newValue);
        } else if (propertyName.startsWith("eclipselink.cache.type.")) {
            this.cacheTypeChanged(propertyName, newValue);
        } else if (propertyName.startsWith("eclipselink.cache.size.")) {
            this.cacheSizeChanged(propertyName, newValue);
        } else if (propertyName.startsWith("eclipselink.cache.shared.")) {
            this.sharedCacheChanged(propertyName, newValue);
        } else if (propertyName.equals("eclipselink.flush-clear.cache")) {
            this.flushClearCacheChanged(newValue);
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.cache.type.default")) {
            this.cacheTypeDefaultChanged(null);
        } else if (propertyName.equals("eclipselink.cache.size.default")) {
            this.cacheSizeDefaultChanged(null);
        } else if (propertyName.equals("eclipselink.cache.shared.default")) {
            this.sharedCacheDefaultChanged(null);
        } else if (propertyName.startsWith("eclipselink.cache.type.")) {
            this.cacheTypeChanged(propertyName, null);
        } else if (propertyName.startsWith("eclipselink.cache.size.")) {
            this.cacheSizeChanged(propertyName, null);
        } else if (propertyName.startsWith("eclipselink.cache.shared.")) {
            this.sharedCacheChanged(propertyName, null);
        } else if (propertyName.equals("eclipselink.flush-clear.cache")) {
            this.flushClearCacheChanged(null);
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.cache.type.default", "cacheTypeDefault");
        propertyNames.put("eclipselink.cache.size.default", "cacheSizeDefault");
        propertyNames.put("eclipselink.cache.shared.default", "sharedCacheDefault");
        propertyNames.put("eclipselink.flush-clear.cache", "flushClearCache");
    }

    @Override
    public boolean itemIsProperty(PersistenceUnit.Property item) {
        boolean isProperty = super.itemIsProperty(item);
        if (!isProperty && item.getName() != null && (item.getName().startsWith("eclipselink.cache.type.") || item.getName().startsWith("eclipselink.cache.size.") || item.getName().startsWith("eclipselink.cache.shared."))) {
            return true;
        }
        return isProperty;
    }

    @Override
    public String propertyIdFor(PersistenceUnit.Property property) {
        try {
            return super.propertyIdFor(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (property.getName().startsWith("eclipselink.cache.type.")) {
                return "cacheType";
            }
            if (property.getName().startsWith("eclipselink.cache.size.")) {
                return "cacheSize";
            }
            if (property.getName().startsWith("eclipselink.cache.shared.")) {
                return "sharedCache";
            }
            throw new IllegalArgumentException("Illegal property: " + property.toString());
        }
    }

    @Override
    public CacheType getCacheType(String entityName) {
        CacheProperties cache = this.cachePropertiesOf(entityName);
        return cache == null ? null : cache.getType();
    }

    @Override
    public void setCacheType(CacheType newCacheType, String entityName) {
        CacheProperties old = this.setCacheType_(newCacheType, entityName);
        this.putEnumValue("eclipselink.cache.type.", entityName, newCacheType, false);
        this.firePropertyChanged("cacheType", old, this.cachePropertiesOf(entityName));
    }

    private void cacheTypeChanged(String propertyName, String stringValue) {
        String entityName = this.getEntityName(propertyName);
        CacheProperties old = this.setCacheType_(stringValue, entityName);
        this.firePropertyChanged("cacheType", old, this.cachePropertiesOf(entityName));
    }

    @Override
    public CacheType getDefaultCacheType() {
        return this.cacheTypeDefault == null ? DEFAULT_CACHE_TYPE : this.cacheTypeDefault;
    }

    @Override
    public Integer getCacheSize(String entityName) {
        CacheProperties cache = this.cachePropertiesOf(entityName);
        return cache == null ? null : cache.getSize();
    }

    @Override
    public void setCacheSize(Integer newCacheSize, String entityName) {
        CacheProperties old = this.setCacheSize_(newCacheSize, entityName);
        this.putIntegerValue("eclipselink.cache.size." + entityName, newCacheSize);
        this.firePropertyChanged("cacheSize", old, this.cachePropertiesOf(entityName));
    }

    private void cacheSizeChanged(String propertyName, String stringValue) {
        String entityName = this.getEntityName(propertyName);
        CacheProperties old = this.setCacheSize_(stringValue, entityName);
        this.firePropertyChanged("cacheSize", old, this.cachePropertiesOf(entityName));
    }

    @Override
    public Integer getDefaultCacheSize() {
        return this.cacheSizeDefault == null ? DEFAULT_CACHE_SIZE : this.cacheSizeDefault;
    }

    @Override
    public Boolean getSharedCache(String entityName) {
        CacheProperties cache = this.cachePropertiesOf(entityName);
        return cache == null ? null : cache.isShared();
    }

    @Override
    public void setSharedCache(Boolean newSharedCache, String entityName) {
        CacheProperties old = this.setSharedCache_(newSharedCache, entityName);
        this.putBooleanValue("eclipselink.cache.shared.", entityName, newSharedCache, false);
        this.firePropertyChanged("sharedCache", old, this.cachePropertiesOf(entityName));
    }

    private void sharedCacheChanged(String propertyName, String stringValue) {
        String entityName = this.getEntityName(propertyName);
        CacheProperties old = this.setSharedCache_(stringValue, entityName);
        this.firePropertyChanged("sharedCache", old, this.cachePropertiesOf(entityName));
    }

    @Override
    public Boolean getDefaultSharedCache() {
        return this.sharedCacheDefault == null ? DEFAULT_SHARED_CACHE : this.sharedCacheDefault;
    }

    @Override
    public CacheType getCacheTypeDefault() {
        return this.cacheTypeDefault;
    }

    @Override
    public void setCacheTypeDefault(CacheType newCacheTypeDefault) {
        CacheType old = this.cacheTypeDefault;
        this.cacheTypeDefault = newCacheTypeDefault;
        this.putProperty("cacheTypeDefault", (Object)newCacheTypeDefault);
        this.firePropertyChanged("cacheTypeDefault", (Object)old, (Object)newCacheTypeDefault);
    }

    private void cacheTypeDefaultChanged(String stringValue) {
        CacheType newValue = (CacheType)EclipseLinkCaching.getEnumValueOf((String)stringValue, (Enum[])CacheType.values());
        CacheType old = this.cacheTypeDefault;
        this.cacheTypeDefault = newValue;
        this.firePropertyChanged("cacheTypeDefault", (Object)old, (Object)newValue);
    }

    @Override
    public CacheType getDefaultCacheTypeDefault() {
        return DEFAULT_CACHE_TYPE_DEFAULT;
    }

    @Override
    public Integer getCacheSizeDefault() {
        return this.cacheSizeDefault;
    }

    @Override
    public void setCacheSizeDefault(Integer newCacheSizeDefault) {
        Integer old = this.cacheSizeDefault;
        this.cacheSizeDefault = newCacheSizeDefault;
        this.putProperty("cacheSizeDefault", newCacheSizeDefault);
        this.firePropertyChanged("cacheSizeDefault", old, newCacheSizeDefault);
    }

    private void cacheSizeDefaultChanged(String stringValue) {
        Integer newValue = EclipseLinkCaching.getIntegerValueOf(stringValue);
        Integer old = this.cacheSizeDefault;
        this.cacheSizeDefault = newValue;
        this.firePropertyChanged("cacheSizeDefault", old, newValue);
    }

    @Override
    public Integer getDefaultCacheSizeDefault() {
        return DEFAULT_CACHE_SIZE_DEFAULT;
    }

    @Override
    public Boolean getSharedCacheDefault() {
        return this.sharedCacheDefault;
    }

    @Override
    public void setSharedCacheDefault(Boolean newSharedCacheDefault) {
        Boolean old = this.sharedCacheDefault;
        this.sharedCacheDefault = newSharedCacheDefault;
        this.putProperty("sharedCacheDefault", newSharedCacheDefault);
        this.firePropertyChanged("sharedCacheDefault", old, newSharedCacheDefault);
    }

    private void sharedCacheDefaultChanged(String stringValue) {
        Boolean newValue = EclipseLinkCaching.getBooleanValueOf(stringValue);
        Boolean old = this.sharedCacheDefault;
        this.sharedCacheDefault = newValue;
        this.firePropertyChanged("sharedCacheDefault", old, newValue);
    }

    @Override
    public Boolean getDefaultSharedCacheDefault() {
        return DEFAULT_SHARED_CACHE_DEFAULT;
    }

    @Override
    public FlushClearCache getFlushClearCache() {
        return this.flushClearCache;
    }

    @Override
    public void setFlushClearCache(FlushClearCache newFlushClearCache) {
        FlushClearCache old = this.flushClearCache;
        this.flushClearCache = newFlushClearCache;
        this.putProperty("flushClearCache", (Object)newFlushClearCache);
        this.firePropertyChanged("flushClearCache", (Object)old, (Object)newFlushClearCache);
    }

    private void flushClearCacheChanged(String stringValue) {
        FlushClearCache newValue = (FlushClearCache)EclipseLinkCaching.getEnumValueOf((String)stringValue, (Enum[])FlushClearCache.values());
        FlushClearCache old = this.flushClearCache;
        this.flushClearCache = newValue;
        this.firePropertyChanged("flushClearCache", (Object)old, (Object)newValue);
    }

    @Override
    public FlushClearCache getDefaultFlushClearCache() {
        return DEFAULT_FLUSH_CLEAR_CACHE;
    }

    private CacheProperties setCacheType_(String stringValue, String entityName) {
        CacheType newValue = (CacheType)EclipseLinkCaching.getEnumValueOf((String)stringValue, (Enum[])CacheType.values());
        return this.setCacheType_(newValue, entityName);
    }

    private CacheProperties setCacheType_(CacheType newValue, String entityName) {
        CacheProperties properties = this.cachePropertiesOf(entityName);
        CacheProperties old = properties.clone();
        properties.setType(newValue);
        this.putEntityCacheProperties(entityName, properties);
        return old;
    }

    private CacheProperties setCacheSize_(String stringValue, String entityName) {
        Integer newValue = EclipseLinkCaching.getIntegerValueOf(stringValue);
        return this.setCacheSize_(newValue, entityName);
    }

    private CacheProperties setCacheSize_(Integer newValue, String entityName) {
        CacheProperties properties = this.cachePropertiesOf(entityName);
        CacheProperties old = properties.clone();
        properties.setSize(newValue);
        this.putEntityCacheProperties(entityName, properties);
        return old;
    }

    private CacheProperties setSharedCache_(String newString, String entityName) {
        Boolean newValue = EclipseLinkCaching.getBooleanValueOf(newString);
        return this.setSharedCache_(newValue, entityName);
    }

    private CacheProperties setSharedCache_(Boolean newValue, String entityName) {
        CacheProperties properties = this.cachePropertiesOf(entityName);
        CacheProperties old = properties.clone();
        properties.setShared(newValue);
        this.putEntityCacheProperties(entityName, properties);
        return old;
    }

    private CacheProperties cachePropertiesOf(String entityName) {
        CacheProperties properties = this.entitiesCacheProperties.get(entityName);
        if (properties == null) {
            properties = new CacheProperties(entityName);
        }
        return properties;
    }

    private void clearCacheProperties(String entityName) {
        this.setCacheType(null, entityName);
        this.setCacheSize(null, entityName);
        this.setSharedCache(null, entityName);
    }

    private void putEntityCacheProperties(String entityName, CacheProperties properties) {
        this.addOrReplacePropertiesForEntity(entityName, properties);
    }

    @Override
    public ListIterator<String> entities() {
        return CollectionTools.list(this.entitiesCacheProperties.keySet()).listIterator();
    }

    @Override
    public int entitiesSize() {
        return this.entitiesCacheProperties.size();
    }

    @Override
    public boolean entityExists(String entity) {
        return this.entitiesCacheProperties.containsKey(entity);
    }

    @Override
    public String addEntity(String entity) {
        if (this.entityExists(entity)) {
            throw new IllegalStateException("Entity " + entity + " already exists.");
        }
        return this.addOrReplacePropertiesForEntity(entity, new CacheProperties(entity));
    }

    private String addOrReplacePropertiesForEntity(String entity, CacheProperties properties) {
        if (this.entityExists(entity)) {
            this.replaceEntity_(entity, properties);
            return null;
        }
        this.entitiesCacheProperties.put(entity, properties);
        this.fireListChanged("entities");
        return entity;
    }

    private CacheProperties replaceEntity_(String entity, CacheProperties properties) {
        CacheProperties old = this.entitiesCacheProperties.get(entity);
        if (properties.isEmpty()) {
            this.entitiesCacheProperties.remove(entity);
            this.fireListChanged("entities");
        } else {
            this.entitiesCacheProperties.put(entity, properties);
        }
        return old;
    }

    @Override
    public void removeEntity(String entity) {
        if (!this.entityExists(entity)) {
            return;
        }
        this.clearCacheProperties(entity);
        this.entitiesCacheProperties.remove(entity);
        this.fireListChanged("entities");
    }
}

