/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.AnnotationContainerTools;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.core.resource.java.AnnotationContainer;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceBaseTypeConverterAnnotation;
import org.eclipse.jpt.eclipselink.core.internal.resource.java.source.SourceConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.NestableConversionValueAnnotation;
import org.eclipse.jpt.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceObjectTypeConverterAnnotation
extends SourceBaseTypeConverterAnnotation
implements ObjectTypeConverterAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.ObjectTypeConverter");
    private static final DeclarationAnnotationElementAdapter<String> DEFAULT_OBJECT_VALUE_ADAPTER = SourceObjectTypeConverterAnnotation.buildDefaultObjectValueAdapter();
    private final AnnotationElementAdapter<String> defaultObjectValueAdapter;
    private String defaultObjectValue;
    private final Vector<NestableConversionValueAnnotation> conversionValues = new Vector();
    private final ConversionValuesAnnotationContainer conversionValuesContainer = new ConversionValuesAnnotationContainer();

    public SourceObjectTypeConverterAnnotation(JavaResourcePersistentMember parent, Member member) {
        super(parent, member, DECLARATION_ANNOTATION_ADAPTER);
        this.defaultObjectValueAdapter = new ShortCircuitAnnotationElementAdapter(member, DEFAULT_OBJECT_VALUE_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.ObjectTypeConverter";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.defaultObjectValue = this.buildDefaultObjectValue(astRoot);
        AnnotationContainerTools.initialize((AnnotationContainer)this.conversionValuesContainer, (CompilationUnit)astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.setDefaultObjectValue(this.buildDefaultObjectValue(astRoot));
        AnnotationContainerTools.update((AnnotationContainer)this.conversionValuesContainer, (CompilationUnit)astRoot);
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getDataTypeElementName() {
        return "dataType";
    }

    @Override
    String getObjectTypeElementName() {
        return "objectType";
    }

    @Override
    public String getDefaultObjectValue() {
        return this.defaultObjectValue;
    }

    @Override
    public void setDefaultObjectValue(String defaultObjectValue) {
        if (this.attributeValueHasNotChanged(this.defaultObjectValue, defaultObjectValue)) {
            return;
        }
        String old = this.defaultObjectValue;
        this.defaultObjectValue = defaultObjectValue;
        this.defaultObjectValueAdapter.setValue((Object)defaultObjectValue);
        this.firePropertyChanged("defaultObjectValue", old, defaultObjectValue);
    }

    private String buildDefaultObjectValue(CompilationUnit astRoot) {
        return (String)this.defaultObjectValueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getDefaultObjectValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(DEFAULT_OBJECT_VALUE_ADAPTER, astRoot);
    }

    @Override
    public ListIterator<ConversionValueAnnotation> conversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    ListIterator<NestableConversionValueAnnotation> nestableConversionValues() {
        return new CloneListIterator(this.conversionValues);
    }

    @Override
    public int conversionValuesSize() {
        return this.conversionValues.size();
    }

    @Override
    public NestableConversionValueAnnotation conversionValueAt(int index) {
        return this.conversionValues.get(index);
    }

    @Override
    public int indexOfConversionValue(ConversionValueAnnotation conversionValue) {
        return this.conversionValues.indexOf(conversionValue);
    }

    @Override
    public NestableConversionValueAnnotation addConversionValue(int index) {
        return (NestableConversionValueAnnotation)AnnotationContainerTools.addNestedAnnotation((int)index, (AnnotationContainer)this.conversionValuesContainer);
    }

    NestableConversionValueAnnotation addConversionValueInternal() {
        NestableConversionValueAnnotation conversionValue = this.buildConversionValue(this.conversionValues.size());
        this.conversionValues.add(conversionValue);
        return conversionValue;
    }

    private NestableConversionValueAnnotation buildConversionValue(int index) {
        return SourceConversionValueAnnotation.createConversionValue(this, this.member, this.daa, index);
    }

    void conversionValueAdded(int index, NestableConversionValueAnnotation conversionValue) {
        this.fireItemAdded("conversionValues", index, conversionValue);
    }

    @Override
    public void moveConversionValue(int targetIndex, int sourceIndex) {
        AnnotationContainerTools.moveNestedAnnotation((int)targetIndex, (int)sourceIndex, (AnnotationContainer)this.conversionValuesContainer);
    }

    NestableConversionValueAnnotation moveConversionValueInternal(int targetIndex, int sourceIndex) {
        return (NestableConversionValueAnnotation)CollectionTools.move(this.conversionValues, (int)targetIndex, (int)sourceIndex).get(targetIndex);
    }

    void conversionValueMoved(int targetIndex, int sourceIndex) {
        this.fireItemMoved("conversionValues", targetIndex, sourceIndex);
    }

    @Override
    public void removeConversionValue(int index) {
        AnnotationContainerTools.removeNestedAnnotation((int)index, (AnnotationContainer)this.conversionValuesContainer);
    }

    NestableConversionValueAnnotation removeConversionValueInternal(int index) {
        return this.conversionValues.remove(index);
    }

    void conversionValueRemoved(int index, NestableConversionValueAnnotation conversionValue) {
        this.fireItemRemoved("conversionValues", index, conversionValue);
    }

    private static DeclarationAnnotationElementAdapter<String> buildDefaultObjectValueAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "defaultObjectValue", false, StringExpressionConverter.instance());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConversionValuesAnnotationContainer
    implements AnnotationContainer<NestableConversionValueAnnotation> {
        ConversionValuesAnnotationContainer() {
        }

        public String getContainerAnnotationName() {
            return SourceObjectTypeConverterAnnotation.this.getAnnotationName();
        }

        public Annotation getContainerJdtAnnotation(CompilationUnit astRoot) {
            return SourceObjectTypeConverterAnnotation.this.getJdtAnnotation(astRoot);
        }

        public String getElementName() {
            return "conversionValues";
        }

        public String getNestableAnnotationName() {
            return "org.eclipse.persistence.annotations.ConversionValue";
        }

        public ListIterator<NestableConversionValueAnnotation> nestedAnnotations() {
            return SourceObjectTypeConverterAnnotation.this.nestableConversionValues();
        }

        public int nestedAnnotationsSize() {
            return SourceObjectTypeConverterAnnotation.this.conversionValuesSize();
        }

        public NestableConversionValueAnnotation addNestedAnnotationInternal() {
            return SourceObjectTypeConverterAnnotation.this.addConversionValueInternal();
        }

        public void nestedAnnotationAdded(int index, NestableConversionValueAnnotation nestedAnnotation) {
            SourceObjectTypeConverterAnnotation.this.conversionValueAdded(index, nestedAnnotation);
        }

        public NestableConversionValueAnnotation moveNestedAnnotationInternal(int targetIndex, int sourceIndex) {
            return SourceObjectTypeConverterAnnotation.this.moveConversionValueInternal(targetIndex, sourceIndex);
        }

        public void nestedAnnotationMoved(int targetIndex, int sourceIndex) {
            SourceObjectTypeConverterAnnotation.this.conversionValueMoved(targetIndex, sourceIndex);
        }

        public NestableConversionValueAnnotation removeNestedAnnotationInternal(int index) {
            return SourceObjectTypeConverterAnnotation.this.removeConversionValueInternal(index);
        }

        public void nestedAnnotationRemoved(int index, NestableConversionValueAnnotation nestedAnnotation) {
            SourceObjectTypeConverterAnnotation.this.conversionValueRemoved(index, nestedAnnotation);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

