/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.BooleanExpressionConverter;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.eclipselink.core.resource.java.TransformationAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTransformationAnnotation
extends SourceAnnotation<Attribute>
implements TransformationAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.eclipse.persistence.annotations.Transformation");
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceTransformationAnnotation.buildFetchAdapter();
    private final AnnotationElementAdapter<String> fetchAdapter;
    private FetchType fetch;
    private static final DeclarationAnnotationElementAdapter<Boolean> OPTIONAL_ADAPTER = SourceTransformationAnnotation.buildOptionalAdapter();
    private final AnnotationElementAdapter<Boolean> optionalAdapter;
    private Boolean optional;

    public SourceTransformationAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super((JavaResourceNode)parent, (Member)attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.fetchAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, FETCH_ADAPTER);
        this.optionalAdapter = new ShortCircuitAnnotationElementAdapter((Member)attribute, OPTIONAL_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Transformation";
    }

    public void initialize(CompilationUnit astRoot) {
        this.optional = this.buildOptional(astRoot);
        this.fetch = this.buildFetch(astRoot);
    }

    public void update(CompilationUnit astRoot) {
        this.setOptional(this.buildOptional(astRoot));
        this.setFetch(this.buildFetch(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.fetch);
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasNotChanged(this.fetch, fetch)) {
            return;
        }
        FetchType old = this.fetch;
        this.fetch = fetch;
        this.fetchAdapter.setValue((Object)FetchType.toJavaAnnotationValue((FetchType)fetch));
        this.firePropertyChanged("fetch", old, fetch);
    }

    private FetchType buildFetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue((Object)this.fetchAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FETCH_ADAPTER, astRoot);
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(Boolean optional) {
        if (this.attributeValueHasNotChanged(this.optional, optional)) {
            return;
        }
        Boolean old = this.optional;
        this.optional = optional;
        this.optionalAdapter.setValue((Object)optional);
        this.firePropertyChanged("optional", old, optional);
    }

    private Boolean buildOptional(CompilationUnit astRoot) {
        return (Boolean)this.optionalAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getOptionalTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(OPTIONAL_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<Boolean> buildOptionalAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "optional", false, BooleanExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch", false);
    }
}

