/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.HashBag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashBag<E>
extends AbstractCollection<E>
implements Bag<E>,
Cloneable,
Serializable {
    transient Entry<E>[] table;
    transient int count = 0;
    transient int uniqueCount = 0;
    private int threshold;
    private float loadFactor;
    transient int modCount = 0;
    private static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    private static final long serialVersionUID = 1L;

    public IdentityHashBag() {
        this(11, 0.75f);
    }

    public IdentityHashBag(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashBag(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = this.buildTable(initialCapacity);
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IdentityHashBag(Collection<? extends E> c) {
        this(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object o) {
        Entry<E>[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<E> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int count(Object o) {
        Entry<E>[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<E> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                return e.count;
            }
            e = e.next;
        }
        return 0;
    }

    private void rehash() {
        Entry<E>[] oldMap = this.table;
        int oldCapacity = oldMap.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry<E>[] newTable = this.buildTable(newCapacity);
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<E> old = oldMap[i];
            while (old != null) {
                Entry<E> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    private Entry<E>[] buildTable(int capacity) {
        return new Entry[capacity];
    }

    private <T> Entry<E> buildEntry(int hash, Object o, Entry<T> next) {
        return new Entry<Object>(hash, o, next);
    }

    private <T> Entry<E> buildEntry(int hash, Object o, int cnt, Entry<T> next) {
        return new Entry<Object>(hash, o, cnt, next);
    }

    @Override
    public boolean add(E o) {
        ++this.modCount;
        Entry<E>[] tab = this.table;
        int hash = 0;
        int index = 0;
        hash = System.identityHashCode(o);
        index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<E> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                ++e.count;
                ++this.count;
                return true;
            }
            e = e.next;
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = this.buildEntry(hash, o, tab[index]);
        ++this.count;
        ++this.uniqueCount;
        return true;
    }

    @Override
    public boolean add(E o, int cnt) {
        if (cnt <= 0) {
            return false;
        }
        ++this.modCount;
        Entry<E>[] tab = this.table;
        int hash = 0;
        int index = 0;
        hash = System.identityHashCode(o);
        index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<E> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                e.count += cnt;
                this.count += cnt;
                return true;
            }
            e = e.next;
        }
        if (this.uniqueCount >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = this.buildEntry(hash, o, cnt, tab[index]);
        this.count += cnt;
        ++this.uniqueCount;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Entry<E>[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<E> e = tab[index];
        Entry<E> prev = null;
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                ++this.modCount;
                --e.count;
                if (e.count == 0) {
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --this.uniqueCount;
                }
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean remove(Object o, int cnt) {
        if (cnt <= 0) {
            return false;
        }
        Entry<E>[] tab = this.table;
        int hash = System.identityHashCode(o);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<E> e = tab[index];
        Entry<E> prev = null;
        while (e != null) {
            if (e.hash == hash && e.object == o) {
                ++this.modCount;
                int cnt2 = cnt < e.count ? cnt : e.count;
                e.count -= cnt2;
                if (e.count == 0) {
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --this.uniqueCount;
                }
                this.count -= cnt2;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(this.buildIdentityHashBag(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(this.buildIdentityHashBag(c));
    }

    private Collection<?> buildIdentityHashBag(Collection<?> c) {
        return new IdentityHashBag(c);
    }

    @Override
    public void clear() {
        Entry<E>[] tab = this.table;
        ++this.modCount;
        int i = tab.length;
        while (--i >= 0) {
            tab[i] = null;
        }
        this.count = 0;
        this.uniqueCount = 0;
    }

    public IdentityHashBag<E> clone() {
        try {
            IdentityHashBag clone = (IdentityHashBag)super.clone();
            clone.table = this.buildTable(this.table.length);
            int i = this.table.length;
            while (i-- > 0) {
                Entry<E> entry = clone.table[i] = this.table[i] == null ? null : this.table[i].clone();
            }
            clone.modCount = 0;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.count == 0 ? EMPTY_ITERATOR : new HashIterator();
    }

    @Override
    public Iterator<E> uniqueIterator() {
        return this.count == 0 ? EMPTY_ITERATOR : new UniqueIterator();
    }

    @Override
    public Iterator<Bag.Entry<E>> entries() {
        return this.count == 0 ? EMPTY_ITERATOR : new EntryIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IdentityHashBag) {
            IdentityHashBag b = (IdentityHashBag)o;
            if (b.size() != this.size()) {
                return false;
            }
            Object clone = this.clone();
            for (E e : b) {
                if (((IdentityHashBag)clone).remove(e)) continue;
                return false;
            }
            return ((IdentityHashBag)clone).isEmpty();
        }
        if (o instanceof Bag) {
            return this.buildBag().equals(o);
        }
        return false;
    }

    private Bag<E> buildBag() {
        return new HashBag(this);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (E e : this) {
            h += System.identityHashCode(e);
        }
        return h;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        Entry<E>[] tab;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.uniqueCount);
        Entry<E>[] entryArray = tab = this.table;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<E> entry = entryArray[n2];
            while (entry != null) {
                s.writeObject(entry.object);
                s.writeInt(entry.count);
                entry = entry.next;
            }
            ++n2;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.table = this.buildTable(s.readInt());
        int unique = s.readInt();
        int i = 0;
        while (i < unique) {
            Object element = s.readObject();
            int elementCount = s.readInt();
            int j = 0;
            while (j < elementCount) {
                this.add(element);
                ++j;
            }
            ++i;
        }
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<E>
    implements Bag.Entry<E> {
        int hash;
        E object;
        int count;
        Entry<E> next;

        Entry(int hash, E object, Entry<E> next) {
            this(hash, object, 1, next);
        }

        Entry(int hash, E object, int count, Entry<E> next) {
            this.hash = hash;
            this.object = object;
            this.count = count;
            this.next = next;
        }

        protected Entry<E> clone() {
            return new Entry<E>(this.hash, this.object, this.count, this.next == null ? null : this.next.clone());
        }

        @Override
        public E getElement() {
            return this.object;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public int setCount(int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("count must be greater than zero: " + count);
            }
            int old = this.count;
            this.count = count;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Bag.Entry)) {
                return false;
            }
            Bag.Entry e = (Bag.Entry)o;
            return this.object == e.getElement() && this.count == e.getCount();
        }

        @Override
        public int hashCode() {
            E o = this.object;
            return o == null ? 0 : this.count * o.hashCode();
        }

        public String toString() {
            return this.object + "=>" + this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Entry<E>> {
        private Entry<E>[] localTable;
        private int index;
        private Entry<E> nextEntry;
        private Entry<E> lastReturnedEntry;
        private int expectedModCount;

        EntryIterator() {
            this.localTable = IdentityHashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.lastReturnedEntry = null;
            this.expectedModCount = IdentityHashBag.this.modCount;
        }

        @Override
        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = this.localTable;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public Entry<E> next() {
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = this.localTable;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            this.lastReturnedEntry = this.nextEntry;
            Entry e = this.lastReturnedEntry;
            this.nextEntry = e.next;
            return e;
        }

        @Override
        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry<E>[] tab = this.localTable;
            int slot = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++IdentityHashBag.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[slot] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --IdentityHashBag.this.uniqueCount;
                    IdentityHashBag.this.count -= this.lastReturnedEntry.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HashIterator
    implements Iterator<E> {
        private Entry<E>[] localTable;
        private int index;
        private Entry<E> nextEntry;
        private int nextEntryCount;
        private Entry<E> lastReturnedEntry;
        private int expectedModCount;

        HashIterator() {
            this.localTable = IdentityHashBag.this.table;
            this.index = this.localTable.length;
            this.nextEntry = null;
            this.nextEntryCount = 0;
            this.lastReturnedEntry = null;
            this.expectedModCount = IdentityHashBag.this.modCount;
        }

        @Override
        public boolean hasNext() {
            Entry e = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = this.localTable;
            while (e == null && i > 0) {
                e = tab[--i];
            }
            this.nextEntry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public E next() {
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et = this.nextEntry;
            int i = this.index;
            Entry<E>[] tab = this.localTable;
            while (et == null && i > 0) {
                et = tab[--i];
            }
            this.nextEntry = et;
            this.index = i;
            if (et == null) {
                throw new NoSuchElementException();
            }
            this.lastReturnedEntry = this.nextEntry;
            Entry e = this.lastReturnedEntry;
            ++this.nextEntryCount;
            if (this.nextEntryCount == e.count) {
                this.nextEntry = e.next;
                this.nextEntryCount = 0;
            }
            return e.object;
        }

        @Override
        public void remove() {
            if (this.lastReturnedEntry == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashBag.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry<E>[] tab = this.localTable;
            int slot = (this.lastReturnedEntry.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[slot];
            Entry prev = null;
            while (e != null) {
                if (e == this.lastReturnedEntry) {
                    ++IdentityHashBag.this.modCount;
                    ++this.expectedModCount;
                    --e.count;
                    if (e.count == 0) {
                        if (prev == null) {
                            tab[slot] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        --IdentityHashBag.this.uniqueCount;
                    } else {
                        --this.nextEntryCount;
                    }
                    --IdentityHashBag.this.count;
                    this.lastReturnedEntry = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UniqueIterator
    implements Iterator<E> {
        private EntryIterator entryIterator;

        UniqueIterator() {
            this.entryIterator = new EntryIterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public E next() {
            return ((Entry)this.entryIterator.next()).object;
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }
}

