/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterables;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.utility.internal.iterators.GraphIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> roots;
    private final GraphIterator.MisterRogers<E> misterRogers;

    public GraphIterable(E root) {
        this(new SingleElementIterable<E>(root));
    }

    public GraphIterable(E root, GraphIterator.MisterRogers<E> misterRogers) {
        this(new SingleElementIterable<E>(root), misterRogers);
    }

    public GraphIterable(E ... roots) {
        this(Arrays.asList(roots));
    }

    public GraphIterable(E[] roots, GraphIterator.MisterRogers<E> misterRogers) {
        this(Arrays.asList(roots), misterRogers);
    }

    public GraphIterable(Iterable<? extends E> roots) {
        this.roots = roots;
        this.misterRogers = new DefaultMisterRogers();
    }

    public GraphIterable(Iterable<? extends E> roots, GraphIterator.MisterRogers<E> misterRogers) {
        this.roots = roots;
        this.misterRogers = misterRogers;
    }

    @Override
    public Iterator<E> iterator() {
        return new GraphIterator<E>(this.roots, this.misterRogers);
    }

    protected Iterator<? extends E> neighbors(E next) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.roots);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultMisterRogers
    implements GraphIterator.MisterRogers<E> {
        DefaultMisterRogers() {
        }

        @Override
        public Iterator<? extends E> neighbors(E node) {
            return GraphIterable.this.neighbors(node);
        }
    }
}

