/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.model.event;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionChangeEvent
extends ChangeEvent {
    private final String collectionName;
    private final Collection<?> items;
    private static final long serialVersionUID = 1L;

    public CollectionChangeEvent(Model source, String collectionName, Collection<?> items) {
        super(source);
        if (collectionName == null || items == null) {
            throw new NullPointerException();
        }
        this.collectionName = collectionName;
        this.items = Collections.unmodifiableCollection(items);
    }

    public CollectionChangeEvent(Model source, String collectionName) {
        this(source, collectionName, Collections.emptySet());
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    @Override
    public String getAspectName() {
        return this.collectionName;
    }

    public Iterator<?> items() {
        return this.items.iterator();
    }

    public int itemsSize() {
        return this.items.size();
    }

    @Override
    public CollectionChangeEvent cloneWithSource(Model newSource) {
        return new CollectionChangeEvent(newSource, this.collectionName, this.items);
    }

    public CollectionChangeEvent cloneWithSource(Model newSource, String newCollectionName) {
        return new CollectionChangeEvent(newSource, newCollectionName, this.items);
    }
}

