/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaModel;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.platform.JpaPlatformRegistry;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JptCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jpt.core";
    public static final String PLUGIN_ID_ = "org.eclipse.jpt.core.";
    public static final String FACET_ID = "jpt.jpa";
    public static final String JPA_PLATFORM = "org.eclipse.jpt.core.platform";
    public static final String DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.core.discoverAnnotatedClasses";
    public static final QualifiedName DATA_SOURCE_CONNECTION_PROFILE_NAME = new QualifiedName("org.eclipse.jpt.core", "dataSource.connectionProfileName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_CATALOG_NAME = new QualifiedName("org.eclipse.jpt.core", "userOverrideDefaultCatalogName");
    public static final QualifiedName USER_OVERRIDE_DEFAULT_SCHEMA_NAME = new QualifiedName("org.eclipse.jpt.core", "userOverrideDefaultSchemaName");
    public static final String VALIDATOR_ID = "org.eclipse.jpt.core.jpaValidator";
    public static final IContentType JAVA_SOURCE_CONTENT_TYPE = JptCorePlugin.getContentType("org.eclipse.jdt.core.javaSource");
    public static final IContentType MAPPING_FILE_CONTENT_TYPE = JptCorePlugin.getJpaContentType("mappingFile");
    public static final IContentType ORM_XML_CONTENT_TYPE = JptCorePlugin.getJpaContentType("orm");
    public static final IContentType PERSISTENCE_XML_CONTENT_TYPE = JptCorePlugin.getJpaContentType("persistence");
    public static final IContentType JAR_CONTENT_TYPE = JptCorePlugin.getJpaContentType("jar");
    public static final String WEB_PROJECT_FACET_ID = "jst.web";
    public static final String WEB_PROJECT_DEPLOY_PREFIX = "WEB-INF/classes";
    public static final String DEFAULT_PERSISTENCE_XML_FILE_PATH = "META-INF/persistence.xml";
    public static final String DEFAULT_ORM_XML_FILE_PATH = "META-INF/orm.xml";
    public static final String CONTENT_PREFIX = "org.eclipse.jpt.core.content";
    public static final String CONTENT_PREFIX_ = "org.eclipse.jpt.core.content.";
    private static JptCorePlugin INSTANCE;

    private static IContentType getJpaContentType(String jpaContentType) {
        return JptCorePlugin.getContentType(CONTENT_PREFIX_ + jpaContentType);
    }

    private static IContentType getContentType(String contentType) {
        return Platform.getContentTypeManager().getContentType(contentType);
    }

    public static JptCorePlugin instance() {
        return INSTANCE;
    }

    public static JpaModel getJpaModel() {
        return JpaModelManager.instance().getJpaModel();
    }

    public static JpaProject getJpaProject(IProject project) {
        try {
            return JpaModelManager.instance().getJpaProject(project);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static JpaFile getJpaFile(IFile file) {
        try {
            return JpaModelManager.instance().getJpaFile(file);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static boolean projectHasJpaFacet(IProject project) {
        return JptCorePlugin.projectHasFacet(project, FACET_ID);
    }

    public static boolean projectHasWebFacet(IProject project) {
        return JptCorePlugin.projectHasFacet(project, WEB_PROJECT_FACET_ID);
    }

    private static boolean projectHasFacet(IProject project, String facetId) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetId);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return false;
        }
    }

    public static String getPersistenceXmlDeploymentURI(IProject project) {
        return JptCorePlugin.getDeploymentURI(project, DEFAULT_PERSISTENCE_XML_FILE_PATH);
    }

    public static String getDefaultOrmXmlDeploymentURI(IProject project) {
        return JptCorePlugin.getDeploymentURI(project, DEFAULT_ORM_XML_FILE_PATH);
    }

    public static String getOrmXmlDeploymentURI(IProject project, String mappingFileName) {
        return JptCorePlugin.getDeploymentURI(project, mappingFileName);
    }

    public static String getDeploymentURI(IProject project, String defaultURI) {
        return JptCorePlugin.projectHasWebFacet(project) ? "WEB-INF/classes/" + defaultURI : defaultURI;
    }

    public static IPath getJarDeploymentRootPath(IProject project) {
        return JptCorePlugin.projectHasWebFacet(project) ? new Path("/WEB-INF") : new Path("/");
    }

    public static IFile getPlatformFile(IProject project, String defaultURI) {
        Path deploymentPath = new Path(JptCorePlugin.getDeploymentURI(project, defaultURI));
        IVirtualFile vFile = ComponentCore.createFile((IProject)project, (IPath)deploymentPath);
        return vFile.getUnderlyingFile();
    }

    public static JpaFile getJpaFile(IProject project, String defaultURI) {
        IFile xmlFile = JptCorePlugin.getPlatformFile(project, defaultURI);
        return xmlFile.exists() ? JptCorePlugin.getJpaFile(xmlFile) : null;
    }

    public static IEclipsePreferences getDefaultPreferences() {
        DefaultScope context = new DefaultScope();
        return context.getNode(PLUGIN_ID);
    }

    public static IEclipsePreferences getWorkspacePreferences() {
        InstanceScope context = new InstanceScope();
        return context.getNode(PLUGIN_ID);
    }

    public static IEclipsePreferences getProjectPreferences(IProject project) {
        ProjectScope context = new ProjectScope(project);
        return context.getNode(PLUGIN_ID);
    }

    public static String getDefaultJpaPlatformId() {
        String platformId = Platform.getPreferencesService().get("defaultJpaPlatform", "generic", new Preferences[]{JptCorePlugin.getWorkspacePreferences(), JptCorePlugin.getDefaultPreferences()});
        if (!JpaPlatformRegistry.instance().containsPlatform(platformId)) {
            platformId = Platform.getPreferencesService().get("defaultJpaPlatform", "generic", new Preferences[]{JptCorePlugin.getDefaultPreferences()});
        }
        return platformId;
    }

    public static void setDefaultJpaPlatformId(String platformId) {
        IEclipsePreferences prefs = JptCorePlugin.getWorkspacePreferences();
        prefs.put("defaultJpaPlatform", platformId);
        JptCorePlugin.flush(prefs);
    }

    public static JpaPlatform getJpaPlatform(IProject project) {
        return JpaPlatformRegistry.instance().getJpaPlatform(project);
    }

    public static String getJpaPlatformId(IProject project) {
        return JptCorePlugin.getProjectPreferences(project).get(JPA_PLATFORM, "generic");
    }

    public static void setJpaPlatformId(IProject project, String jpaPlatformId) {
        IEclipsePreferences prefs = JptCorePlugin.getProjectPreferences(project);
        prefs.put(JPA_PLATFORM, jpaPlatformId);
        JptCorePlugin.flush(prefs);
    }

    public static boolean discoverAnnotatedClasses(IProject project) {
        return JptCorePlugin.getProjectPreferences(project).getBoolean(DISCOVER_ANNOTATED_CLASSES, false);
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean discoverAnnotatedClasses) {
        IEclipsePreferences prefs = JptCorePlugin.getProjectPreferences(project);
        prefs.putBoolean(DISCOVER_ANNOTATED_CLASSES, discoverAnnotatedClasses);
        JptCorePlugin.flush(prefs);
    }

    private static void flush(IEclipsePreferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static String getConnectionProfileName(IProject project) {
        try {
            return project.getPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static void setConnectionProfileName(IProject project, String connectionProfileName) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, connectionProfileName);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static String getUserOverrideDefaultCatalogName(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG_NAME);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
            return null;
        }
    }

    public static void setUserOverrideDefaultCatalogName(IProject project, String defaultCatalogName) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_CATALOG_NAME, defaultCatalogName);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
    }

    public static String getUserOverrideDefaultSchemaName(IProject project) {
        try {
            return project.getPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA_NAME);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
            return null;
        }
    }

    public static void setUserOverrideDefaultSchemaName(IProject project, String defaultSchemaName) {
        try {
            project.setPersistentProperty(USER_OVERRIDE_DEFAULT_SCHEMA_NAME, defaultSchemaName);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public static void log(String msg) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void log(Throwable throwable) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, throwable.getLocalizedMessage(), throwable));
    }

    public JptCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JpaModelManager.instance().start();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            JpaModelManager.instance().stop();
        }
        finally {
            super.stop(context);
        }
    }
}

