/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaModel;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.GenericJpaModel;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JpaModelManager {
    private GenericJpaModel jpaModel;
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private final IFacetedProjectListener facetedProjectListener = new FacetedProjectListener();
    private final IElementChangedListener javaElementChangeListener = new JavaElementChangeListener();
    private static final JpaModelManager INSTANCE = new JpaModelManager();
    private static final boolean DEBUG = false;

    public static JpaModelManager instance() {
        return INSTANCE;
    }

    private JpaModelManager() {
    }

    public synchronized void start() throws Exception {
        JpaModelManager.debug("*** START JPA model manager ***");
        try {
            this.jpaModel = new GenericJpaModel();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 21);
            FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetedProjectListener, (IFacetedProjectEvent.Type[])IFacetedProjectEvent.Type.values());
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        }
        catch (RuntimeException ex) {
            this.log(ex);
            this.stop();
        }
    }

    public synchronized void stop() throws Exception {
        JpaModelManager.debug("*** STOP JPA model manager ***");
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetedProjectListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.jpaModel.dispose();
        this.jpaModel = null;
    }

    public JpaModel getJpaModel() {
        return this.jpaModel;
    }

    public JpaProject getJpaProject(IProject project) throws CoreException {
        return this.jpaModel.getJpaProject(project);
    }

    public JpaFile getJpaFile(IFile file) throws CoreException {
        return this.jpaModel.getJpaFile(file);
    }

    public void rebuildJpaProject(IProject project) {
        this.jpaModel.rebuildJpaProject(project);
    }

    public void log(IStatus status) {
        JptCorePlugin.log(status);
    }

    public void log(String msg) {
        JptCorePlugin.log(msg);
    }

    public void log(Throwable throwable) {
        JptCorePlugin.log(throwable);
    }

    void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 16) {
            this.resourcePostBuild(event);
            return;
        }
        if (!(event.getSource() instanceof IWorkspace)) {
            return;
        }
        switch (event.getType()) {
            case 4: {
                this.resourcePreDelete(event);
                break;
            }
            case 1: {
                this.resourcePostChange(event);
                break;
            }
        }
    }

    private void resourcePreDelete(IResourceChangeEvent event) {
        IProject project = (IProject)event.getResource();
        JpaModelManager.debug("Resource (Project) PRE_DELETE: ", project);
        this.jpaModel.projectPreDelete(project);
    }

    private void resourcePostChange(IResourceChangeEvent event) {
        JpaModelManager.debug("Resource POST_CHANGE");
        this.resourceChanged(event.getDelta());
    }

    private void resourceChanged(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                this.resourceChangedChildren(delta);
                break;
            }
            case 4: {
                this.projectChanged((IProject)resource, delta);
                break;
            }
        }
    }

    private void resourceChangedChildren(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.resourceChanged(child);
            ++n2;
        }
    }

    private void projectChanged(IProject project, IResourceDelta delta) {
        this.projectChanged_(delta);
        this.checkForOpenedProject(project, delta);
    }

    private void projectChanged_(IResourceDelta delta) {
        try {
            this.jpaModel.projectChanged(delta);
        }
        catch (CoreException ex) {
            this.log(ex);
        }
    }

    private void checkForOpenedProject(IProject project, IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                this.checkDeltaFlagsForOpenedProject(project, delta);
                this.checkDeltaFlagsForRenamedProject(project, delta);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.checkDeltaFlagsForOpenedProject(project, delta);
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
    }

    private void checkDeltaFlagsForOpenedProject(IProject project, IResourceDelta delta) {
        if (BitTools.flagIsSet((int)delta.getFlags(), (int)16384) && project.isOpen()) {
            JpaModelManager.debug("\tProject CHANGED - OPEN: ", project.getName());
            this.jpaModel.checkForTransition(project);
        }
    }

    private void checkDeltaFlagsForRenamedProject(IProject project, IResourceDelta delta) {
        if (BitTools.flagIsSet((int)delta.getFlags(), (int)4096) && project.isOpen()) {
            JpaModelManager.debug("\tProject ADDED - MOVED_FROM: ", delta.getMovedFromPath());
            this.jpaModel.checkForTransition(project);
        }
    }

    private void resourcePostBuild(IResourceChangeEvent event) {
        JpaModelManager.debug("Resource POST_BUILD");
        if (event.getBuildKind() == 15) {
            this.resourcePostClean(event.getDelta());
        }
    }

    private void resourcePostClean(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                this.resourcePostCleanChildren(delta);
                break;
            }
            case 4: {
                this.projectPostClean((IProject)resource);
                break;
            }
        }
    }

    private void resourcePostCleanChildren(IResourceDelta delta) {
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.resourcePostClean(child);
            ++n2;
        }
    }

    private void projectPostClean(IProject project) {
        JpaProject jpaProject = null;
        try {
            jpaProject = this.getJpaProject(project);
        }
        catch (CoreException coreException) {}
        if (jpaProject != null) {
            this.rebuildJpaProject(project);
        }
    }

    void facetedProjectChanged(IFacetedProjectEvent event) {
        switch (event.getType()) {
            case POST_INSTALL: {
                this.facetedProjectPostInstall((IProjectFacetActionEvent)event);
                break;
            }
            case PRE_UNINSTALL: {
                this.facetedProjectPreUninstall((IProjectFacetActionEvent)event);
                break;
            }
            case PROJECT_MODIFIED: {
                this.facetedProjectModified(event.getProject().getProject());
                break;
            }
        }
    }

    private void facetedProjectPostInstall(IProjectFacetActionEvent event) {
        JpaModelManager.debug("Facet POST_INSTALL: ", event.getProjectFacet());
        if (event.getProjectFacet().getId().equals("jpt.jpa")) {
            this.jpaModel.jpaFacetedProjectPostInstall(event);
        }
    }

    private void facetedProjectPreUninstall(IProjectFacetActionEvent event) {
        JpaModelManager.debug("Facet PRE_UNINSTALL: ", event.getProjectFacet());
        if (event.getProjectFacet().getId().equals("jpt.jpa")) {
            this.jpaModel.jpaFacetedProjectPreUninstall(event);
        }
    }

    private void facetedProjectModified(IProject project) {
        JpaModelManager.debug("Facet PROJECT_MODIFIED: ", project.getName());
        this.jpaModel.checkForTransition(project);
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.eventIndicatesProjectAddedButNotOpen(event)) {
            return;
        }
        this.jpaModel.javaElementChanged(event);
    }

    private boolean eventIndicatesProjectAddedButNotOpen(ElementChangedEvent event) {
        IJavaElement childElement;
        IJavaElementDelta childDelta;
        IJavaElementDelta[] children;
        IJavaElementDelta delta = event.getDelta();
        return delta.getKind() == 4 && delta.getElement().getElementType() == 1 && (children = delta.getAffectedChildren()).length == 1 && (childDelta = children[0]).getKind() == 1 && (childElement = childDelta.getElement()).getElementType() == 2 && childDelta.getAffectedChildren().length == 0 && !((IOpenable)childElement).isOpen();
    }

    private static void debug(String message, Object object) {
    }

    private static void debug(String message) {
    }

    private static void debug_(String message) {
        System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
    }

    private class FacetedProjectListener
    implements IFacetedProjectListener {
        FacetedProjectListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            JpaModelManager.this.facetedProjectChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JpaModelManager.this.javaElementChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            JpaModelManager.this.resourceChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

