/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaOverride;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaAssociationOverride
extends AbstractJavaOverride
implements JavaAssociationOverride {
    protected final List<JavaJoinColumn> specifiedJoinColumns = new ArrayList<JavaJoinColumn>();
    protected final List<JavaJoinColumn> defaultJoinColumns = new ArrayList<JavaJoinColumn>();

    public GenericJavaAssociationOverride(JavaJpaContextNode parent, AssociationOverride.Owner owner) {
        super(parent, owner);
    }

    @Override
    public JavaAssociationOverride setVirtual(boolean virtual) {
        return (JavaAssociationOverride)super.setVirtual(virtual);
    }

    @Override
    protected AssociationOverrideAnnotation getResourceOverride() {
        return (AssociationOverrideAnnotation)super.getResourceOverride();
    }

    @Override
    public AssociationOverride.Owner getOwner() {
        return (AssociationOverride.Owner)super.getOwner();
    }

    @Override
    public ListIterator<JavaJoinColumn> joinColumns() {
        return this.specifiedJoinColumns.isEmpty() ? this.defaultJoinColumns() : this.specifiedJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.specifiedJoinColumns.isEmpty() ? this.defaultJoinColumnsSize() : this.specifiedJoinColumnsSize();
    }

    @Override
    public ListIterator<JavaJoinColumn> defaultJoinColumns() {
        return new CloneListIterator(this.defaultJoinColumns);
    }

    @Override
    public int defaultJoinColumnsSize() {
        return this.defaultJoinColumns.size();
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        this.specifiedJoinColumns.add(index, joinColumn);
        JoinColumnAnnotation joinColumnResource = this.getResourceOverride().addJoinColumn(index);
        joinColumn.initialize(joinColumnResource);
        this.fireItemAdded("specifiedJoinColumns", index, joinColumn);
        return joinColumn;
    }

    protected JavaJoinColumn.Owner createJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    protected void addSpecifiedJoinColumn(int index, JavaJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        JavaJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        this.getResourceOverride().removeJoinColumn(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedJoinColumn);
    }

    protected void removeSpecifiedJoinColumn(JavaJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.getResourceOverride().moveJoinColumn(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    protected Iterator<String> candidateNames() {
        return this.getOwner().getTypeMapping().allOverridableAssociationNames();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.joinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void initialize(AssociationOverrideAnnotation associationOverride) {
        super.initialize(associationOverride);
        this.name = associationOverride.getName();
        this.initializeSpecifiedJoinColumns(associationOverride);
    }

    protected void initializeSpecifiedJoinColumns(AssociationOverrideAnnotation associationOverride) {
        ListIterator<JoinColumnAnnotation> annotations = associationOverride.joinColumns();
        while (annotations.hasNext()) {
            this.specifiedJoinColumns.add(this.createJoinColumn(annotations.next()));
        }
    }

    @Override
    public void update(AssociationOverrideAnnotation associationOverride) {
        super.update(associationOverride);
        this.updateSpecifiedJoinColumns(associationOverride);
    }

    protected void updateSpecifiedJoinColumns(AssociationOverrideAnnotation associationOverride) {
        ListIterator<JavaJoinColumn> joinColumns = this.specifiedJoinColumns();
        ListIterator<JoinColumnAnnotation> resourceJoinColumns = associationOverride.joinColumns();
        while (joinColumns.hasNext()) {
            JavaJoinColumn joinColumn = joinColumns.next();
            if (resourceJoinColumns.hasNext()) {
                joinColumn.update(resourceJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn(joinColumn);
        }
        while (resourceJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.createJoinColumn(resourceJoinColumns.next()));
        }
    }

    protected JavaJoinColumn createJoinColumn(JoinColumnAnnotation joinColumnResource) {
        JavaJoinColumn joinColumn = this.getJpaFactory().buildJavaJoinColumn(this, this.createJoinColumnOwner());
        joinColumn.initialize(joinColumnResource);
        return joinColumn;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.connectionProfileIsActive()) {
            this.validateJoinColumns(messages, astRoot);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, CompilationUnit astRoot) {
        ListIterator<JavaJoinColumn> stream = this.joinColumns();
        while (stream.hasNext()) {
            this.validateJoinColumn((JavaJoinColumn)stream.next(), messages, astRoot);
        }
    }

    protected void validateJoinColumn(JavaJoinColumn joinColumn, List<IMessage> messages, CompilationUnit astRoot) {
        String tableName = joinColumn.getTable();
        if (this.getOwner().getTypeMapping().tableNameIsInvalid(tableName)) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{this.getName(), tableName, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{tableName, joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange(astRoot)));
            }
            return;
        }
        if (!joinColumn.isResolved()) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange(astRoot)));
            }
        }
        if (!joinColumn.isReferencedColumnResolved()) {
            if (this.isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{this.getName(), joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange(astRoot)));
            }
        }
    }

    public class JoinColumnOwner
    implements JavaJoinColumn.Owner {
        public String getDefaultTableName() {
            return GenericJavaAssociationOverride.this.owner.getTypeMapping().getPrimaryTableName();
        }

        public String getDefaultColumnName() {
            return null;
        }

        public Entity getTargetEntity() {
            RelationshipMapping relationshipMapping = this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return GenericJavaAssociationOverride.this.getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericJavaAssociationOverride.this.getOwner().getRelationshipMapping(GenericJavaAssociationOverride.this.getName());
        }

        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return null;
        }

        public TypeMapping getTypeMapping() {
            return GenericJavaAssociationOverride.this.owner.getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericJavaAssociationOverride.this.defaultJoinColumns.contains(joinColumn);
        }

        public int joinColumnsSize() {
            return GenericJavaAssociationOverride.this.joinColumnsSize();
        }
    }
}

