/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.java.JavaDiscriminatorColumn;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaDiscriminatorColumn
extends AbstractJavaNamedColumn<DiscriminatorColumnAnnotation>
implements JavaDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType;
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength;
    protected int defaultLength;
    protected JavaResourcePersistentMember persistenceResource;

    public GenericJavaDiscriminatorColumn(JavaEntity parent, JavaDiscriminatorColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public void initialize(JavaResourcePersistentMember persistentResource) {
        this.persistenceResource = persistentResource;
        this.initialize(this.getResourceColumn());
    }

    @Override
    public void initialize(DiscriminatorColumnAnnotation column) {
        super.initialize(column);
        this.defaultDiscriminatorType = this.buildDefaultDiscriminatorType();
        this.defaultLength = this.buildDefaultLength();
        this.specifiedDiscriminatorType = this.getResourceDiscriminatorType(column);
        this.specifiedLength = this.getResourceLength(column);
    }

    @Override
    public JavaDiscriminatorColumn.Owner getOwner() {
        return (JavaDiscriminatorColumn.Owner)super.getOwner();
    }

    protected JavaEntity getJavaEntity() {
        return (JavaEntity)super.getParent();
    }

    @Override
    protected DiscriminatorColumnAnnotation getResourceColumn() {
        return (DiscriminatorColumnAnnotation)this.persistenceResource.getNonNullSupportingAnnotation("javax.persistence.DiscriminatorColumn");
    }

    public DiscriminatorColumnAnnotation getResourceColumnOrNull() {
        return (DiscriminatorColumnAnnotation)this.persistenceResource.getSupportingAnnotation("javax.persistence.DiscriminatorColumn");
    }

    @Override
    public boolean isResourceSpecified() {
        return this.getResourceColumnOrNull() != null;
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.getSpecifiedDiscriminatorType() == null ? this.getDefaultDiscriminatorType() : this.getSpecifiedDiscriminatorType();
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.getResourceColumn().setDiscriminatorType(DiscriminatorType.toJavaResourceModel(newSpecifiedDiscriminatorType));
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength().intValue();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int defaultLength) {
        int old = this.defaultLength;
        this.defaultLength = defaultLength;
        this.firePropertyChanged("defaultLength", old, defaultLength);
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.getResourceColumn().setLength(newSpecifiedLength);
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    protected String getTableName() {
        return this.getJavaEntity().getPrimaryTableName();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceColumn().getTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public void update(JavaResourcePersistentMember persistentResource) {
        this.persistenceResource = persistentResource;
        this.update(this.getResourceColumn());
    }

    @Override
    public void update(DiscriminatorColumnAnnotation discriminatorColumn) {
        this.setSpecifiedName_(discriminatorColumn.getName());
        this.setColumnDefinition_(discriminatorColumn.getColumnDefinition());
        this.setSpecifiedDiscriminatorType_(this.getResourceDiscriminatorType(discriminatorColumn));
        this.setSpecifiedLength_(this.getResourceLength(discriminatorColumn));
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultLength(this.buildDefaultLength());
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
    }

    protected DiscriminatorType getResourceDiscriminatorType(DiscriminatorColumnAnnotation discriminatorColumn) {
        return DiscriminatorType.fromJavaResourceModel(discriminatorColumn.getDiscriminatorType());
    }

    protected Integer getResourceLength(DiscriminatorColumnAnnotation discriminatorColumn) {
        return discriminatorColumn.getLength();
    }

    @Override
    public JavaEntity getParent() {
        return (JavaEntity)super.getParent();
    }

    protected int buildDefaultLength() {
        return this.getOwner().getDefaultLength();
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return this.getOwner().getDefaultDiscriminatorType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.connectionProfileIsActive() && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "DISCRIMINATOR_COLUMN_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
        }
    }
}

