/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Column;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinColumn
extends AbstractJavaBaseColumn<JoinColumnAnnotation>
implements JavaJoinColumn {
    protected String specifiedReferencedColumnName;
    protected String defaultReferencedColumnName;
    protected JoinColumnAnnotation joinColumn;

    public GenericJavaJoinColumn(JavaJpaContextNode parent, JavaJoinColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    protected JoinColumnAnnotation getResourceColumn() {
        return this.joinColumn;
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName == null ? this.defaultReferencedColumnName : this.specifiedReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.joinColumn.setReferencedColumnName(newSpecifiedReferencedColumnName);
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    protected void setSpecifiedReferencedColumnName_(String newSpecifiedReferencedColumnName) {
        String oldSpecifiedReferencedColumnName = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = newSpecifiedReferencedColumnName;
        this.firePropertyChanged("specifiedReferencedColumnName", oldSpecifiedReferencedColumnName, newSpecifiedReferencedColumnName);
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String newDefaultReferencedColumnName) {
        String oldDefaultReferencedColumnName = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = newDefaultReferencedColumnName;
        this.firePropertyChanged("defaultReferencedColumnName", oldDefaultReferencedColumnName, newDefaultReferencedColumnName);
    }

    @Override
    public JavaJoinColumn.Owner getOwner() {
        return (JavaJoinColumn.Owner)super.getOwner();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return this.getOwner().getReferencedColumnDbTable();
    }

    @Override
    public Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean tableIsAllowed() {
        return this.getOwner().tableIsAllowed();
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.getResourceColumn().referencedColumnNameTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.javaCandidateReferencedColumnNames(filter);
        }
        return null;
    }

    private Iterator<String> javaCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateReferencedColumnNames(filter));
    }

    private Iterator<String> candidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateReferencedColumnNames(), filter);
    }

    private Iterator<String> candidateReferencedColumnNames() {
        Table table = this.getOwner().getReferencedColumnDbTable();
        return table != null ? table.sortedColumnIdentifiers() : EmptyIterator.instance();
    }

    @Override
    public boolean isReferencedColumnResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getResourceColumn().getReferencedColumnNameTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return null;
    }

    @Override
    public void initialize(JoinColumnAnnotation annotation) {
        this.joinColumn = annotation;
        super.initialize(annotation);
        this.specifiedReferencedColumnName = annotation.getReferencedColumnName();
        this.defaultReferencedColumnName = this.buildDefaultReferencedColumnName();
    }

    @Override
    public void update(JoinColumnAnnotation annotation) {
        this.joinColumn = annotation;
        super.update(annotation);
        this.setSpecifiedReferencedColumnName_(annotation.getReferencedColumnName());
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    protected String buildDefaultName() {
        return MappingTools.buildJoinColumnDefaultName(this);
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName(this.getOwner());
    }

    @Override
    protected String defaultTable() {
        RelationshipMapping relationshipMapping = this.getOwner().getRelationshipMapping();
        if (relationshipMapping == null) {
            return null;
        }
        return super.defaultTable();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateName(messages, astRoot);
        this.validateReferencedColumnName(messages, astRoot);
    }

    protected void validateName(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.isResolved() && this.getDbTable() != null) {
            if (this.getName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange(astRoot)));
            } else if (this.getOwner().joinColumnsSize() > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", this, this.getNameTextRange(astRoot)));
            }
        }
    }

    protected void validateReferencedColumnName(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.isReferencedColumnResolved() && this.getReferencedColumnDbTable() != null) {
            if (this.getReferencedColumnName() != null) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{this.getReferencedColumnName(), this.getName()}, this, this.getReferencedColumnNameTextRange(astRoot)));
            } else if (this.getOwner().joinColumnsSize() > 1) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", this, this.getNameTextRange(astRoot)));
            }
        }
    }
}

