/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaUniqueConstraint
extends AbstractJavaJpaContextNode
implements JavaUniqueConstraint {
    protected final List<String> columnNames;
    protected UniqueConstraintAnnotation resourceUniqueConstraint;
    protected UniqueConstraint.Owner owner;

    public GenericJavaUniqueConstraint(JavaJpaContextNode parent, UniqueConstraint.Owner owner) {
        super(parent);
        this.owner = owner;
        this.columnNames = new ArrayList<String>();
    }

    public UniqueConstraint.Owner getOwner() {
        return this.owner;
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.resourceUniqueConstraint.addColumnName(index, columnName);
        this.fireItemAdded("columnNames", index, columnName);
    }

    protected void addColumnName_(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.fireItemAdded("columnNames", index, columnName);
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.resourceUniqueConstraint.removeColumnName(index);
        this.fireItemRemoved("columnNames", index, removedColumnName);
    }

    protected void removeColumnName_(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.fireItemRemoved("columnNames", index, removedColumnName);
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.resourceUniqueConstraint.moveColumnName(targetIndex, sourceIndex);
        this.fireItemMoved("columnNames", targetIndex, sourceIndex);
    }

    @Override
    public void initialize(UniqueConstraintAnnotation uca) {
        this.resourceUniqueConstraint = uca;
        this.initializeColumnNames(uca);
    }

    protected void initializeColumnNames(UniqueConstraintAnnotation uca) {
        ListIterator<String> annotationColumnNames = uca.columnNames();
        for (String resourceColumnName : CollectionTools.iterable(annotationColumnNames)) {
            this.columnNames.add(resourceColumnName);
        }
    }

    @Override
    public void update(UniqueConstraintAnnotation uca) {
        this.resourceUniqueConstraint = uca;
        this.updateColumnNames(uca);
    }

    protected void updateColumnNames(UniqueConstraintAnnotation uca) {
        ListIterator<String> annotationColumnNames = uca.columnNames();
        int index = 0;
        for (String resourceColumnName : CollectionTools.iterable(annotationColumnNames)) {
            if (this.columnNamesSize() > index) {
                if (this.columnNames.get(index) != resourceColumnName) {
                    this.addColumnName_(index, resourceColumnName);
                }
            } else {
                this.addColumnName_(index, resourceColumnName);
            }
            ++index;
        }
        while (index < this.columnNamesSize()) {
            this.removeColumnName_(index);
        }
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceUniqueConstraint.getTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.columnNames);
    }

    @Override
    public Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.columnNamesTouches(pos, astRoot)) {
            return this.javaCandidateColumnNames(filter);
        }
        return null;
    }

    private boolean columnNamesTouches(int pos, CompilationUnit astRoot) {
        return this.resourceUniqueConstraint.columnNamesTouches(pos, astRoot);
    }

    private Iterator<String> javaCandidateColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateColumnNames(filter));
    }

    private Iterator<String> candidateColumnNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateColumnNames(), filter);
    }

    private Iterator<String> candidateColumnNames() {
        return this.getOwner().candidateUniqueConstraintColumnNames();
    }
}

