/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.JoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;

public abstract class AbstractOrmRelationshipReference
extends AbstractXmlContextNode
implements OrmRelationshipReference {
    protected XmlRelationshipMapping resourceMapping;
    protected JoiningStrategy cachedPredominantJoiningStrategy;

    protected AbstractOrmRelationshipReference(OrmRelationshipMapping parent, XmlRelationshipMapping resourceMapping) {
        super(parent);
        this.resourceMapping = resourceMapping;
        this.initializeJoiningStrategies();
    }

    protected abstract void initializeJoiningStrategies();

    public void initializeFromOwnableRelationshipReference(OrmOwnableRelationshipReference oldRelationshipReference) {
    }

    public void initializeFromJoinColumnEnabledRelationshipReference(OrmJoinColumnEnabledRelationshipReference oldRelationshipReference) {
    }

    public void initializeFromJoinTableEnabledRelationshipReference(OrmJoinTableEnabledRelationshipReference oldRelationshipReference) {
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return (OrmRelationshipMapping)this.getParent();
    }

    public JoiningStrategy getPredominantJoiningStrategy() {
        if (this.cachedPredominantJoiningStrategy == null) {
            this.cachedPredominantJoiningStrategy = this.calculatePredominantJoiningStrategy();
        }
        return this.cachedPredominantJoiningStrategy;
    }

    protected void setPredominantJoiningStrategy(JoiningStrategy newJoiningStrategy) {
        JoiningStrategy oldJoiningStrategy = this.cachedPredominantJoiningStrategy;
        this.cachedPredominantJoiningStrategy = newJoiningStrategy;
        this.firePropertyChanged("predominantStrategy", oldJoiningStrategy, newJoiningStrategy);
    }

    public void update() {
        this.updateJoiningStrategies();
        this.setPredominantJoiningStrategy(this.calculatePredominantJoiningStrategy());
    }

    protected abstract void updateJoiningStrategies();

    protected abstract JoiningStrategy calculatePredominantJoiningStrategy();

    public TextRange getValidationTextRange() {
        return this.getRelationshipMapping().getValidationTextRange();
    }
}

