/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlJoinColumnsMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmJoinColumnJoiningStrategy
extends AbstractXmlContextNode
implements OrmJoinColumnJoiningStrategy {
    protected XmlJoinColumnsMapping resource;
    protected OrmJoinColumn defaultJoinColumn;
    protected final List<OrmJoinColumn> specifiedJoinColumns;

    public GenericOrmJoinColumnJoiningStrategy(OrmJoinColumnEnabledRelationshipReference parent, XmlJoinColumnsMapping resource) {
        super(parent);
        this.resource = resource;
        this.specifiedJoinColumns = new ArrayList<OrmJoinColumn>();
        this.initializeSpecifiedJoinColumns();
        this.initializeDefaultJoinColumn();
    }

    protected void initializeSpecifiedJoinColumns() {
        if (this.resource != null) {
            for (XmlJoinColumn resourceJoinColumn : this.resource.getJoinColumns()) {
                this.specifiedJoinColumns.add(this.buildJoinColumn(resourceJoinColumn));
            }
        }
    }

    protected void initializeDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn resourceJoinColumn) {
        return this.getJpaFactory().buildOrmJoinColumn(this, new JoinColumnOwner(), resourceJoinColumn);
    }

    @Override
    public OrmJoinColumnEnabledRelationshipReference getParent() {
        return (OrmJoinColumnEnabledRelationshipReference)super.getParent();
    }

    @Override
    public OrmJoinColumnEnabledRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getRelationshipReference().getRelationshipMapping();
    }

    @Override
    public void addStrategy() {
        if (this.specifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn(0);
        }
    }

    @Override
    public void removeStrategy() {
        for (JoinColumn each : CollectionTools.iterable(this.specifiedJoinColumns())) {
            this.removeSpecifiedJoinColumn(each);
        }
    }

    @Override
    public ListIterator<OrmJoinColumn> joinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumns() : this.defaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.defaultJoinColumnsSize();
    }

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterator<OrmJoinColumn> defaultJoinColumns() {
        if (this.defaultJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    @Override
    public ListIterator<OrmJoinColumn> specifiedJoinColumns() {
        return new CloneListIterator(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return !this.specifiedJoinColumns.isEmpty();
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        OrmJoinColumn oldDefaultJoinColumn = this.defaultJoinColumn;
        if (oldDefaultJoinColumn != null) {
            this.defaultJoinColumn = null;
        }
        XmlJoinColumnImpl resourceJoinColumn = OrmFactory.eINSTANCE.createXmlJoinColumnImpl();
        OrmJoinColumn contextJoinColumn = this.buildJoinColumn(resourceJoinColumn);
        this.specifiedJoinColumns.add(index, contextJoinColumn);
        this.resource.getJoinColumns().add(index, (Object)resourceJoinColumn);
        this.fireItemAdded("specifiedJoinColumns", index, contextJoinColumn);
        if (oldDefaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", oldDefaultJoinColumn, null);
        }
        return contextJoinColumn;
    }

    protected void addSpecifiedJoinColumn(int index, OrmJoinColumn joinColumn) {
        this.addItemToList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected void addSpecifiedJoinColumn(OrmJoinColumn joinColumn) {
        this.addSpecifiedJoinColumn(this.specifiedJoinColumns.size(), joinColumn);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        OrmJoinColumn removedJoinColumn = this.specifiedJoinColumns.remove(index);
        if (this.specifiedJoinColumns.isEmpty()) {
            this.defaultJoinColumn = this.buildJoinColumn(null);
        }
        this.resource.getJoinColumns().remove(index);
        this.fireItemRemoved("specifiedJoinColumns", index, removedJoinColumn);
        if (this.defaultJoinColumn != null) {
            this.firePropertyChanged("defaultJoinColumn", null, this.defaultJoinColumn);
        }
    }

    protected void removeSpecifiedJoinColumn_(OrmJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.resource.getJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public void update() {
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    protected void updateSpecifiedJoinColumns() {
        CloneIterator xmlJoinColumns = new CloneIterator(this.resource.getJoinColumns());
        ListIterator<OrmJoinColumn> contextJoinColumns = this.specifiedJoinColumns();
        while (contextJoinColumns.hasNext()) {
            OrmJoinColumn contextJoinColumn = (OrmJoinColumn)contextJoinColumns.next();
            if (xmlJoinColumns.hasNext()) {
                contextJoinColumn.update((XmlJoinColumn)xmlJoinColumns.next());
                continue;
            }
            this.removeSpecifiedJoinColumn_(contextJoinColumn);
        }
        while (xmlJoinColumns.hasNext()) {
            this.addSpecifiedJoinColumn(this.buildJoinColumn((XmlJoinColumn)xmlJoinColumns.next()));
        }
    }

    protected void updateDefaultJoinColumn() {
        if (this.mayHaveDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update(null);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean mayHaveDefaultJoinColumn() {
        return this.getRelationshipReference().mayHaveDefaultJoinColumn() && !this.hasSpecifiedJoinColumns();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.getRelationshipMapping().shouldValidateAgainstDatabase()) {
            ListIterator<OrmJoinColumn> stream = this.joinColumns();
            while (stream.hasNext()) {
                this.validateJoinColumn((OrmJoinColumn)stream.next(), messages);
            }
        }
    }

    protected void validateJoinColumn(OrmJoinColumn joinColumn, List<IMessage> messages) {
        if (this.getRelationshipMapping().getTypeMapping().tableNameIsInvalid(joinColumn.getTable())) {
            if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{this.getRelationshipMapping().getName(), joinColumn.getTable(), joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange()));
            } else {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_TABLE", new String[]{joinColumn.getTable(), joinColumn.getName()}, joinColumn, joinColumn.getTableTextRange()));
            }
            return;
        }
        this.validateJoinColumnName(joinColumn, messages);
        this.validationJoinColumnReferencedColumnName(joinColumn, messages);
    }

    protected void validateJoinColumnName(OrmJoinColumn joinColumn, List<IMessage> messages) {
        if (!joinColumn.isResolved() && joinColumn.getDbTable() != null) {
            if (joinColumn.getName() != null) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{this.getRelationshipMapping().getName(), joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getName()}, joinColumn, joinColumn.getNameTextRange()));
                }
            } else if (joinColumn.getOwner().joinColumnsSize() > 1) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", new String[]{this.getRelationshipMapping().getName()}, joinColumn, joinColumn.getNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", joinColumn, joinColumn.getNameTextRange()));
                }
            }
        }
    }

    protected void validationJoinColumnReferencedColumnName(OrmJoinColumn joinColumn, List<IMessage> messages) {
        if (!joinColumn.isReferencedColumnResolved() && joinColumn.getReferencedColumnDbTable() != null) {
            if (joinColumn.getReferencedColumnName() != null) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{this.getRelationshipMapping().getName(), joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME", new String[]{joinColumn.getReferencedColumnName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
                }
            } else if (joinColumn.getOwner().joinColumnsSize() > 1) {
                if (this.getRelationshipMapping().getPersistentAttribute().isVirtual()) {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", new String[]{this.getRelationshipMapping().getName(), joinColumn.getName()}, joinColumn, joinColumn.getReferencedColumnNameTextRange()));
                } else {
                    messages.add(DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_UNRESOLVED_NAME_MULTIPLE_JOIN_COLUMNS", joinColumn, joinColumn.getReferencedColumnNameTextRange()));
                }
            }
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationshipReference().getValidationTextRange();
    }

    public class JoinColumnOwner
    implements OrmJoinColumn.Owner {
        public String getDefaultTableName() {
            return this.getTypeMapping().getPrimaryTableName();
        }

        public Entity getTargetEntity() {
            return this.getRelationshipMapping().getResolvedTargetEntity();
        }

        public String getAttributeName() {
            return this.getRelationshipMapping().getName();
        }

        public RelationshipMapping getRelationshipMapping() {
            return GenericOrmJoinColumnJoiningStrategy.this.getRelationshipMapping();
        }

        public boolean tableNameIsInvalid(String tableName) {
            return this.getTypeMapping().tableNameIsInvalid(tableName);
        }

        public boolean tableIsAllowed() {
            return true;
        }

        public TypeMapping getTypeMapping() {
            return this.getRelationshipMapping().getTypeMapping();
        }

        public Table getDbTable(String tableName) {
            return this.getTypeMapping().getDbTable(tableName);
        }

        public Table getReferencedColumnDbTable() {
            Entity targetEntity = this.getTargetEntity();
            return targetEntity == null ? null : targetEntity.getPrimaryDbTable();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmJoinColumnJoiningStrategy.this.defaultJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            return null;
        }

        public int joinColumnsSize() {
            return GenericOrmJoinColumnJoiningStrategy.this.joinColumnsSize();
        }

        public TextRange getValidationTextRange() {
            return GenericOrmJoinColumnJoiningStrategy.this.getValidationTextRange();
        }
    }
}

