/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmUniqueConstraint
extends AbstractXmlContextNode
implements OrmUniqueConstraint {
    protected final List<String> columnNames;
    protected XmlUniqueConstraint resourceUniqueConstraint;
    protected UniqueConstraint.Owner owner;

    public GenericOrmUniqueConstraint(XmlContextNode parent, UniqueConstraint.Owner owner, XmlUniqueConstraint resourceUniqueConstraint) {
        super(parent);
        this.owner = owner;
        this.columnNames = new ArrayList<String>();
        this.initialize(resourceUniqueConstraint);
    }

    @Override
    public ListIterator<String> columnNames() {
        return new CloneListIterator(this.columnNames);
    }

    @Override
    public int columnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.resourceUniqueConstraint.getColumnNames().add(index, (Object)columnName);
        this.fireItemAdded("columnNames", index, columnName);
    }

    protected void addColumnName_(int index, String columnName) {
        this.addItemToList(index, columnName, this.columnNames, "columnNames");
    }

    protected void addColumnName_(String columnName) {
        this.addItemToList(columnName, this.columnNames, "columnNames");
    }

    protected void setColumnName_(int index, String columnName) {
        this.setItemInList(index, columnName, this.columnNames, "columnNames");
    }

    @Override
    public void removeColumnName(String columnName) {
        this.removeColumnName(this.columnNames.indexOf(columnName));
    }

    @Override
    public void removeColumnName(int index) {
        String removedColumnName = this.columnNames.remove(index);
        this.resourceUniqueConstraint.getColumnNames().remove(index);
        this.fireItemRemoved("columnNames", index, removedColumnName);
    }

    protected void removeColumnName_(int index) {
        this.removeItemFromList(index, this.columnNames, "columnNames");
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.resourceUniqueConstraint.getColumnNames().move(targetIndex, sourceIndex);
        this.fireItemMoved("columnNames", targetIndex, sourceIndex);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.resourceUniqueConstraint.getValidationTextRange();
    }

    protected void initialize(XmlUniqueConstraint xmlUniqueConstraint) {
        this.resourceUniqueConstraint = xmlUniqueConstraint;
        this.initializeColumnNames();
    }

    protected void initializeColumnNames() {
        for (String annotationColumnName : this.resourceUniqueConstraint.getColumnNames()) {
            this.columnNames.add(annotationColumnName);
        }
    }

    @Override
    public void update(XmlUniqueConstraint xmlUniqueConstraint) {
        this.resourceUniqueConstraint = xmlUniqueConstraint;
        this.updateColumnNames();
    }

    protected void updateColumnNames() {
        int index = 0;
        for (String xmlColumnName : this.resourceUniqueConstraint.getColumnNames()) {
            if (this.columnNames.size() > index) {
                if (!this.columnNames.get(index).equals(xmlColumnName)) {
                    this.setColumnName_(index, xmlColumnName);
                }
            } else {
                this.addColumnName_(xmlColumnName);
            }
            ++index;
        }
        while (index < this.columnNames.size()) {
            this.removeColumnName_(index);
        }
    }
}

