/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.EntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.JpaFactory;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.JpaPlatformProvider;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.JpaResourceModelProvider;
import org.eclipse.jpt.core.JpaValidation;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.MappingFileProvider;
import org.eclipse.jpt.core.context.java.DefaultJavaAttributeMappingProvider;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingProvider;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.java.JavaTypeMappingProvider;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeMappingProvider;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMappingProvider;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.context.java.JavaNullAttributeMappingProvider;
import org.eclipse.jpt.core.internal.context.orm.OrmNullAttributeMappingProvider;
import org.eclipse.jpt.core.internal.platform.GenericEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.core.internal.utility.PlatformTools;
import org.eclipse.jpt.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.DatabaseFinder;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaPlatform
implements JpaPlatform {
    private final String id;
    private final JpaFactory jpaFactory;
    private final JpaAnnotationProvider annotationProvider;
    private final JpaPlatformProvider[] platformProviders;
    private final JpaValidation jpaValidation;

    public GenericJpaPlatform(String id, JpaFactory jpaFactory, JpaAnnotationProvider jpaAnnotationProvider, JpaValidation jpaValidation, JpaPlatformProvider ... platformProviders) {
        this.id = id;
        this.jpaFactory = jpaFactory;
        this.annotationProvider = jpaAnnotationProvider;
        this.jpaValidation = jpaValidation;
        this.platformProviders = platformProviders;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JpaFactory getJpaFactory() {
        return this.jpaFactory;
    }

    protected ListIterator<JpaPlatformProvider> platformProviders() {
        return new ArrayListIterator((Object[])this.platformProviders);
    }

    @Override
    public JpaFile buildJpaFile(JpaProject jpaProject, IFile file) {
        IContentType contentType = PlatformTools.getContentType(file);
        return contentType == null ? null : this.buildJpaFile(jpaProject, file, contentType);
    }

    protected JpaFile buildJpaFile(JpaProject jpaProject, IFile file, IContentType contentType) {
        JpaResourceModel resourceModel = this.buildResourceModel(jpaProject, file, contentType);
        return resourceModel == null ? null : this.jpaFactory.buildJpaFile(jpaProject, file, contentType, resourceModel);
    }

    protected JpaResourceModel buildResourceModel(JpaProject jpaProject, IFile file, IContentType contentType) {
        JpaResourceModelProvider provider = this.getResourceModelProvider(contentType);
        return provider == null ? null : provider.buildResourceModel(jpaProject, file);
    }

    protected JpaResourceModelProvider getResourceModelProvider(IContentType contentType) {
        for (JpaResourceModelProvider provider : CollectionTools.iterable(this.resourceModelProviders())) {
            if (!contentType.equals(provider.getContentType())) continue;
            return provider;
        }
        return null;
    }

    protected ListIterator<JpaResourceModelProvider> resourceModelProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<JpaResourceModelProvider>>(this.platformProviders()){

            protected ListIterator<JpaResourceModelProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.resourceModelProviders();
            }
        });
    }

    @Override
    public JpaAnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public AnnotationEditFormatter getAnnotationEditFormatter() {
        return DefaultAnnotationEditFormatter.instance();
    }

    @Override
    public JavaTypeMapping buildJavaTypeMappingFromMappingKey(String key, JavaPersistentType type) {
        return this.getJavaTypeMappingProviderForMappingKey(key).buildMapping(type, this.jpaFactory);
    }

    protected JavaTypeMappingProvider getJavaTypeMappingProviderForMappingKey(String key) {
        for (JavaTypeMappingProvider provider : CollectionTools.iterable(this.javaTypeMappingProviders())) {
            if (provider.getKey() != key) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + key);
    }

    protected ListIterator<JavaTypeMappingProvider> javaTypeMappingProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<JavaTypeMappingProvider>>(this.platformProviders()){

            protected ListIterator<JavaTypeMappingProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.javaTypeMappingProviders();
            }
        });
    }

    @Override
    public JavaTypeMapping buildJavaTypeMappingFromAnnotation(String annotationName, JavaPersistentType type) {
        return this.getJavaTypeMappingProviderForAnnotation(annotationName).buildMapping(type, this.jpaFactory);
    }

    protected JavaTypeMappingProvider getJavaTypeMappingProviderForAnnotation(String annotationName) {
        for (JavaTypeMappingProvider provider : CollectionTools.iterable(this.javaTypeMappingProviders())) {
            if (provider.getAnnotationName() != annotationName) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal annotation name: " + annotationName);
    }

    @Override
    public JavaAttributeMapping buildJavaAttributeMappingFromMappingKey(String key, JavaPersistentAttribute attribute) {
        return this.getJavaAttributeMappingProviderForMappingKey(key).buildMapping(attribute, this.jpaFactory);
    }

    protected JavaAttributeMappingProvider getJavaAttributeMappingProviderForMappingKey(String key) {
        for (JavaAttributeMappingProvider provider : CollectionTools.iterable(this.javaAttributeMappingProviders())) {
            if (provider.getKey() != key) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal attribute mapping key: " + key);
    }

    protected ListIterator<JavaAttributeMappingProvider> javaAttributeMappingProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<JavaAttributeMappingProvider>>(this.platformProviders()){

            protected ListIterator<JavaAttributeMappingProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.javaAttributeMappingProviders();
            }
        });
    }

    @Override
    public JavaAttributeMapping buildJavaAttributeMappingFromAnnotation(String annotationName, JavaPersistentAttribute attribute) {
        return this.getJavaAttributeMappingProviderForAnnotation(annotationName).buildMapping(attribute, this.jpaFactory);
    }

    protected JavaAttributeMappingProvider getJavaAttributeMappingProviderForAnnotation(String annotationName) {
        for (JavaAttributeMappingProvider provider : CollectionTools.iterable(this.javaAttributeMappingProviders())) {
            if (provider.getAnnotationName() != annotationName) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal annotation name: " + annotationName);
    }

    @Override
    public JavaAttributeMapping buildDefaultJavaAttributeMapping(JavaPersistentAttribute attribute) {
        return this.getDefaultJavaAttributeMappingProvider(attribute).buildMapping(attribute, this.jpaFactory);
    }

    @Override
    public String getDefaultJavaAttributeMappingKey(JavaPersistentAttribute attribute) {
        return this.getDefaultJavaAttributeMappingProvider(attribute).getKey();
    }

    protected ListIterator<DefaultJavaAttributeMappingProvider> defaultJavaAttributeMappingProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<DefaultJavaAttributeMappingProvider>>(this.platformProviders()){

            protected ListIterator<DefaultJavaAttributeMappingProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.defaultJavaAttributeMappingProviders();
            }
        });
    }

    protected JavaAttributeMappingProvider getDefaultJavaAttributeMappingProvider(JavaPersistentAttribute attribute) {
        for (DefaultJavaAttributeMappingProvider provider : CollectionTools.iterable(this.defaultJavaAttributeMappingProviders())) {
            if (!provider.defaultApplies(attribute)) continue;
            return provider;
        }
        return this.getNullAttributeMappingProvider();
    }

    protected JavaAttributeMappingProvider getNullAttributeMappingProvider() {
        return JavaNullAttributeMappingProvider.instance();
    }

    @Override
    public MappingFile buildMappingFile(MappingFileRef parent, JpaXmlResource resource) {
        return this.getMappingFileProviderForResourceType(resource.getContentType()).buildMappingFile(parent, resource, this.jpaFactory);
    }

    protected MappingFileProvider getMappingFileProviderForResourceType(IContentType contentType) {
        for (MappingFileProvider provider : CollectionTools.iterable(this.mappingFileProviders())) {
            if (!provider.getContentType().equals(contentType)) continue;
            return provider;
        }
        throw new IllegalArgumentException("Illegal mapping file content type: " + contentType);
    }

    protected ListIterator<MappingFileProvider> mappingFileProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<MappingFileProvider>>(this.platformProviders()){

            protected ListIterator<MappingFileProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.mappingFileProviders();
            }
        });
    }

    @Override
    public XmlTypeMapping buildOrmResourceTypeMapping(String key, IContentType contentType) {
        return this.getOrmTypeMappingProviderForMappingKey(contentType, key).buildResourceMapping();
    }

    @Override
    public OrmTypeMapping buildOrmTypeMappingFromMappingKey(OrmPersistentType type, XmlTypeMapping resourceMapping) {
        return this.getOrmTypeMappingProviderForMappingKey(type.getContentType(), resourceMapping.getMappingKey()).buildMapping(type, resourceMapping, this.jpaFactory);
    }

    protected OrmTypeMappingProvider getOrmTypeMappingProviderForMappingKey(IContentType contentType, String key) {
        for (OrmTypeMappingProvider provider : CollectionTools.iterable(this.ormTypeMappingProviders(key))) {
            if (!provider.getContentType().isKindOf(contentType)) continue;
            return provider;
        }
        if (contentType.getBaseType() != null) {
            return this.getOrmTypeMappingProviderForMappingKey(contentType.getBaseType(), key);
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + key);
    }

    protected Iterator<OrmTypeMappingProvider> ormTypeMappingProviders(final String key) {
        return new FilteringIterator<OrmTypeMappingProvider, OrmTypeMappingProvider>(this.ormTypeMappingProviders()){

            protected boolean accept(OrmTypeMappingProvider o) {
                return o.getKey() == key;
            }
        };
    }

    protected ListIterator<OrmTypeMappingProvider> ormTypeMappingProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<OrmTypeMappingProvider>>(this.platformProviders()){

            protected ListIterator<OrmTypeMappingProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.ormTypeMappingProviders();
            }
        });
    }

    @Override
    public XmlAttributeMapping buildOrmResourceAttributeMapping(String key, IContentType contentType) {
        return this.getOrmAttributeMappingProviderForMappingKey(contentType, key).buildResourceMapping();
    }

    @Override
    public OrmAttributeMapping buildOrmAttributeMappingFromMappingKey(OrmPersistentAttribute attribute, XmlAttributeMapping resourceMapping) {
        return this.getOrmAttributeMappingProviderForMappingKey(attribute.getContentType(), resourceMapping.getMappingKey()).buildMapping(attribute, resourceMapping, this.jpaFactory);
    }

    @Override
    public XmlAttributeMapping buildVirtualOrmResourceMappingFromMappingKey(String key, OrmTypeMapping ormTypeMapping, JavaAttributeMapping javaAttributeMapping) {
        return this.getOrmAttributeMappingProviderForMappingKey(ormTypeMapping.getContentType(), key).buildVirtualResourceMapping(ormTypeMapping, javaAttributeMapping, this.jpaFactory);
    }

    protected OrmAttributeMappingProvider getOrmAttributeMappingProviderForMappingKey(IContentType contentType, String key) {
        for (OrmAttributeMappingProvider provider : CollectionTools.iterable(this.ormAttributeMappingProviders(key))) {
            if (!provider.getContentType().isKindOf(contentType)) continue;
            return provider;
        }
        if (contentType.getBaseType() != null) {
            return this.getOrmAttributeMappingProviderForMappingKey(contentType.getBaseType(), key);
        }
        return OrmNullAttributeMappingProvider.instance();
    }

    protected Iterator<OrmAttributeMappingProvider> ormAttributeMappingProviders(final String key) {
        return new FilteringIterator<OrmAttributeMappingProvider, OrmAttributeMappingProvider>(this.ormAttributeMappingProviders()){

            protected boolean accept(OrmAttributeMappingProvider o) {
                return o.getKey() == key;
            }
        };
    }

    protected ListIterator<OrmAttributeMappingProvider> ormAttributeMappingProviders() {
        return new CompositeListIterator((ListIterator)new TransformationListIterator<JpaPlatformProvider, ListIterator<OrmAttributeMappingProvider>>(this.platformProviders()){

            protected ListIterator<OrmAttributeMappingProvider> transform(JpaPlatformProvider platformProvider) {
                return platformProvider.ormAttributeMappingProviders();
            }
        });
    }

    @Override
    public ConnectionProfileFactory getConnectionProfileFactory() {
        return JptDbPlugin.instance().getConnectionProfileFactory();
    }

    @Override
    public EntityGeneratorDatabaseAnnotationNameBuilder getEntityGeneratorDatabaseAnnotationNameBuilder() {
        return GenericEntityGeneratorDatabaseAnnotationNameBuilder.instance();
    }

    @Override
    public DatabaseFinder getDatabaseFinder() {
        return DatabaseFinder.Default.instance();
    }

    @Override
    public JpaValidation getJpaValidation() {
        return this.jpaValidation;
    }
}

