/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.resource.java.source.SourceNode;
import org.eclipse.jpt.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceAnnotation<M extends Member>
extends SourceNode
implements Annotation {
    protected final M member;
    protected final DeclarationAnnotationAdapter daa;
    protected final AnnotationAdapter annotationAdapter;

    protected SourceAnnotation(JavaResourceNode parent, M member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, new MemberAnnotationAdapter((Member)member, daa));
    }

    protected SourceAnnotation(JavaResourceNode parent, M member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent);
        this.member = member;
        this.daa = daa;
        this.annotationAdapter = annotationAdapter;
    }

    @Override
    public TextRange getTextRange(CompilationUnit astRoot) {
        return this.getAnnotationTextRange(astRoot);
    }

    @Override
    public org.eclipse.jdt.core.dom.Annotation getJdtAnnotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    @Override
    public void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    @Override
    public void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getJdtAnnotation(astRoot));
    }

    protected TextRange getElementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.getElementTextRange(this.getAnnotationElementTextRange(elementAdapter, astRoot), astRoot);
    }

    protected TextRange getElementTextRange(TextRange elementTextRange, CompilationUnit astRoot) {
        return elementTextRange != null ? elementTextRange : this.getAnnotationTextRange(astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.textRangeTouches(this.getAnnotationElementTextRange(elementAdapter, astRoot), pos);
    }

    protected boolean textRangeTouches(TextRange textRange, int pos) {
        return textRange != null && textRange.touches(pos);
    }

    protected TextRange getAnnotationElementTextRange(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return this.getTextRange((ASTNode)this.getAnnotationElementExpression(adapter, astRoot));
    }

    protected Expression getAnnotationElementExpression(DeclarationAnnotationElementAdapter<?> adapter, CompilationUnit astRoot) {
        return adapter.getExpression(this.member.getModifiedDeclaration(astRoot));
    }

    protected TextRange getTextRange(ASTNode astNode) {
        return astNode == null ? null : new ASTNodeTextRange(astNode);
    }
}

