/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.NullAttributeOverrideColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.NestableColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public final class SourceAttributeOverrideAnnotation
extends SourceOverrideAnnotation
implements NestableAttributeOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverride");
    private final MemberAnnotationAdapter columnAdapter;
    private NestableColumnAnnotation column;

    public SourceAttributeOverrideAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.columnAdapter = new MemberAnnotationAdapter(this.member, SourceColumnAnnotation.buildAttributeOverrideAnnotationAdapter(this.daa));
    }

    public String getAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = SourceColumnAnnotation.createAttributeOverrideColumn(this, this.member, this.daa);
            this.column.initialize(astRoot);
        }
    }

    public void update(CompilationUnit astRoot) {
        super.update(astRoot);
        this.updateColumn(astRoot);
    }

    String getNameElementName() {
        return "name";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public NestableColumnAnnotation addColumn() {
        NestableColumnAnnotation col = SourceColumnAnnotation.createAttributeOverrideColumn(this, this.member, this.daa);
        col.newAnnotation();
        this.setColumn(col);
        return col;
    }

    public void removeColumn() {
        this.column.removeAnnotation();
        this.setColumn(null);
    }

    private void setColumn(NestableColumnAnnotation column) {
        NestableColumnAnnotation old = this.column;
        this.column = column;
        this.firePropertyChanged("column", old, column);
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : new NullAttributeOverrideColumnAnnotation(this);
    }

    private void updateColumn(CompilationUnit astRoot) {
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.setColumn(null);
        } else if (this.column == null) {
            NestableColumnAnnotation col = SourceColumnAnnotation.createAttributeOverrideColumn(this, this.member, this.daa);
            col.initialize(astRoot);
            this.setColumn(col);
        } else {
            this.column.update(astRoot);
        }
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        AttributeOverrideAnnotation oldOverride = (AttributeOverrideAnnotation)((Object)oldAnnotation);
        ColumnAnnotation oldColumn = oldOverride.getColumn();
        if (oldColumn != null) {
            NestableColumnAnnotation newColumn = this.addColumn();
            newColumn.initializeFrom((NestableAnnotation)((Object)oldColumn));
        }
    }

    public static SourceAttributeOverrideAnnotation createAttributeOverride(JavaResourceNode parent, Member member) {
        return new SourceAttributeOverrideAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceAttributeOverrideAnnotation createNestedAttributeOverride(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceAttributeOverrideAnnotation.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceAttributeOverrideAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(attributeOverridesAdapter, index, "javax.persistence.AttributeOverride");
    }
}

