/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.TemporalAnnotation;
import org.eclipse.jpt.core.resource.java.TemporalType;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceTemporalAnnotation
extends SourceAnnotation<Attribute>
implements TemporalAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Temporal");
    private static final DeclarationAnnotationElementAdapter<String> VALUE_ADAPTER = SourceTemporalAnnotation.buildValueAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private TemporalType value;

    public SourceTemporalAnnotation(JavaResourceNode parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.valueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, VALUE_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.Temporal";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setValue(this.buildValue(astRoot));
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.value);
    }

    @Override
    public TemporalType getValue() {
        return this.value;
    }

    @Override
    public void setValue(TemporalType value) {
        if (this.attributeValueHasNotChanged((Object)this.value, (Object)value)) {
            return;
        }
        TemporalType old = this.value;
        this.value = value;
        this.valueAdapter.setValue(TemporalType.toJavaAnnotationValue(value));
        this.firePropertyChanged("value", (Object)old, (Object)value);
    }

    private TemporalType buildValue(CompilationUnit astRoot) {
        return TemporalType.fromJavaAnnotationValue(this.valueAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(VALUE_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "value");
    }
}

