/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Counter;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class CounterTests
extends TestCase {
    public CounterTests(String name) {
        super(name);
    }

    public void testCtors() {
        Counter counter = new Counter();
        CounterTests.assertEquals((int)0, (int)counter.count());
        counter = new Counter(7);
        CounterTests.assertEquals((int)7, (int)counter.count());
        counter = new Counter(-7);
        CounterTests.assertEquals((int)-7, (int)counter.count());
    }

    public void testIncrement() {
        Counter counter = new Counter();
        CounterTests.assertEquals((int)0, (int)counter.count());
        int count = counter.increment(3);
        CounterTests.assertEquals((int)3, (int)count);
        CounterTests.assertEquals((int)3, (int)counter.count());
        count = counter.increment();
        CounterTests.assertEquals((int)4, (int)count);
        CounterTests.assertEquals((int)4, (int)counter.count());
        count = counter.increment(-7);
        CounterTests.assertEquals((int)-3, (int)count);
        CounterTests.assertEquals((int)-3, (int)counter.count());
    }

    public void testDecrement() {
        Counter counter = new Counter();
        CounterTests.assertEquals((int)0, (int)counter.count());
        int count = counter.decrement(3);
        CounterTests.assertEquals((int)-3, (int)count);
        CounterTests.assertEquals((int)-3, (int)counter.count());
        count = counter.decrement();
        CounterTests.assertEquals((int)-4, (int)count);
        CounterTests.assertEquals((int)-4, (int)counter.count());
        count = counter.decrement(-7);
        CounterTests.assertEquals((int)3, (int)count);
        CounterTests.assertEquals((int)3, (int)counter.count());
    }

    public void testClone() {
        Counter counter = new Counter(44);
        Counter counter2 = (Counter)counter.clone();
        CounterTests.assertEquals((int)44, (int)counter2.count());
        CounterTests.assertEquals((Object)counter, (Object)counter2);
        CounterTests.assertNotSame((Object)counter, (Object)counter2);
    }

    public void testEquals() {
        Counter counter = new Counter(44);
        Counter counter2 = new Counter(44);
        CounterTests.assertEquals((Object)counter, (Object)counter2);
        CounterTests.assertEquals((int)counter.hashCode(), (int)counter2.hashCode());
    }

    public void testSerialization() throws Exception {
        Counter counter = new Counter(44);
        Counter counter2 = TestTools.serialize(counter);
        CounterTests.assertEquals((int)44, (int)counter2.count());
        CounterTests.assertEquals((Object)counter, (Object)counter2);
        CounterTests.assertNotSame((Object)counter, (Object)counter2);
    }
}

