/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneIteratorTests
extends TestCase {
    Collection<String> originalCollection;
    private boolean concurrentProblem;
    private Collection<String> concurrentCollection;

    public CloneIteratorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.originalCollection = this.buildCollection();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testHasNext() {
        int originalSize = this.originalCollection.size();
        int i = 0;
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            stream.next();
            this.originalCollection.add("foo");
            ++i;
        }
        CloneIteratorTests.assertTrue((originalSize != this.originalCollection.size() ? 1 : 0) != 0);
        CloneIteratorTests.assertEquals((int)originalSize, (int)i);
    }

    public void testNext() {
        Iterator<String> nestedIterator = this.originalCollection.iterator();
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            CloneIteratorTests.assertEquals((String)"bogus element", (String)nestedIterator.next(), (String)stream.next());
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildCloneIterator();
        String string = null;
        while (stream.hasNext()) {
            string = stream.next();
        }
        try {
            string = stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CloneIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testRemoveDefault() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildCloneIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        CloneIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testRemoveEliminator() {
        CloneIterator.Mutator<String> eliminator = new CloneIterator.Mutator<String>(){

            public void remove(String current) {
                CloneIteratorTests.this.originalCollection.remove(current);
            }
        };
        this.verifyRemove((Iterator<String>)new CloneIterator(this.originalCollection, (CloneIterator.Mutator)eliminator));
    }

    public void testRemoveSubclass() {
        this.verifyRemove((Iterator<String>)new CloneIterator<String>(this.originalCollection){

            protected void remove(String current) {
                CloneIteratorTests.this.originalCollection.remove(current);
            }
        });
    }

    public void testConcurrentAccess() throws Exception {
        SlowCollection<String> slow = new SlowCollection<String>();
        this.populateCollection(slow);
        this.originalCollection = Collections.synchronizedCollection(slow);
        this.concurrentProblem = false;
        this.concurrentCollection = new ArrayList<String>();
        Thread thread = new Thread(this.buildRunnable());
        thread.start();
        while (!slow.hasStartedClone()) {
            Thread.yield();
        }
        this.originalCollection.add("seventeen");
        while (thread.isAlive()) {
            Thread.yield();
        }
        CloneIteratorTests.assertFalse((boolean)this.concurrentProblem);
        ArrayList<String> expected = new ArrayList<String>();
        this.populateCollection(expected);
        CloneIteratorTests.assertEquals(expected, this.concurrentCollection);
    }

    private Runnable buildRunnable() {
        return new Runnable(){

            public void run() {
                CloneIteratorTests.this.loopWithCloneIterator();
            }
        };
    }

    void loopWithCloneIterator() {
        try {
            Iterator<String> stream = this.buildCloneIterator();
            while (stream.hasNext()) {
                this.concurrentCollection.add(stream.next());
            }
        }
        catch (Throwable throwable) {
            this.concurrentProblem = true;
        }
    }

    private void verifyRemove(Iterator<String> iterator) {
        String removed = "three";
        CloneIteratorTests.assertTrue((boolean)this.originalCollection.contains(removed));
        boolean exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        CloneIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        while (iterator.hasNext()) {
            if (!iterator.next().equals(removed)) continue;
            iterator.remove();
            exCaught = false;
            try {
                iterator.remove();
            }
            catch (IllegalStateException illegalStateException) {
                exCaught = true;
            }
            CloneIteratorTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        }
        CloneIteratorTests.assertFalse((boolean)this.originalCollection.contains(removed));
    }

    private Iterator<String> buildCloneIterator() {
        return this.buildCloneIterator(this.originalCollection);
    }

    private Iterator<String> buildCloneIterator(Collection<String> c) {
        return new CloneIterator(c);
    }

    private Collection<String> buildCollection() {
        Collection<String> c = this.buildEmptyCollection();
        this.populateCollection(c);
        return c;
    }

    protected Collection<String> buildEmptyCollection() {
        return new ArrayList<String>();
    }

    private void populateCollection(Collection<String> c) {
        c.add("one");
        c.add("two");
        c.add("three");
        c.add("four");
        c.add("five");
        c.add("six");
        c.add("seven");
        c.add("eight");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SlowCollection<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private boolean hasStartedClone = false;

        @Override
        public Object[] toArray() {
            this.setHasStartedClone(true);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return super.toArray();
        }

        synchronized void setHasStartedClone(boolean hasStartedClone) {
            this.hasStartedClone = hasStartedClone;
        }

        synchronized boolean hasStartedClone() {
            return this.hasStartedClone;
        }
    }
}

